/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.ssh;

import java.io.IOException;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.apache.xmlrpc.XmlRpcException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.ssh.GitSSHHandler;

public class GitSSHXmlRcpClient
implements GitSSHHandler {
    @Nullable
    private final XmlRpcClientLite myClient;

    GitSSHXmlRcpClient(int port, boolean batchMode) throws IOException {
        this.myClient = batchMode ? null : new XmlRpcClientLite("localhost", port);
    }

    @Override
    public boolean verifyServerHostKey(int handler, String hostname, int port, String serverHostKeyAlgorithm, String serverHostKey, boolean isNew) {
        if (this.myClient == null) {
            return false;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(handler);
        parameters.add(hostname);
        parameters.add(port);
        parameters.add(serverHostKeyAlgorithm);
        parameters.add(serverHostKey);
        parameters.add(isNew);
        try {
            return (Boolean)this.myClient.execute(GitSSHXmlRcpClient.methodName("verifyServerHostKey"), parameters);
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    private static String methodName(@NonNls String method) {
        return "Git4ideaSSHHandler." + method;
    }

    @Override
    @Nullable
    public String askPassphrase(int handler, String username, String keyPath, boolean resetPassword, String lastError) {
        if (this.myClient == null) {
            return null;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(handler);
        parameters.add(username);
        parameters.add(keyPath);
        parameters.add(resetPassword);
        parameters.add(lastError);
        try {
            return GitSSHXmlRcpClient.adjustNull((String)this.myClient.execute(GitSSHXmlRcpClient.methodName("askPassphrase"), parameters));
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Override
    @Nullable
    public Vector<String> replyToChallenge(int handlerNo, String username, String name, String instruction, int numPrompts, Vector<String> prompt, Vector<Boolean> echo, String lastError) {
        if (this.myClient == null) {
            return null;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(handlerNo);
        parameters.add(username);
        parameters.add(name);
        parameters.add(instruction);
        parameters.add(numPrompts);
        parameters.add(prompt);
        parameters.add(echo);
        parameters.add(lastError);
        try {
            return GitSSHXmlRcpClient.adjustNull((Vector)this.myClient.execute(GitSSHXmlRcpClient.methodName("replyToChallenge"), parameters));
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Override
    @Nullable
    public String askPassword(int handlerNo, String username, boolean resetPassword, String lastError) {
        if (this.myClient == null) {
            return null;
        }
        Vector<Object> parameters = new Vector<Object>();
        parameters.add(handlerNo);
        parameters.add(username);
        parameters.add(resetPassword);
        parameters.add(lastError);
        try {
            return GitSSHXmlRcpClient.adjustNull((String)this.myClient.execute(GitSSHXmlRcpClient.methodName("askPassword"), parameters));
        }
        catch (XmlRpcException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Invocation failed " + e.getMessage(), e);
        }
    }

    @Nullable
    private static String adjustNull(String s) {
        return s.charAt(0) == '-' ? null : s.substring(1);
    }

    @Nullable
    private static <T> Vector<T> adjustNull(Vector<T> s) {
        return s.size() == 0 ? null : s;
    }
}

