/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.view;

import com.intellij.openapi.ui.Messages;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.generate.tostring.config.Config;
import org.jetbrains.generate.tostring.config.DuplicatonPolicy;
import org.jetbrains.generate.tostring.config.InsertWhere;
import org.jetbrains.generate.tostring.config.PolicyOptions;
import org.jetbrains.generate.tostring.exception.PluginException;
import org.jetbrains.generate.tostring.template.TemplateResource;
import org.jetbrains.generate.tostring.velocity.VelocityFactory;

public class ConfigUI
extends JPanel {
    private final Border etched = BorderFactory.createEtchedBorder(1);
    private final JCheckBox fullyQualifiedName = new JCheckBox("Use fully qualified classname in code generation ($classname)");
    private final JCheckBox enableMethods = new JCheckBox("Enable getters in code generation ($methods)");
    private final JCheckBox moveCaretToMethod = new JCheckBox("Move caret to generated method");
    private JRadioButton[] initialValueForReplaceDialog;
    private JRadioButton[] initialValueForNewMethodDialog;
    private final JCheckBox filterConstant = new JCheckBox("Exclude all constant fields");
    private final JCheckBox filterEnum = new JCheckBox("Exclude all enum fields");
    private final JCheckBox filterStatic = new JCheckBox("Exclude all static fields");
    private final JCheckBox filterTransient = new JCheckBox("Exclude all transient fields");
    private final JCheckBox filterLoggers = new JCheckBox("Exclude all logger fields (Log4j, JDK Logging, Jakarta Commons Logging)");
    private final JTextField filterFieldName = new JTextField();
    private final JTextField filterFieldType = new JTextField();
    private final JTextField filterMethodName = new JTextField();
    private final JTextField filterMethodType = new JTextField();
    private final JComboBox sortElementsComboBox = new JComboBox();
    private final JCheckBox sortElements = new JCheckBox("Sort elements");
    private final JCheckBox autoAddImplementsSerializable = new JCheckBox("Automatic add implements java.io.Serializable");

    public ConfigUI(Config config) {
        super(new BorderLayout());
        this.init();
        this.setConfig(config);
    }

    private void init() {
        JPanel header = new JPanel(new BorderLayout());
        header.add((Component)this.initSettingPanel(), "West");
        this.add((Component)header, "North");
    }

    private JPanel initSettingPanel() {
        GridBagConstraints constraint = new GridBagConstraints();
        JPanel outer = new JPanel();
        outer.setLayout(new GridBagLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(this.etched, "Settings"));
        Box innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.fullyQualifiedName);
        innerPanel.add(Box.createHorizontalGlue());
        panel.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.enableMethods);
        innerPanel.add(Box.createHorizontalGlue());
        panel.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.moveCaretToMethod);
        innerPanel.add(Box.createHorizontalGlue());
        panel.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.sortElements);
        this.sortElements.addActionListener(new OnSortElements());
        innerPanel.add(Box.createHorizontalStrut(3));
        innerPanel.add(this.sortElementsComboBox);
        panel.add(innerPanel);
        this.sortElementsComboBox.addItem("Ascending");
        this.sortElementsComboBox.addItem("Descending");
        constraint.gridwidth = 0;
        constraint.fill = 1;
        constraint.gridx = 0;
        constraint.gridy = 0;
        outer.add((Component)panel, constraint);
        DuplicatonPolicy[] options = PolicyOptions.getConflictOptions();
        this.initialValueForReplaceDialog = new JRadioButton[options.length];
        ButtonGroup selection = new ButtonGroup();
        for (int i = 0; i < options.length; ++i) {
            this.initialValueForReplaceDialog[i] = new JRadioButton(new ConflictResolutionOptionAction(options[i]));
            selection.add(this.initialValueForReplaceDialog[i]);
        }
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(this.etched, "When method already exists"));
        for (JRadioButton anInitialValueForReplaceDialog : this.initialValueForReplaceDialog) {
            panel.add(anInitialValueForReplaceDialog);
        }
        constraint.gridx = 0;
        constraint.gridy = 1;
        outer.add((Component)panel, constraint);
        InsertWhere[] options2 = PolicyOptions.getNewMethodOptions();
        this.initialValueForNewMethodDialog = new JRadioButton[options2.length];
        ButtonGroup selection2 = new ButtonGroup();
        for (int i = 0; i < options2.length; ++i) {
            this.initialValueForNewMethodDialog[i] = new JRadioButton(new InsertNewMethodOptionAction(options2[i]));
            selection2.add(this.initialValueForNewMethodDialog[i]);
        }
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(this.etched, "Where to insert?"));
        for (JRadioButton anInitialValueForNewMethodDialog : this.initialValueForNewMethodDialog) {
            panel.add(anInitialValueForNewMethodDialog);
        }
        constraint.gridx = 0;
        constraint.gridy = 2;
        outer.add((Component)panel, constraint);
        panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        panel.setBorder(BorderFactory.createTitledBorder(this.etched, "Exclude"));
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.filterConstant);
        innerPanel.add(Box.createHorizontalGlue());
        panel.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.filterStatic);
        innerPanel.add(Box.createHorizontalGlue());
        panel.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.filterTransient);
        innerPanel.add(Box.createHorizontalGlue());
        panel.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.filterEnum);
        innerPanel.add(Box.createHorizontalGlue());
        panel.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(this.filterLoggers);
        innerPanel.add(Box.createHorizontalGlue());
        panel.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(new JLabel("Exclude fields by name (reg exp)"));
        innerPanel.add(Box.createHorizontalStrut(3));
        innerPanel.add(this.filterFieldName);
        this.filterFieldName.setMinimumSize(new Dimension(100, 20));
        panel.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(new JLabel("Exclude fields by typename (reg exp)"));
        innerPanel.add(Box.createHorizontalStrut(3));
        innerPanel.add(this.filterFieldType);
        this.filterFieldType.setMinimumSize(new Dimension(100, 20));
        panel.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(new JLabel("Exclude methods by name (reg exp)"));
        innerPanel.add(Box.createHorizontalStrut(3));
        innerPanel.add(this.filterMethodName);
        this.filterMethodName.setMinimumSize(new Dimension(100, 20));
        panel.add(innerPanel);
        innerPanel = Box.createHorizontalBox();
        innerPanel.add(new JLabel("Exclude methods by return typename (reg exp)"));
        innerPanel.add(Box.createHorizontalStrut(3));
        innerPanel.add(this.filterMethodType);
        this.filterMethodType.setMinimumSize(new Dimension(100, 20));
        panel.add(innerPanel);
        constraint.gridx = 0;
        constraint.gridy = 3;
        outer.add((Component)panel, constraint);
        return outer;
    }

    public final void setConfig(Config config) {
        this.fullyQualifiedName.setSelected(config.isUseFullyQualifiedName());
        DuplicatonPolicy option = config.getReplaceDialogInitialOption();
        for (JRadioButton anInitialValueForReplaceDialog : this.initialValueForReplaceDialog) {
            if (!anInitialValueForReplaceDialog.getText().equals(option.toString())) continue;
            anInitialValueForReplaceDialog.setSelected(true);
        }
        InsertWhere option2 = config.getInsertNewMethodInitialOption();
        for (JRadioButton anInitialValueForNewMethodDialog : this.initialValueForNewMethodDialog) {
            if (!anInitialValueForNewMethodDialog.getText().equals(option2.toString())) continue;
            anInitialValueForNewMethodDialog.setSelected(true);
        }
        this.filterConstant.setSelected(config.isFilterConstantField());
        this.filterEnum.setSelected(config.isFilterEnumField());
        this.filterStatic.setSelected(config.isFilterStaticModifier());
        this.filterTransient.setSelected(config.isFilterTransientModifier());
        this.filterLoggers.setSelected(config.isFilterLoggers());
        this.filterFieldName.setText(config.getFilterFieldName());
        this.filterFieldType.setText(config.getFilterFieldType());
        this.filterMethodName.setText(config.getFilterMethodName());
        this.filterMethodType.setText(config.getFilterMethodType());
        this.autoAddImplementsSerializable.setSelected(config.isAddImplementSerializable());
        this.enableMethods.setSelected(config.isEnableMethods());
        this.moveCaretToMethod.setSelected(config.isJumpToMethod());
        this.sortElements.setSelected(config.getSortElements() != 0);
        this.sortElementsComboBox.setEnabled(this.sortElements.isSelected());
        if (config.getSortElements() == 0 || config.getSortElements() == 1) {
            this.sortElementsComboBox.setSelectedIndex(0);
        } else if (config.getSortElements() == 2) {
            this.sortElementsComboBox.setSelectedIndex(1);
        }
    }

    @Nullable
    private static String emptyToNull(String s) {
        if (s != null && s.length() == 0) {
            return null;
        }
        return s;
    }

    public final Config getConfig() {
        Config config = new Config();
        config.setUseFullyQualifiedName(this.fullyQualifiedName.isSelected());
        for (JRadioButton anInitialValueForReplaceDialog : this.initialValueForReplaceDialog) {
            if (!anInitialValueForReplaceDialog.isSelected()) continue;
            config.setReplaceDialogInitialOption(((ConflictResolutionOptionAction)anInitialValueForReplaceDialog.getAction()).option);
        }
        for (JRadioButton anInitialValueForNewMethodDialog : this.initialValueForNewMethodDialog) {
            if (!anInitialValueForNewMethodDialog.isSelected()) continue;
            config.setInsertNewMethodInitialOption(((InsertNewMethodOptionAction)anInitialValueForNewMethodDialog.getAction()).option);
        }
        config.setFilterConstantField(this.filterConstant.isSelected());
        config.setFilterEnumField(this.filterEnum.isSelected());
        config.setFilterTransientModifier(this.filterTransient.isSelected());
        config.setFilterLoggers(this.filterLoggers.isSelected());
        config.setFilterStaticModifier(this.filterStatic.isSelected());
        config.setFilterFieldName(ConfigUI.emptyToNull(this.filterFieldName.getText()));
        config.setFilterFieldType(ConfigUI.emptyToNull(this.filterFieldType.getText()));
        config.setFilterMethodName(ConfigUI.emptyToNull(this.filterMethodName.getText()));
        config.setFilterMethodType(ConfigUI.emptyToNull(this.filterMethodType.getText()));
        config.setAddImplementSerializable(this.autoAddImplementsSerializable.isSelected());
        config.setEnableMethods(this.enableMethods.isSelected());
        config.setJumpToMethod(this.moveCaretToMethod.isSelected());
        if (!this.sortElements.isSelected()) {
            config.setSortElements(0);
        } else if (this.sortElementsComboBox.getSelectedIndex() == 0) {
            config.setSortElements(1);
        } else {
            config.setSortElements(2);
        }
        return config;
    }

    private class OnSyntaxCheck
    implements ActionListener {
        private final JTextArea methodBody = new JTextArea();

        private OnSyntaxCheck() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (!TemplateResource.isValidTemplate(this.methodBody.getText())) {
                Messages.showWarningDialog((String)"The template is incompatible with this version of the plugin.", (String)"Incompatible Template");
                return;
            }
            try {
                StringWriter sw = new StringWriter();
                VelocityContext vc = new VelocityContext();
                VelocityEngine velocity = VelocityFactory.getVelocityEngine();
                velocity.evaluate((Context)vc, (Writer)sw, "org.intellij.idea.plugin.tostring.view.ConfigUI$OnSyntaxCheck", this.methodBody.getText());
                Messages.showMessageDialog((String)"Syntax check complete - no errors found", (String)"Syntax Check", (Icon)Messages.getInformationIcon());
            }
            catch (ParseErrorException e) {
                Messages.showMessageDialog((String)("Syntax Error:\n" + e.getMessage()), (String)"Syntax Error", (Icon)Messages.getErrorIcon());
            }
            catch (Exception e) {
                throw new PluginException("Error syntax checking template", e);
            }
        }
    }

    private class OnSortElements
    implements ActionListener {
        private OnSortElements() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConfigUI.this.sortElementsComboBox.setEnabled(ConfigUI.this.sortElements.isSelected());
        }
    }

    private static class InsertNewMethodOptionAction
    extends AbstractAction {
        public final InsertWhere option;

        InsertNewMethodOptionAction(InsertWhere option) {
            super(option.toString());
            this.option = option;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class ConflictResolutionOptionAction
    extends AbstractAction {
        public final DuplicatonPolicy option;

        ConflictResolutionOptionAction(DuplicatonPolicy option) {
            super(option.toString());
            this.option = option;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

