/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cvsSupport2.connections.ssh;

import com.intellij.cvsSupport2.connections.ssh.ConnectionPoolI;
import com.intellij.cvsSupport2.connections.ssh.SshAuthentication;
import com.intellij.cvsSupport2.connections.ssh.SshLogger;
import com.intellij.cvsSupport2.connections.ssh.SshSharedConnection;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.util.Alarm;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.netbeans.lib.cvsclient.connection.ConnectionSettings;
import org.netbeans.lib.cvsclient.connection.IConnection;

public class SshConnectionPool
implements ConnectionPoolI {
    private static final int CONTROL_INTERVAL = 610000;
    private final Map<MyKey, SshSharedConnection> myPool = new HashMap<MyKey, SshSharedConnection>();
    private final Object myLock = new Object();
    private Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, (Disposable)ApplicationManager.getApplication());

    public static SshConnectionPool getInstance() {
        return (SshConnectionPool)ServiceManager.getService(SshConnectionPool.class);
    }

    private SshConnectionPool() {
        this.myAlarm.addRequest(new Runnable(){

            @Override
            public void run() {
                SshConnectionPool.this.controlPoolState();
                SshConnectionPool.this.myAlarm.addRequest((Runnable)this, 610000);
            }
        }, 610000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void controlPoolState() {
        Object object = this.myLock;
        synchronized (object) {
            SshLogger.debug("control pool state invoked");
            for (SshSharedConnection connection : this.myPool.values()) {
                connection.controlSelf();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public IConnection getConnection(String repository, ConnectionSettings connectionSettings, SshAuthentication authentication) {
        MyKey key = connectionSettings.isUseProxy() ? new MyKey(connectionSettings.getHostName(), connectionSettings.getPort(), connectionSettings.getProxyHostName(), connectionSettings.getProxyPort(), connectionSettings.getProxyLogin()) : new MyKey(connectionSettings.getHostName(), connectionSettings.getPort(), null, -1, null);
        Object object = this.myLock;
        synchronized (object) {
            SshSharedConnection connection = this.myPool.get(key);
            if (connection != null && !connection.isValid()) {
                SshLogger.debug("removing invalid connection from pool: " + connectionSettings.getHostName());
                this.myPool.remove(key);
                connection = null;
            }
            SshLogger.debug("(group of) connections found in pool: " + (connection != null));
            if (connection == null) {
                connection = new SshSharedConnection(repository, connectionSettings, authentication);
                this.myPool.put(key, connection);
            }
            SshLogger.debug("returning a ticket...");
            return connection.getTicket();
        }
    }

    private static class MyKey {
        private final String myHost;
        private final int myPort;
        private final String myProxyHost;
        private final int myProxyPort;
        private final String myProxyLogin;

        private MyKey(String host, int port, String proxyHost, int proxyPort, String proxyLogin) {
            this.myHost = host;
            this.myPort = port;
            this.myProxyHost = proxyHost;
            this.myProxyPort = proxyPort;
            this.myProxyLogin = proxyLogin;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MyKey myKey = (MyKey)o;
            if (this.myPort != myKey.myPort) {
                return false;
            }
            if (this.myProxyPort != myKey.myProxyPort) {
                return false;
            }
            if (!this.myHost.equals(myKey.myHost)) {
                return false;
            }
            if (this.myProxyHost != null ? !this.myProxyHost.equals(myKey.myProxyHost) : myKey.myProxyHost != null) {
                return false;
            }
            return !(this.myProxyLogin != null ? !this.myProxyLogin.equals(myKey.myProxyLogin) : myKey.myProxyLogin != null);
        }

        public int hashCode() {
            int result = this.myHost.hashCode();
            result = 31 * result + this.myPort;
            result = 31 * result + (this.myProxyHost != null ? this.myProxyHost.hashCode() : 0);
            result = 31 * result + this.myProxyPort;
            result = 31 * result + (this.myProxyLogin != null ? this.myProxyLogin.hashCode() : 0);
            return result;
        }
    }
}

