/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.generate;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.util.Function;
import com.intellij.util.xml.DomElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomBundle;
import org.jetbrains.idea.maven.dom.generate.MavenCodeInsightGenerateAction;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomRepository;

public class MavenGenerateDomActionGroup
extends DefaultActionGroup {
    public MavenGenerateDomActionGroup() {
        Function<MavenDomProjectModel, DomElement> dependenciesFunction = new Function<MavenDomProjectModel, DomElement>(){

            public DomElement fun(MavenDomProjectModel mavenDomProjectModel) {
                return mavenDomProjectModel.getDependencies();
            }
        };
        this.add((AnAction)MavenGenerateDomActionGroup.createAction(MavenDomBundle.message("generate.dependency.artifact", new Object[0]), MavenDomDependency.class, "maven-dependency-artifact", dependenciesFunction));
        this.add((AnAction)MavenGenerateDomActionGroup.createAction(MavenDomBundle.message("generate.dependency.group", new Object[0]), MavenDomDependency.class, "maven-dependency", dependenciesFunction));
        Function<MavenDomProjectModel, DomElement> pluginFunction = new Function<MavenDomProjectModel, DomElement>(){

            public DomElement fun(MavenDomProjectModel mavenDomProjectModel) {
                return mavenDomProjectModel.getBuild().getPlugins();
            }
        };
        this.add((AnAction)MavenGenerateDomActionGroup.createAction(MavenDomBundle.message("generate.plugin.artifact", new Object[0]), MavenDomPlugin.class, "maven-plugin-artifact-first", pluginFunction));
        this.add((AnAction)MavenGenerateDomActionGroup.createAction(MavenDomBundle.message("generate.plugin.group", new Object[0]), MavenDomPlugin.class, "maven-plugin", pluginFunction));
        this.add(MavenGenerateDomActionGroup.createAction(MavenDomRepository.class, "maven-repository", new Function<MavenDomProjectModel, DomElement>(){

            public DomElement fun(MavenDomProjectModel mavenDomProjectModel) {
                return mavenDomProjectModel.getRepositories();
            }
        }));
    }

    private static MavenCodeInsightGenerateAction createAction(String actionDescription, Class<? extends DomElement> aClass, @NonNls @Nullable String mappingId, @NotNull Function<MavenDomProjectModel, DomElement> parentFunction) {
        if (parentFunction == null) {
            throw new IllegalArgumentException("Argument 3 for @NotNull parameter of org/jetbrains/idea/maven/dom/generate/MavenGenerateDomActionGroup.createAction must not be null");
        }
        return new MavenCodeInsightGenerateAction(actionDescription, aClass, mappingId, parentFunction);
    }

    protected static AnAction createAction(Class<? extends DomElement> aClass, @NonNls @Nullable String mappingId, @NotNull Function<MavenDomProjectModel, DomElement> parentFunction) {
        if (parentFunction == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of org/jetbrains/idea/maven/dom/generate/MavenGenerateDomActionGroup.createAction must not be null");
        }
        return new MavenCodeInsightGenerateAction(aClass, mappingId, parentFunction);
    }
}

