/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.facet.FacetManager;
import com.intellij.facet.ModifiableFacetModel;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.artifacts.ModifiableArtifactModel;
import java.util.Collection;
import org.jetbrains.idea.maven.importing.MavenBaseModifiableModelsProvider;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenDefaultModifiableModelsProvider
extends MavenBaseModifiableModelsProvider {
    private final LibraryTable.ModifiableModel myLibrariesModel;

    public MavenDefaultModifiableModelsProvider(Project project) {
        super(project);
        this.myLibrariesModel = ProjectLibraryTable.getInstance((Project)this.myProject).getModifiableModel();
    }

    @Override
    protected ModifiableArtifactModel doGetArtifactModel() {
        return (ModifiableArtifactModel)new ReadAction<ModifiableArtifactModel>(){

            protected void run(Result<ModifiableArtifactModel> result) {
                result.setResult((Object)ArtifactManager.getInstance((Project)MavenDefaultModifiableModelsProvider.this.myProject).createModifiableModel());
            }
        }.execute().getResultObject();
    }

    @Override
    protected ModifiableModuleModel doGetModuleModel() {
        return (ModifiableModuleModel)new ReadAction<ModifiableModuleModel>(){

            protected void run(Result<ModifiableModuleModel> result) throws Throwable {
                result.setResult((Object)ModuleManager.getInstance((Project)MavenDefaultModifiableModelsProvider.this.myProject).getModifiableModel());
            }
        }.execute().getResultObject();
    }

    @Override
    protected ModifiableRootModel doGetRootModel(final Module module) {
        return (ModifiableRootModel)new ReadAction<ModifiableRootModel>(){

            protected void run(Result<ModifiableRootModel> result) throws Throwable {
                result.setResult((Object)ModuleRootManager.getInstance((Module)module).getModifiableModel());
            }
        }.execute().getResultObject();
    }

    @Override
    protected ModifiableFacetModel doGetFacetModel(Module module) {
        return FacetManager.getInstance((Module)module).createModifiableModel();
    }

    @Override
    public Library[] getAllLibraries() {
        return this.myLibrariesModel.getLibraries();
    }

    @Override
    public Library getLibraryByName(String name) {
        return this.myLibrariesModel.getLibraryByName(name);
    }

    @Override
    public Library createLibrary(String name) {
        return this.myLibrariesModel.createLibrary(name);
    }

    @Override
    public void removeLibrary(Library library) {
        this.myLibrariesModel.removeLibrary(library);
    }

    @Override
    protected Library.ModifiableModel doGetLibraryModel(Library library) {
        return library.getModifiableModel();
    }

    @Override
    public void commit() {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, new Runnable(){

            @Override
            public void run() {
                MavenDefaultModifiableModelsProvider.this.processExternalArtifactDependencies();
                for (Library.ModifiableModel each : MavenDefaultModifiableModelsProvider.this.myLibraryModels.values()) {
                    each.commit();
                }
                MavenDefaultModifiableModelsProvider.this.myLibrariesModel.commit();
                Collection rootModels = MavenDefaultModifiableModelsProvider.this.myRootModels.values();
                ProjectRootManager.getInstance((Project)MavenDefaultModifiableModelsProvider.this.myProject).multiCommit(MavenDefaultModifiableModelsProvider.this.myModuleModel, rootModels.toArray(new ModifiableRootModel[rootModels.size()]));
                for (ModifiableFacetModel each : MavenDefaultModifiableModelsProvider.this.myFacetModels.values()) {
                    each.commit();
                }
                if (MavenDefaultModifiableModelsProvider.this.myArtifactModel != null) {
                    MavenDefaultModifiableModelsProvider.this.myArtifactModel.commit();
                }
            }
        });
    }

    @Override
    public void dispose() {
        MavenUtil.invokeAndWaitWriteAction(this.myProject, new Runnable(){

            @Override
            public void run() {
                for (ModifiableRootModel each : MavenDefaultModifiableModelsProvider.this.myRootModels.values()) {
                    each.dispose();
                }
                MavenDefaultModifiableModelsProvider.this.myModuleModel.dispose();
                if (MavenDefaultModifiableModelsProvider.this.myArtifactModel != null) {
                    MavenDefaultModifiableModelsProvider.this.myArtifactModel.dispose();
                }
            }
        });
    }

    @Override
    public ModalityState getModalityStateForQuestionDialogs() {
        return ModalityState.NON_MODAL;
    }
}

