/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;

public abstract class MavenImporter {
    public static ExtensionPointName<MavenImporter> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"org.jetbrains.idea.maven.importer");
    protected final String myPluginGroupID;
    protected final String myPluginArtifactID;

    public MavenImporter(String pluginGroupID, String pluginArtifactID) {
        this.myPluginGroupID = pluginGroupID;
        this.myPluginArtifactID = pluginArtifactID;
    }

    public static List<MavenImporter> getSuitableImporters(MavenProject p) {
        ArrayList<MavenImporter> result = new ArrayList<MavenImporter>();
        for (MavenImporter importer : (MavenImporter[])EXTENSION_POINT_NAME.getExtensions()) {
            if (!importer.isApplicable(p)) continue;
            result.add(importer);
        }
        return result;
    }

    public boolean isApplicable(MavenProject mavenProject) {
        return mavenProject.findPlugin(this.myPluginGroupID, this.myPluginArtifactID) != null;
    }

    public abstract boolean isSupportedDependency(MavenArtifact var1);

    @Nullable
    public Pair<String, String> getExtraArtifactClassifierAndExtension(MavenArtifact artifact, MavenExtraArtifactType type) {
        return null;
    }

    public void resolve(MavenProject project, org.apache.maven.project.MavenProject nativeMavenProject, MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
    }

    public abstract void preProcess(Module var1, MavenProject var2, MavenProjectChanges var3, MavenModifiableModelsProvider var4);

    public abstract void process(MavenModifiableModelsProvider var1, Module var2, MavenRootModelAdapter var3, MavenProjectsTree var4, MavenProject var5, MavenProjectChanges var6, Map<MavenProject, String> var7, List<MavenProjectsProcessorTask> var8);

    public void collectSourceFolders(MavenProject mavenProject, List<String> result) {
    }

    public void collectTestFolders(MavenProject mavenProject, List<String> result) {
    }

    public void collectExcludedFolders(MavenProject mavenProject, List<String> result) {
    }

    @Nullable
    protected Element getConfig(MavenProject p) {
        return p.getPluginConfiguration(this.myPluginGroupID, this.myPluginArtifactID);
    }

    @Nullable
    protected Element getConfig(MavenProject p, String path) {
        return MavenJDOMUtil.findChildByPath(this.getConfig(p), path);
    }

    @Nullable
    protected String findConfigValue(MavenProject p, String path) {
        return MavenJDOMUtil.findChildValueByPath(this.getConfig(p), path);
    }

    @Nullable
    protected String findConfigValue(MavenProject p, String path, String defaultValue) {
        return MavenJDOMUtil.findChildValueByPath(this.getConfig(p), path, defaultValue);
    }

    @Nullable
    protected Element getGoalConfig(MavenProject p, String goal) {
        return p.getPluginGoalConfiguration(this.myPluginGroupID, this.myPluginArtifactID, goal);
    }

    @Nullable
    protected String findGoalConfigValue(MavenProject p, String goal, String path) {
        return MavenJDOMUtil.findChildValueByPath(this.getGoalConfig(p, goal), path);
    }
}

