/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.java.LanguageLevel;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenModifiableModelsProvider;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenModuleImporter {
    private final Module myModule;
    private final MavenProjectsTree myMavenTree;
    private final MavenProject myMavenProject;
    private final MavenProjectChanges myMavenProjectChanges;
    private final Map<MavenProject, String> myMavenProjectToModuleName;
    private final MavenImportingSettings mySettings;
    private final MavenModifiableModelsProvider myModifiableModelsProvider;
    private MavenRootModelAdapter myRootModelAdapter;

    public MavenModuleImporter(Module module, MavenProjectsTree mavenTree, Pair<MavenProject, MavenProjectChanges> mavenProjectWithChanges, Map<MavenProject, String> mavenProjectToModuleName, MavenImportingSettings settings, MavenModifiableModelsProvider modifiableModelsProvider) {
        this.myModule = module;
        this.myMavenTree = mavenTree;
        this.myMavenProject = (MavenProject)mavenProjectWithChanges.first;
        this.myMavenProjectChanges = (MavenProjectChanges)mavenProjectWithChanges.second;
        this.myMavenProjectToModuleName = mavenProjectToModuleName;
        this.mySettings = settings;
        this.myModifiableModelsProvider = modifiableModelsProvider;
    }

    public ModifiableRootModel getRootModel() {
        return this.myRootModelAdapter.getRootModel();
    }

    public void config(boolean isNewlyCreatedModule) {
        this.myRootModelAdapter = new MavenRootModelAdapter(this.myMavenProject, this.myModule, this.myModifiableModelsProvider);
        this.myRootModelAdapter.init(isNewlyCreatedModule);
        this.configFolders();
        this.configDependencies();
        this.configLanguageLevel();
    }

    public void preConfigFacets() {
        for (final MavenImporter importer : this.getSuitableImporters()) {
            MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), new Runnable(){

                @Override
                public void run() {
                    importer.preProcess(MavenModuleImporter.this.myModule, MavenModuleImporter.this.myMavenProject, MavenModuleImporter.this.myMavenProjectChanges, MavenModuleImporter.this.myModifiableModelsProvider);
                }
            });
        }
    }

    public void configFacets(final List<MavenProjectsProcessorTask> postTasks) {
        for (final MavenImporter importer : this.getSuitableImporters()) {
            MavenUtil.invokeAndWaitWriteAction(this.myModule.getProject(), new Runnable(){

                @Override
                public void run() {
                    importer.process(MavenModuleImporter.this.myModifiableModelsProvider, MavenModuleImporter.this.myModule, MavenModuleImporter.this.myRootModelAdapter, MavenModuleImporter.this.myMavenTree, MavenModuleImporter.this.myMavenProject, MavenModuleImporter.this.myMavenProjectChanges, MavenModuleImporter.this.myMavenProjectToModuleName, postTasks);
                }
            });
        }
    }

    private List<MavenImporter> getSuitableImporters() {
        return this.myMavenProject.getSuitableImporters();
    }

    private void configFolders() {
        new MavenFoldersImporter(this.myMavenProject, this.mySettings, this.myRootModelAdapter).config();
    }

    private void configDependencies() {
        for (MavenArtifact artifact : this.myMavenProject.getDependencies()) {
            DependencyScope scope = this.selectScope(artifact.getScope());
            MavenProject depProject = this.myMavenTree.findProject(artifact.getMavenId());
            if (depProject != null) {
                this.myRootModelAdapter.addModuleDependency(this.myMavenProjectToModuleName.get(depProject), scope);
                continue;
            }
            if (!this.myMavenProject.isSupportedDependency(artifact)) continue;
            this.myRootModelAdapter.addLibraryDependency(artifact, scope, this.myModifiableModelsProvider, this.myMavenProject);
        }
    }

    private DependencyScope selectScope(String mavenScope) {
        if ("runtime".equals(mavenScope)) {
            return DependencyScope.RUNTIME;
        }
        if ("test".equals(mavenScope)) {
            return DependencyScope.TEST;
        }
        if ("provided".equals(mavenScope)) {
            return DependencyScope.PROVIDED;
        }
        return DependencyScope.COMPILE;
    }

    private void configLanguageLevel() {
        LanguageLevel level = this.translateLanguageLevel(this.myMavenProject.getSourceLevel());
        this.myRootModelAdapter.setLanguageLevel(level);
    }

    @Nullable
    private LanguageLevel translateLanguageLevel(@Nullable String level) {
        if ("1.3".equals(level)) {
            return LanguageLevel.JDK_1_3;
        }
        if ("1.4".equals(level)) {
            return LanguageLevel.JDK_1_4;
        }
        if ("1.5".equals(level)) {
            return LanguageLevel.JDK_1_5;
        }
        if ("1.6".equals(level)) {
            return LanguageLevel.JDK_1_6;
        }
        return null;
    }
}

