/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.indices;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.DefaultArtifactRepository;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.repository.Repository;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.sonatype.nexus.index.updater.ResourceFetcher;

public class MavenIndexFetcher
implements ResourceFetcher {
    private final String myOriginalRepositoryId;
    private final String myOriginalRepositoryUrl;
    private final WagonManager myWagonManager;
    private final TransferListener myListener;
    private Wagon myWagon = null;

    public MavenIndexFetcher(String originalRepositoryId, String originalRepositoryUrl, WagonManager wagonManager, TransferListener listener) {
        this.myOriginalRepositoryId = originalRepositoryId;
        this.myOriginalRepositoryUrl = originalRepositoryUrl;
        this.myWagonManager = wagonManager;
        this.myListener = listener;
    }

    public void connect(String _ignoredContextId, String _ignoredUrl) throws IOException {
        String mirrorUrl = this.myWagonManager.getMirrorRepository((ArtifactRepository)new DefaultArtifactRepository(this.myOriginalRepositoryId, this.myOriginalRepositoryUrl, null)).getUrl();
        String indexUrl = mirrorUrl + (mirrorUrl.endsWith("/") ? "" : "/") + ".index";
        Repository repository = new Repository(this.myOriginalRepositoryId, indexUrl);
        try {
            this.myWagon = this.myWagonManager.getWagon(repository);
            this.myWagon.addTransferListener(this.myListener);
            this.myWagon.connect(repository, this.myWagonManager.getAuthenticationInfo(repository.getId()), this.myWagonManager.getProxy(repository.getProtocol()));
        }
        catch (AuthenticationException e) {
            IOException newEx = new IOException("Authentication exception connecting to " + repository);
            newEx.initCause(e);
            throw newEx;
        }
        catch (WagonException e) {
            IOException newEx = new IOException("Wagon exception connecting to " + repository);
            newEx.initCause(e);
            throw newEx;
        }
    }

    public void disconnect() {
        if (this.myWagon == null) {
            return;
        }
        try {
            this.myWagon.disconnect();
        }
        catch (ConnectionException ex) {
            MavenLog.LOG.warn((Throwable)ex);
        }
    }

    public void retrieve(String name, File targetFile) throws IOException {
        try {
            this.myWagon.get(name, targetFile);
        }
        catch (AuthorizationException e) {
            IOException newEx = new IOException("Authorization exception retrieving " + name);
            newEx.initCause(e);
            throw newEx;
        }
        catch (ResourceDoesNotExistException e) {
            FileNotFoundException newEx = new FileNotFoundException("Resource " + name + " does not exist");
            newEx.initCause(e);
            throw newEx;
        }
        catch (WagonException e) {
            IOException newEx = new IOException("Transfer for " + name + " failed");
            newEx.initCause(e);
            throw newEx;
        }
    }
}

