/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.codehaus.plexus.component.repository.ComponentDependency;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.embedder.CustomArtifact;
import org.jetbrains.idea.maven.project.MavenId;

public class MavenArtifact
implements Serializable {
    private String myGroupId;
    private String myArtifactId;
    private String myVersion;
    private String myBaseVersion;
    private String myType;
    private String myClassifier;
    private String myScope;
    private boolean myOptional;
    private String myExtension;
    private File myFile;
    private boolean myResolved;
    private boolean myStubbed;
    private List<String> myTrail;

    protected MavenArtifact() {
    }

    public MavenArtifact(Artifact artifact, File localRepository) {
        this.myGroupId = artifact.getGroupId();
        this.myArtifactId = artifact.getArtifactId();
        this.myVersion = artifact.getVersion();
        this.myBaseVersion = artifact.getBaseVersion();
        this.myType = artifact.getType();
        this.myClassifier = artifact.getClassifier();
        this.myScope = artifact.getScope();
        this.myOptional = artifact.isOptional();
        this.myExtension = this.getExtension(artifact);
        this.myFile = artifact.getFile();
        if (this.myFile == null) {
            this.myFile = new File(localRepository, this.getRelativePath());
        }
        this.myResolved = artifact.isResolved();
        this.myStubbed = artifact instanceof CustomArtifact && ((CustomArtifact)artifact).isStub();
        List originalTrail = artifact.getDependencyTrail();
        this.myTrail = originalTrail == null || originalTrail.isEmpty() ? new ArrayList() : new ArrayList(originalTrail.subList(1, originalTrail.size()));
    }

    public MavenArtifact(ComponentDependency dependency, File localRepository, String scope) {
        this.myGroupId = dependency.getGroupId();
        this.myArtifactId = dependency.getArtifactId();
        this.myVersion = dependency.getVersion();
        this.myBaseVersion = null;
        this.myType = dependency.getType();
        this.myClassifier = null;
        this.myScope = scope;
        this.myOptional = false;
        this.myExtension = this.myType;
        this.myFile = new File(localRepository, this.getRelativePath());
        this.myResolved = true;
        this.myStubbed = false;
        this.myTrail = Collections.emptyList();
    }

    private String getExtension(Artifact artifact) {
        ArtifactHandler handler = artifact.getArtifactHandler();
        String result = null;
        if (handler != null) {
            result = handler.getExtension();
        }
        if (result == null) {
            result = artifact.getType();
        }
        return result;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public MavenId getMavenId() {
        return new MavenId(this.myGroupId, this.myArtifactId, this.myVersion);
    }

    public String getType() {
        return this.myType;
    }

    public String getClassifier() {
        return this.myClassifier;
    }

    public String getScope() {
        return this.myScope;
    }

    public boolean isOptional() {
        return this.myOptional;
    }

    public boolean isExportable() {
        if (this.myOptional) {
            return false;
        }
        return "compile".equals(this.myScope) || "runtime".equals(this.myScope);
    }

    public String getExtension() {
        return this.myExtension;
    }

    public boolean isResolved() {
        return this.myResolved && this.myFile.exists() && !this.myStubbed;
    }

    @NotNull
    public File getFile() {
        File file = this.myFile;
        if (file == null) {
            throw new IllegalStateException("@NotNull method org/jetbrains/idea/maven/project/MavenArtifact.getFile must not return null");
        }
        return file;
    }

    public String getPath() {
        return FileUtil.toSystemIndependentName((String)this.myFile.getPath());
    }

    public String getRelativePath() {
        return this.getRelativePathForExtraArtifact(null, null);
    }

    public String getRelativePathForExtraArtifact(@Nullable String extraArtifactClassifier, @Nullable String customExtension) {
        StringBuilder result = new StringBuilder();
        result.append(this.myGroupId.replace('.', '/'));
        result.append('/');
        result.append(this.myArtifactId);
        result.append('/');
        result.append(this.myVersion);
        result.append('/');
        result.append(this.myArtifactId);
        result.append('-');
        result.append(this.myVersion);
        if (!StringUtil.isEmptyOrSpaces((String)extraArtifactClassifier)) {
            if ("test-jar".equals(this.myType)) {
                result.append("-test");
            }
            result.append('-');
            result.append(extraArtifactClassifier);
        } else if (!StringUtil.isEmptyOrSpaces((String)this.myClassifier)) {
            result.append('-');
            result.append(this.myClassifier);
        }
        result.append(".");
        result.append(customExtension == null ? this.myExtension : customExtension);
        return result.toString();
    }

    public String getUrl() {
        return this.getUrlForExtraArtifact(null, null);
    }

    public String getUrlForExtraArtifact(@Nullable String extraArtifactClassifier, @Nullable String customExtension) {
        String path = this.getPath();
        if (!StringUtil.isEmptyOrSpaces((String)extraArtifactClassifier)) {
            int repoEnd = path.lastIndexOf(this.getRelativePath());
            if (repoEnd == -1) {
                int dotPos = path.lastIndexOf(".");
                if (dotPos != -1) {
                    String withoutExtension = path.substring(0, dotPos);
                    path = MessageFormat.format("{0}-{1}.{2}", withoutExtension, extraArtifactClassifier, customExtension == null ? this.myExtension : customExtension);
                }
            } else {
                String repoPath = path.substring(0, repoEnd);
                path = repoPath + this.getRelativePathForExtraArtifact(extraArtifactClassifier, customExtension);
            }
        }
        return VirtualFileManager.constructUrl((String)"jar", (String)path) + "!/";
    }

    public List<String> getTrail() {
        return this.myTrail;
    }

    public String getDisplayStringSimple() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myVersion);
        return builder.toString();
    }

    public String getDisplayStringWithType() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myType);
        MavenId.append(builder, this.myVersion);
        return builder.toString();
    }

    public String getDisplayStringWithTypeAndClassifier() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myType);
        if (!StringUtil.isEmptyOrSpaces((String)this.myClassifier)) {
            MavenId.append(builder, this.myClassifier);
        }
        MavenId.append(builder, this.myVersion);
        return builder.toString();
    }

    public String getDisplayStringFull() {
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        MavenId.append(builder, this.myType);
        if (!StringUtil.isEmptyOrSpaces((String)this.myClassifier)) {
            MavenId.append(builder, this.myClassifier);
        }
        MavenId.append(builder, this.myVersion);
        if (!StringUtil.isEmptyOrSpaces((String)this.myScope)) {
            MavenId.append(builder, this.myScope);
        }
        return builder.toString();
    }

    public String getDisplayStringForLibraryName() {
        String version;
        StringBuilder builder = new StringBuilder();
        MavenId.append(builder, this.myGroupId);
        MavenId.append(builder, this.myArtifactId);
        if (!StringUtil.isEmptyOrSpaces((String)this.myType) && !"jar".equals(this.myType)) {
            MavenId.append(builder, this.myType);
        }
        if (!StringUtil.isEmptyOrSpaces((String)this.myClassifier)) {
            MavenId.append(builder, this.myClassifier);
        }
        String string = version = !StringUtil.isEmptyOrSpaces((String)this.myBaseVersion) ? this.myBaseVersion : this.myVersion;
        if (!StringUtil.isEmptyOrSpaces((String)version)) {
            MavenId.append(builder, version);
        }
        return builder.toString();
    }

    public String toString() {
        return this.getDisplayStringFull();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenArtifact that = (MavenArtifact)o;
        if (this.myGroupId != null ? !this.myGroupId.equals(that.myGroupId) : that.myGroupId != null) {
            return false;
        }
        if (this.myArtifactId != null ? !this.myArtifactId.equals(that.myArtifactId) : that.myArtifactId != null) {
            return false;
        }
        if (this.myVersion != null ? !this.myVersion.equals(that.myVersion) : that.myVersion != null) {
            return false;
        }
        if (this.myBaseVersion != null ? !this.myBaseVersion.equals(that.myBaseVersion) : that.myBaseVersion != null) {
            return false;
        }
        if (this.myType != null ? !this.myType.equals(that.myType) : that.myType != null) {
            return false;
        }
        if (this.myClassifier != null ? !this.myClassifier.equals(that.myClassifier) : that.myClassifier != null) {
            return false;
        }
        if (this.myScope != null ? !this.myScope.equals(that.myScope) : that.myScope != null) {
            return false;
        }
        if (this.myExtension != null ? !this.myExtension.equals(that.myExtension) : that.myExtension != null) {
            return false;
        }
        if (this.myFile != null ? !this.myFile.equals(that.myFile) : that.myFile != null) {
            return false;
        }
        return !(this.myTrail != null ? !((Object)this.myTrail).equals(that.myTrail) : that.myTrail != null);
    }

    public int hashCode() {
        int result = this.myGroupId != null ? this.myGroupId.hashCode() : 0;
        result = 31 * result + (this.myArtifactId != null ? this.myArtifactId.hashCode() : 0);
        result = 31 * result + (this.myVersion != null ? this.myVersion.hashCode() : 0);
        result = 31 * result + (this.myBaseVersion != null ? this.myBaseVersion.hashCode() : 0);
        result = 31 * result + (this.myType != null ? this.myType.hashCode() : 0);
        result = 31 * result + (this.myClassifier != null ? this.myClassifier.hashCode() : 0);
        result = 31 * result + (this.myScope != null ? this.myScope.hashCode() : 0);
        result = 31 * result + (this.myExtension != null ? this.myExtension.hashCode() : 0);
        result = 31 * result + (this.myFile != null ? this.myFile.hashCode() : 0);
        result = 31 * result + (this.myTrail != null ? ((Object)this.myTrail).hashCode() : 0);
        return result;
    }
}

