/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.impl.ui.EditKeymapsDialog;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.utils.MavenDataKeys;
import org.jetbrains.idea.maven.utils.actions.MavenAction;
import org.jetbrains.idea.maven.utils.actions.MavenActionUtil;

public class AssignShortcutAction
extends MavenAction {
    @Override
    protected boolean isAvailable(AnActionEvent e) {
        return super.isAvailable(e) && !this.isIgnoredProject(e) && this.getGoalActionId(e) != null;
    }

    private boolean isIgnoredProject(AnActionEvent e) {
        MavenProject project = MavenActionUtil.getMavenProject(e);
        if (project == null) {
            return false;
        }
        return MavenActionUtil.getProjectsManager(e).isIgnored(project);
    }

    public void actionPerformed(AnActionEvent e) {
        String actionId = this.getGoalActionId(e);
        if (actionId != null) {
            new EditKeymapsDialog(MavenActionUtil.getProject(e), actionId).show();
        }
    }

    @Nullable
    private String getGoalActionId(AnActionEvent e) {
        MavenProject project = MavenActionUtil.getMavenProject(e);
        if (project == null) {
            return null;
        }
        List goals = (List)e.getData(MavenDataKeys.MAVEN_GOALS);
        String goal = goals == null || goals.size() != 1 ? null : (String)goals.get(0);
        return this.getShortcutsManager(e).getActionId(project.getPath(), goal);
    }

    protected MavenShortcutsManager getShortcutsManager(AnActionEvent e) {
        return MavenShortcutsManager.getInstance(MavenActionUtil.getProject(e));
    }
}

