/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;

public class Strings {
    @NonNls
    public static final String WHITESPACE = " \t\n\r\f";

    public static List<String> tokenize(String string, String delim) {
        ArrayList<String> tokens = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(string, delim);
        while (tokenizer.hasMoreTokens()) {
            tokens.add(tokenizer.nextToken());
        }
        return tokens;
    }

    public static String detokenize(Collection<String> list, char delim) {
        StringBuilder buffer = new StringBuilder();
        for (String goal : list) {
            if (buffer.length() != 0) {
                buffer.append(delim);
            }
            buffer.append(goal);
        }
        return buffer.toString();
    }

    public static String translateMasks(Collection<String> masks) {
        StringBuilder patterns = new StringBuilder();
        for (String mask : masks) {
            if (patterns.length() != 0) {
                patterns.append('|');
            }
            patterns.append(Strings.translateToRegex(mask));
        }
        return patterns.toString();
    }

    private static String translateToRegex(String mask) {
        return mask.replaceAll("\\.", "\\.").replaceAll("\\*", ".*").replaceAll("\\?", ".");
    }
}

