/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.wizards;

import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.SourcePathsBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.idea.maven.indices.ArchetypeInfo;
import org.jetbrains.idea.maven.project.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.wizards.MavenModuleBuilderHelper;
import org.jetbrains.idea.maven.wizards.MavenModuleWizardStep;

public class MavenModuleBuilder
extends ModuleBuilder
implements SourcePathsBuilder {
    private static final Icon BIG_ICON = IconLoader.getIcon((String)"/modules/javaModule.png");
    private String myContentRootPath;
    private MavenProject myAggregatorProject;
    private MavenProject myParentProject;
    private boolean myInheritGroupId;
    private boolean myInheritVersion;
    private MavenId myProjectId;
    private ArchetypeInfo myArchetype;

    public void setupRootModel(ModifiableRootModel rootModel) throws ConfigurationException {
        final Project project = rootModel.getProject();
        final VirtualFile root = this.createAndGetContentEntry();
        rootModel.addContentEntry(root);
        rootModel.inheritSdk();
        MavenUtil.runWhenInitialized(project, (Runnable)new DumbAwareRunnable(){

            public void run() {
                new MavenModuleBuilderHelper(MavenModuleBuilder.this.myProjectId, MavenModuleBuilder.this.myAggregatorProject, MavenModuleBuilder.this.myParentProject, MavenModuleBuilder.this.myInheritGroupId, MavenModuleBuilder.this.myInheritVersion, MavenModuleBuilder.this.myArchetype, "Create new Maven module").configure(project, root, false);
            }
        });
    }

    public String getBuilderId() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public String getPresentableName() {
        return "Maven Module";
    }

    public String getDescription() {
        return "Creates a blank Maven module or from Maven Archetype";
    }

    public Icon getBigIcon() {
        return BIG_ICON;
    }

    public ModuleType getModuleType() {
        return StdModuleTypes.JAVA;
    }

    public ModuleWizardStep[] createWizardSteps(WizardContext wizardContext, ModulesProvider modulesProvider) {
        return new ModuleWizardStep[]{new MavenModuleWizardStep(wizardContext.getProject(), this)};
    }

    public MavenProject findPotentialParentProject(Project project) {
        if (!MavenProjectsManager.getInstance(project).isMavenizedProject()) {
            return null;
        }
        File parentDir = new File(this.myContentRootPath).getParentFile();
        if (parentDir == null) {
            return null;
        }
        VirtualFile parentPom = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(parentDir, "pom.xml"));
        if (parentPom == null) {
            return null;
        }
        return MavenProjectsManager.getInstance(project).findProject(parentPom);
    }

    private VirtualFile createAndGetContentEntry() {
        String path = FileUtil.toSystemIndependentName((String)this.myContentRootPath);
        new File(path).mkdirs();
        return LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
    }

    public String getContentEntryPath() {
        return this.myContentRootPath;
    }

    public void setContentEntryPath(String path) {
        this.myContentRootPath = path;
    }

    public List<Pair<String, String>> getSourcePaths() {
        return Collections.emptyList();
    }

    public void setSourcePaths(List<Pair<String, String>> sourcePaths) {
    }

    public void addSourcePath(Pair<String, String> sourcePathInfo) {
    }

    public void setAggregatorProject(MavenProject project) {
        this.myAggregatorProject = project;
    }

    public MavenProject getAggregatorProject() {
        return this.myAggregatorProject;
    }

    public void setParentProject(MavenProject project) {
        this.myParentProject = project;
    }

    public MavenProject getParentProject() {
        return this.myParentProject;
    }

    public void setInheritedOptions(boolean groupId, boolean version) {
        this.myInheritGroupId = groupId;
        this.myInheritVersion = version;
    }

    public boolean isInheritGroupId() {
        return this.myInheritGroupId;
    }

    public boolean isInheritVersion() {
        return this.myInheritVersion;
    }

    public void setProjectId(MavenId id) {
        this.myProjectId = id;
    }

    public MavenId getProjectId() {
        return this.myProjectId;
    }

    public void setArchetype(ArchetypeInfo archetype) {
        this.myArchetype = archetype;
    }

    public ArchetypeInfo getArchetype() {
        return this.myArchetype;
    }
}

