/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.bind.marshaller;

import com.sun.istack.internal.FinalArrayList;
import com.sun.xml.internal.bind.marshaller.Messages;
import com.sun.xml.internal.bind.util.Which;
import java.util.Stack;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class SAX2DOMEx
implements ContentHandler {
    private Node node = null;
    private final Stack<Node> nodeStack = new Stack();
    private final FinalArrayList<String> unprocessedNamespaces = new FinalArrayList();
    private final Document document;

    public SAX2DOMEx(Node node) {
        this.node = node;
        this.nodeStack.push(this.node);
        this.document = node instanceof Document ? (Document)node : node.getOwnerDocument();
    }

    public SAX2DOMEx() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setValidating(false);
        this.document = factory.newDocumentBuilder().newDocument();
        this.node = this.document;
        this.nodeStack.push(this.document);
    }

    public final Element getCurrentElement() {
        return (Element)this.nodeStack.peek();
    }

    public Node getDOM() {
        return this.node;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String namespace, String localName, String qName, Attributes attrs) {
        Node parent = this.nodeStack.peek();
        Element element = this.document.createElementNS(namespace, qName);
        if (element == null) {
            throw new AssertionError((Object)Messages.format("SAX2DOMEx.DomImplDoesntSupportCreateElementNs", this.document.getClass().getName(), Which.which(this.document.getClass())));
        }
        for (int i = 0; i < this.unprocessedNamespaces.size(); i += 2) {
            String prefix = (String)this.unprocessedNamespaces.get(i + 0);
            String uri = (String)this.unprocessedNamespaces.get(i + 1);
            String qname = "".equals(prefix) || prefix == null ? "xmlns" : "xmlns:" + prefix;
            if (element.hasAttributeNS("http://www.w3.org/2000/xmlns/", qname)) {
                element.removeAttributeNS("http://www.w3.org/2000/xmlns/", qname);
            }
            element.setAttributeNS("http://www.w3.org/2000/xmlns/", qname, uri);
        }
        this.unprocessedNamespaces.clear();
        int length = attrs.getLength();
        for (int i = 0; i < length; ++i) {
            String namespaceuri = attrs.getURI(i);
            String value = attrs.getValue(i);
            String qname = attrs.getQName(i);
            element.setAttributeNS(namespaceuri, qname, value);
        }
        parent.appendChild(element);
        this.nodeStack.push(element);
    }

    @Override
    public void endElement(String namespace, String localName, String qName) {
        this.nodeStack.pop();
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        Node parent = this.nodeStack.peek();
        Text text = this.document.createTextNode(new String(ch, start, length));
        parent.appendChild(text);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        Node parent = this.nodeStack.peek();
        ProcessingInstruction node = this.document.createProcessingInstruction(target, data);
        parent.appendChild(node);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        this.unprocessedNamespaces.add(prefix);
        this.unprocessedNamespaces.add(uri);
    }

    @Override
    public void endPrefixMapping(String prefix) {
    }
}

