/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.CoordinateFormat;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.help.ContextSensitiveHelpAction;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.WindowGeometry;

public class LatLonDialog
extends JDialog {
    private static final Color BG_COLOR_ERROR = new Color(255, 224, 224);
    private JTextField tfLat;
    private JTextField tfLon;
    private String help;
    private boolean canceled = false;
    private LatLon coordinates;
    private OKAction actOK;
    private CancelAction actCancel;

    protected JPanel buildInputForm() {
        JPanel pnl = new JPanel(new GridBagLayout());
        pnl.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        pnl.add((Component)new JLabel("<html>" + I18n.tr("Enter the coordinates for the new node.") + "<br>" + I18n.tr("Use decimal degrees.") + "<br>" + I18n.tr("Negative values denote Western/Southern hemisphere.")), GBC.eol());
        pnl.add((Component)new JLabel(I18n.tr("Latitude")), GBC.std().insets(0, 10, 5, 0));
        this.tfLat = new JTextField(12);
        pnl.add((Component)this.tfLat, GBC.eol().insets(0, 10, 0, 0));
        pnl.add((Component)new JLabel(I18n.tr("Longitude")), GBC.std().insets(0, 0, 5, 10));
        this.tfLon = new JTextField(12);
        pnl.add((Component)this.tfLon, GBC.eol().insets(0, 0, 0, 10));
        LatLonInputVerifier inputVerifier = new LatLonInputVerifier();
        this.tfLat.getDocument().addDocumentListener(inputVerifier);
        this.tfLon.getDocument().addDocumentListener(inputVerifier);
        TextFieldFocusHandler focusHandler = new TextFieldFocusHandler();
        this.tfLat.addFocusListener(focusHandler);
        this.tfLon.addFocusListener(focusHandler);
        return pnl;
    }

    protected JPanel buildButtonRow() {
        JPanel pnl = new JPanel(new FlowLayout());
        this.actOK = new OKAction();
        SideButton btn = new SideButton(this.actOK);
        pnl.add(btn);
        this.makeButtonRespondToEnter(btn);
        this.actCancel = new CancelAction();
        btn = new SideButton(this.actCancel);
        pnl.add(btn);
        this.makeButtonRespondToEnter(btn);
        pnl.add(new SideButton(new ContextSensitiveHelpAction(this.help)));
        return pnl;
    }

    protected void makeButtonRespondToEnter(SideButton btn) {
        btn.setFocusable(true);
        btn.getInputMap(0).put(KeyStroke.getKeyStroke(10, 0), "enter");
        btn.getActionMap().put("enter", btn.getAction());
    }

    protected void build() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.buildInputForm(), "Center");
        this.getContentPane().add((Component)this.buildButtonRow(), "South");
        this.pack();
        this.getRootPane().getInputMap(1).put(KeyStroke.getKeyStroke(27, 0), "escape");
        this.getRootPane().getActionMap().put("escape", this.actCancel);
        HelpUtil.setHelpContext(this.getRootPane(), this.help);
    }

    public LatLonDialog(Component parent, String title, String help) {
        super((Window)JOptionPane.getFrameForComponent(parent), Dialog.ModalityType.DOCUMENT_MODAL);
        this.help = help;
        this.setTitle(title);
        this.build();
        this.addWindowListener(new WindowEventHandler());
        this.setCoordinates(null);
    }

    public void setCoordinates(LatLon coordinates) {
        if (coordinates == null) {
            coordinates = new LatLon(0.0, 0.0);
        }
        this.coordinates = coordinates;
        this.tfLat.setText(coordinates.latToString(CoordinateFormat.DECIMAL_DEGREES));
        this.tfLon.setText(coordinates.lonToString(CoordinateFormat.DECIMAL_DEGREES));
        this.actOK.setEnabled(true);
    }

    public LatLon getCoordinates() {
        return this.coordinates;
    }

    protected void setErrorFeedback(JTextField tf, String message) {
        tf.setBorder(BorderFactory.createLineBorder(Color.RED, 1));
        tf.setToolTipText(message);
        tf.setBackground(BG_COLOR_ERROR);
    }

    protected void clearErrorFeedback(JTextField tf, String message) {
        tf.setBorder(UIManager.getBorder("TextField.border"));
        tf.setToolTipText(message);
        tf.setBackground(UIManager.getColor("TextField.background"));
    }

    protected Double parseDoubleFromUserInput(String input) {
        if (input == null) {
            return null;
        }
        input = input.trim();
        input = input.replaceAll("\u00b0", "");
        NumberFormat f = NumberFormat.getNumberInstance();
        Number n = null;
        ParsePosition pp = new ParsePosition(0);
        n = f.parse(input, pp);
        if (pp.getErrorIndex() >= 0 || pp.getIndex() < input.length()) {
            pp = new ParsePosition(0);
            f = NumberFormat.getNumberInstance(Locale.ENGLISH);
            n = f.parse(input, pp);
            if (pp.getErrorIndex() >= 0 || pp.getIndex() < input.length()) {
                return null;
            }
        }
        return n == null ? null : Double.valueOf(n.doubleValue());
    }

    protected Double parseLatFromUserInput() {
        Double d = this.parseDoubleFromUserInput(this.tfLat.getText());
        if (d == null || !LatLon.isValidLat(d)) {
            this.setErrorFeedback(this.tfLat, I18n.tr("Please enter a valid latitude in the range -90..90"));
            return null;
        }
        this.clearErrorFeedback(this.tfLat, I18n.tr("Please enter a latitude in the range -90..90"));
        return d;
    }

    protected Double parseLonFromUserInput() {
        Double d = this.parseDoubleFromUserInput(this.tfLon.getText());
        if (d == null || !LatLon.isValidLon(d)) {
            this.setErrorFeedback(this.tfLon, I18n.tr("Please enter a valid longitude in the range -180..180"));
            return null;
        }
        this.clearErrorFeedback(this.tfLon, I18n.tr("Please enter a longitude in the range -180..180"));
        return d;
    }

    protected void parseUserInput() {
        Double lat = this.parseLatFromUserInput();
        Double lon = this.parseLonFromUserInput();
        if (lat == null || lon == null) {
            this.coordinates = null;
            this.actOK.setEnabled(false);
        } else {
            this.coordinates = new LatLon(lat, lon);
            this.actOK.setEnabled(true);
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.setCanceled(false);
            WindowGeometry.centerInWindow(Main.parent, this.getSize()).applySafe(this);
        }
        super.setVisible(visible);
    }

    class WindowEventHandler
    extends WindowAdapter {
        WindowEventHandler() {
        }

        public void windowClosing(WindowEvent e) {
            LatLonDialog.this.setCanceled(true);
            LatLonDialog.this.setVisible(false);
        }

        public void windowOpened(WindowEvent e) {
            LatLonDialog.this.tfLat.requestFocusInWindow();
        }
    }

    static class TextFieldFocusHandler
    implements FocusListener {
        TextFieldFocusHandler() {
        }

        public void focusGained(FocusEvent e) {
            Component c = e.getComponent();
            if (c instanceof JTextField) {
                JTextField tf = (JTextField)c;
                tf.selectAll();
            }
        }

        public void focusLost(FocusEvent e) {
        }
    }

    class LatLonInputVerifier
    implements DocumentListener {
        LatLonInputVerifier() {
        }

        public void changedUpdate(DocumentEvent e) {
            LatLonDialog.this.parseUserInput();
        }

        public void insertUpdate(DocumentEvent e) {
            LatLonDialog.this.parseUserInput();
        }

        public void removeUpdate(DocumentEvent e) {
            LatLonDialog.this.parseUserInput();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            this.putValue("Name", I18n.tr("Cancel"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog, do not create a new node"));
            this.putValue("SmallIcon", ImageProvider.get("cancel"));
        }

        public void actionPerformed(ActionEvent e) {
            LatLonDialog.this.setCanceled(true);
            LatLonDialog.this.setVisible(false);
        }
    }

    class OKAction
    extends AbstractAction {
        public OKAction() {
            this.putValue("Name", I18n.tr("OK"));
            this.putValue("ShortDescription", I18n.tr("Close the dialog and create a new node"));
            this.putValue("SmallIcon", ImageProvider.get("ok"));
        }

        public void actionPerformed(ActionEvent e) {
            LatLonDialog.this.setCanceled(false);
            LatLonDialog.this.setVisible(false);
        }
    }
}

