/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayerListPopup
extends JPopupMenu {
    /*
     * WARNING - void declaration
     */
    public LayerListPopup(List<Layer> selectedLayers, Layer layer) {
        List<Object> actions;
        if (selectedLayers.size() == 1) {
            actions = Arrays.asList(selectedLayers.get(0).getMenuEntries());
        } else {
            void var5_8;
            actions = new ArrayList();
            boolean separatorAdded = true;
            for (Action a : selectedLayers.get(0).getMenuEntries()) {
                if (!separatorAdded && a instanceof Layer.SeparatorLayerAction) {
                    separatorAdded = true;
                    actions.add(a);
                    continue;
                }
                if (!(a instanceof Layer.LayerAction) || !((Layer.LayerAction)((Object)a)).supportLayers(selectedLayers)) continue;
                separatorAdded = false;
                actions.add(a);
            }
            boolean bl = true;
            while (var5_8 < selectedLayers.size()) {
                separatorAdded = false;
                for (Action a : selectedLayers.get((int)var5_8).getMenuEntries()) {
                    if (!(a instanceof Layer.LayerAction) || !((Layer.LayerAction)((Object)a)).supportLayers(selectedLayers) || actions.contains(a)) continue;
                    if (!separatorAdded) {
                        separatorAdded = true;
                        actions.add(Layer.SeparatorLayerAction.INSTANCE);
                    }
                    actions.add(a);
                }
                ++var5_8;
            }
        }
        if (!actions.isEmpty() && actions.get(actions.size() - 1) instanceof Layer.SeparatorLayerAction) {
            actions.remove(actions.size() - 1);
        }
        for (Action action : actions) {
            if (action instanceof Layer.LayerAction) {
                this.add(((Layer.LayerAction)((Object)action)).createMenuComponent());
                continue;
            }
            this.add(new JMenuItem(action));
        }
    }

    public static final class InfoAction
    extends AbstractAction {
        private final Layer layer;

        public InfoAction(Layer layer) {
            super(I18n.tr("Info"), ImageProvider.get("info"));
            this.layer = layer;
        }

        public void actionPerformed(ActionEvent e) {
            JOptionPane.showMessageDialog(Main.parent, this.layer.getInfoComponent(), I18n.tr("Information about layer"), 1);
        }
    }
}

