/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.openstreetmap.josm.data.oauth.OAuthToken;
import org.openstreetmap.josm.gui.preferences.server.OAuthAccessTokenHolder;
import org.openstreetmap.josm.tools.I18n;

public class AccessTokenInfoPanel
extends JPanel {
    private JTextField tfAccessTokenKey;
    private JTextField tfAccessTokenSecret;
    private JCheckBox cbSaveAccessTokenInPreferences;

    protected void build() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 3, 3);
        this.add((Component)new JLabel(I18n.tr("Access Token Key:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfAccessTokenKey = new JTextField();
        this.add((Component)this.tfAccessTokenKey, gc);
        this.tfAccessTokenKey.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.insets = new Insets(0, 0, 3, 3);
        this.add((Component)new JLabel(I18n.tr("Access Token Secret:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfAccessTokenSecret = new JTextField();
        this.add((Component)this.tfAccessTokenSecret, gc);
        this.tfAccessTokenSecret.setEditable(false);
        gc.gridx = 0;
        gc.gridy = 2;
        gc.gridwidth = 2;
        this.cbSaveAccessTokenInPreferences = new JCheckBox(I18n.tr("Save Access Token in preferences"));
        this.add((Component)this.cbSaveAccessTokenInPreferences, gc);
        this.cbSaveAccessTokenInPreferences.setToolTipText(I18n.tr("<html>Select to save the Access Token in the JOSM preferences.<br>Unselect to use the Access Token in this JOSM session only.</html>"));
        this.cbSaveAccessTokenInPreferences.setSelected(OAuthAccessTokenHolder.getInstance().isSaveToPreferences());
        gc.gridx = 0;
        gc.gridy = 3;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.fill = 1;
        gc.gridwidth = 2;
        this.add((Component)new JPanel(), gc);
    }

    public AccessTokenInfoPanel() {
        this.build();
    }

    public void setAccessToken(OAuthToken token) {
        if (token == null) {
            this.tfAccessTokenKey.setText("");
            this.tfAccessTokenSecret.setText("");
            return;
        }
        this.tfAccessTokenKey.setText(token.getKey());
        this.tfAccessTokenSecret.setText(token.getSecret());
    }

    public void setSaveToPreferences(boolean saveToPreferences) {
        this.cbSaveAccessTokenInPreferences.setSelected(saveToPreferences);
    }

    public boolean isSaveToPreferences() {
        return this.cbSaveAccessTokenInPreferences.isSelected();
    }
}

