/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.oauth;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.openstreetmap.josm.data.Preferences;
import org.openstreetmap.josm.data.oauth.OAuthParameters;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.widgets.SelectAllOnFocusGainedDecorator;
import org.openstreetmap.josm.gui.widgets.VerticallyScrollablePanel;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class AdvancedOAuthPropertiesPanel
extends VerticallyScrollablePanel {
    private JCheckBox cbUseDefaults;
    private JTextField tfConsumerKey;
    private JTextField tfConsumerSecret;
    private JTextField tfRequestTokenURL;
    private JTextField tfAccessTokenURL;
    private JTextField tfAuthoriseURL;
    private UseDefaultItemListener ilUseDefault;

    protected void build() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.insets = new Insets(0, 0, 3, 3);
        gc.gridwidth = 2;
        this.cbUseDefaults = new JCheckBox(I18n.tr("Use default settings"));
        this.add((Component)this.cbUseDefaults, gc);
        gc.gridy = 1;
        gc.weightx = 0.0;
        gc.gridwidth = 1;
        this.add((Component)new JLabel(I18n.tr("Consumer Key:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfConsumerKey = new JTextField();
        this.add((Component)this.tfConsumerKey, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfConsumerKey);
        gc.gridy = 2;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Consumer Secret:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfConsumerSecret = new JTextField();
        this.add((Component)this.tfConsumerSecret, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfConsumerSecret);
        gc.gridy = 3;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Request Token URL:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfRequestTokenURL = new JTextField();
        this.add((Component)this.tfRequestTokenURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfRequestTokenURL);
        gc.gridy = 4;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Access Token URL:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfAccessTokenURL = new JTextField();
        this.add((Component)this.tfAccessTokenURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAccessTokenURL);
        gc.gridy = 5;
        gc.gridx = 0;
        gc.weightx = 0.0;
        this.add((Component)new JLabel(I18n.tr("Authorize URL:")), gc);
        gc.gridx = 1;
        gc.weightx = 1.0;
        this.tfAuthoriseURL = new JTextField();
        this.add((Component)this.tfAuthoriseURL, gc);
        SelectAllOnFocusGainedDecorator.decorate(this.tfAuthoriseURL);
        this.ilUseDefault = new UseDefaultItemListener();
        this.cbUseDefaults.addItemListener(this.ilUseDefault);
    }

    protected boolean hasCustomSettings() {
        return !this.tfConsumerKey.getText().equals("AdCRxTpvnbmfV8aPqrTLyA") || !this.tfConsumerSecret.getText().equals("XmYOiGY9hApytcBC3xCec3e28QBqOWz5g6DSb5UpE") || !this.tfRequestTokenURL.getText().equals("http://www.openstreetmap.org/oauth/request_token") || !this.tfAccessTokenURL.getText().equals("http://www.openstreetmap.org/oauth/access_token") || !this.tfAuthoriseURL.getText().equals("http://www.openstreetmap.org/oauth/authorize");
    }

    protected boolean confirmOverwriteCustomSettings() {
        HelpAwareOptionPane.ButtonSpec[] buttons = new HelpAwareOptionPane.ButtonSpec[]{new HelpAwareOptionPane.ButtonSpec(I18n.tr("Continue"), ImageProvider.get("ok"), I18n.tr("Click to reset the OAuth settings to default values"), null), new HelpAwareOptionPane.ButtonSpec(I18n.tr("Cancel"), ImageProvider.get("cancel"), I18n.tr("Click to abort resetting to the OAuth default values"), null)};
        int ret = HelpAwareOptionPane.showOptionDialog(this, I18n.tr("<html>JOSM is about to reset the OAuth settings to default values.<br>The current custom settings are not saved.</html>"), I18n.tr("Overwrite custom OAuth settings?"), 2, null, buttons, buttons[0], HelpUtil.ht("/Dialog/OAuthAuthorisationWizard"));
        return ret == 0;
    }

    protected void resetToDefaultSettings() {
        this.cbUseDefaults.setSelected(true);
        this.tfConsumerKey.setText("AdCRxTpvnbmfV8aPqrTLyA");
        this.tfConsumerSecret.setText("XmYOiGY9hApytcBC3xCec3e28QBqOWz5g6DSb5UpE");
        this.tfRequestTokenURL.setText("http://www.openstreetmap.org/oauth/request_token");
        this.tfAccessTokenURL.setText("http://www.openstreetmap.org/oauth/access_token");
        this.tfAuthoriseURL.setText("http://www.openstreetmap.org/oauth/authorize");
        this.setChildComponentsEnabled(false);
    }

    protected void setChildComponentsEnabled(boolean enabled) {
        for (Component c : this.getComponents()) {
            if (!(c instanceof JTextField) && !(c instanceof JLabel)) continue;
            c.setEnabled(enabled);
        }
    }

    public OAuthParameters getAdvancedParameters() {
        if (this.cbUseDefaults.isSelected()) {
            return OAuthParameters.createDefault();
        }
        OAuthParameters parameters = new OAuthParameters();
        parameters.setConsumerKey(this.tfConsumerKey.getText());
        parameters.setConsumerSecret(this.tfConsumerSecret.getText());
        parameters.setRequestTokenUrl(this.tfRequestTokenURL.getText());
        parameters.setAccessTokenUrl(this.tfAccessTokenURL.getText());
        parameters.setAuthoriseUrl(this.tfAuthoriseURL.getText());
        return parameters;
    }

    public void setAdvancedParameters(OAuthParameters parameters) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(parameters, "parameters");
        if (parameters.equals(OAuthParameters.createDefault())) {
            this.cbUseDefaults.setSelected(true);
            this.setChildComponentsEnabled(false);
        } else {
            this.cbUseDefaults.setSelected(false);
            this.setChildComponentsEnabled(true);
            this.tfConsumerKey.setText(parameters.getConsumerKey() == null ? "" : parameters.getConsumerKey());
            this.tfConsumerSecret.setText(parameters.getConsumerSecret() == null ? "" : parameters.getConsumerSecret());
            this.tfRequestTokenURL.setText(parameters.getRequestTokenUrl() == null ? "" : parameters.getRequestTokenUrl());
            this.tfAccessTokenURL.setText(parameters.getAccessTokenUrl() == null ? "" : parameters.getAccessTokenUrl());
            this.tfAuthoriseURL.setText(parameters.getAuthoriseUrl() == null ? "" : parameters.getAuthoriseUrl());
        }
    }

    public AdvancedOAuthPropertiesPanel() {
        this.build();
    }

    public void initFromPreferences(Preferences pref) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(pref, "pref");
        boolean useDefault = pref.getBoolean("oauth.settings.use-default", true);
        this.ilUseDefault.setEnabled(false);
        if (useDefault) {
            this.resetToDefaultSettings();
        } else {
            this.cbUseDefaults.setSelected(false);
            this.tfConsumerKey.setText(pref.get("oauth.settings.consumer-key", ""));
            this.tfConsumerSecret.setText(pref.get("oauth.settings.consumer-secret", ""));
            this.tfRequestTokenURL.setText(pref.get("oauth.settings.request-token-url", ""));
            this.tfAccessTokenURL.setText(pref.get("oauth.settings.access-token-url", ""));
            this.tfAuthoriseURL.setText(pref.get("oauth.settings.authorise-url", ""));
            this.setChildComponentsEnabled(true);
        }
        this.ilUseDefault.setEnabled(true);
    }

    public void rememberPreferences(Preferences pref) throws IllegalArgumentException {
        CheckParameterUtil.ensureParameterNotNull(pref, "pref");
        pref.put("oauth.settings.use-default", this.cbUseDefaults.isSelected());
        if (this.cbUseDefaults.isSelected()) {
            pref.put("oauth.settings.consumer-key", null);
            pref.put("oauth.settings.consumer-secret", null);
            pref.put("oauth.settings.request-token-url", null);
            pref.put("oauth.settings.access-token-url", null);
            pref.put("oauth.settings.authorise-url", null);
        } else {
            pref.put("oauth.settings.consumer-key", this.tfConsumerKey.getText().trim());
            pref.put("oauth.settings.consumer-secret", this.tfConsumerSecret.getText().trim());
            pref.put("oauth.settings.request-token-url", this.tfRequestTokenURL.getText().trim());
            pref.put("oauth.settings.access-token-url", this.tfAccessTokenURL.getText().trim());
            pref.put("oauth.settings.authorise-url", this.tfAuthoriseURL.getText().trim());
        }
    }

    class UseDefaultItemListener
    implements ItemListener {
        private boolean enabled;

        UseDefaultItemListener() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (!this.enabled) {
                return;
            }
            switch (e.getStateChange()) {
                case 1: {
                    if (AdvancedOAuthPropertiesPanel.this.hasCustomSettings() && !AdvancedOAuthPropertiesPanel.this.confirmOverwriteCustomSettings()) {
                        AdvancedOAuthPropertiesPanel.this.cbUseDefaults.setSelected(false);
                        return;
                    }
                    AdvancedOAuthPropertiesPanel.this.resetToDefaultSettings();
                    break;
                }
                case 2: {
                    AdvancedOAuthPropertiesPanel.this.setChildComponentsEnabled(true);
                }
            }
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

