/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.preferences.server.ProxyPreferencesPanel;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultProxySelector
extends ProxySelector {
    private static final Logger logger = Logger.getLogger(DefaultProxySelector.class.getName());
    private static boolean JVM_WILL_USE_SYSTEM_PROXIES = false;
    private ProxyPreferencesPanel.ProxyPolicy proxyPolicy;
    private InetSocketAddress httpProxySocketAddress;
    private InetSocketAddress socksProxySocketAddress;
    private ProxySelector delegate;

    public static boolean willJvmRetrieveSystemProxies() {
        return JVM_WILL_USE_SYSTEM_PROXIES;
    }

    public DefaultProxySelector(ProxySelector delegate) {
        String v = System.getProperty("java.net.useSystemProxies");
        if (v != null && v.equals(Boolean.TRUE.toString())) {
            JVM_WILL_USE_SYSTEM_PROXIES = true;
        }
        this.delegate = delegate;
        this.initFromPreferences();
    }

    protected int parseProxyPortValue(String property, String value) {
        if (value == null) {
            return 0;
        }
        int port = 0;
        try {
            port = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            System.err.println(I18n.tr("Unexpected format for port number in in preference ''{0}''. Got ''{1}''.", property, value));
            System.err.println(I18n.tr("The proxy will not be used."));
            return 0;
        }
        if (port <= 0 || port > 65535) {
            System.err.println(I18n.tr("Illegal port number in preference ''{0}''. Got {1}.", property, port));
            System.err.println(I18n.tr("The proxy will not be used."));
            return 0;
        }
        return port;
    }

    public void initFromPreferences() {
        String value = Main.pref.get("proxy.policy");
        if (value.length() == 0) {
            System.err.println(I18n.tr("Warning: no preference ''{0}'' found.", "proxy.policy"));
            System.err.println(I18n.tr("The proxy will not be used."));
            this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.NO_PROXY;
        } else {
            this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.fromName(value);
            if (this.proxyPolicy == null) {
                System.err.println(I18n.tr("Warning: unexpected value for preference ''{0}'' found. Got ''{1}''. Will use no proxy.", "proxy.policy", value));
                this.proxyPolicy = ProxyPreferencesPanel.ProxyPolicy.NO_PROXY;
            }
        }
        String host = Main.pref.get("proxy.http.host", null);
        int port = this.parseProxyPortValue("proxy.http.port", Main.pref.get("proxy.http.port", null));
        if (host != null && !host.trim().equals("") && port > 0) {
            this.httpProxySocketAddress = new InetSocketAddress(host, port);
        } else {
            this.httpProxySocketAddress = null;
            if (this.proxyPolicy.equals((Object)ProxyPreferencesPanel.ProxyPolicy.USE_HTTP_PROXY)) {
                System.err.println(I18n.tr("Warning: Unexpected parameters for HTTP proxy. Got host ''{0}'' and port ''{1}''.", host, port));
                System.err.println(I18n.tr("The proxy will not be used."));
            }
        }
        host = Main.pref.get("proxy.socks.host", null);
        port = this.parseProxyPortValue("proxy.socks.port", Main.pref.get("proxy.socks.port", null));
        if (host != null && !host.trim().equals("") && port > 0) {
            this.socksProxySocketAddress = new InetSocketAddress(host, port);
        } else {
            this.socksProxySocketAddress = null;
            if (this.proxyPolicy.equals((Object)ProxyPreferencesPanel.ProxyPolicy.USE_SOCKS_PROXY)) {
                System.err.println(I18n.tr("Warning: Unexpected parameters for SOCKS proxy. Got host ''{0}'' and port ''{1}''.", host, port));
                System.err.println(I18n.tr("The proxy will not be used."));
            }
        }
    }

    @Override
    public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        System.out.println(I18n.tr("Error: Connection to proxy ''{0}'' for URI ''{1}'' failed. Exception was: {2}", sa.toString(), uri.toString(), ioe.toString()));
    }

    @Override
    public List<Proxy> select(URI uri) {
        switch (this.proxyPolicy) {
            case USE_SYSTEM_SETTINGS: {
                if (!JVM_WILL_USE_SYSTEM_PROXIES) {
                    System.err.println(I18n.tr("Warning: the JVM is not configured to lookup proxies from the system settings. The property ''java.net.useSystemProxies'' was missing at startup time.  Will not use a proxy."));
                    return Collections.singletonList(Proxy.NO_PROXY);
                }
                List<Proxy> ret = this.delegate.select(uri);
                return ret;
            }
            case NO_PROXY: {
                return Collections.singletonList(Proxy.NO_PROXY);
            }
            case USE_HTTP_PROXY: {
                if (this.httpProxySocketAddress == null) {
                    return Collections.singletonList(Proxy.NO_PROXY);
                }
                Proxy proxy = new Proxy(Proxy.Type.HTTP, this.httpProxySocketAddress);
                return Collections.singletonList(proxy);
            }
            case USE_SOCKS_PROXY: {
                if (this.socksProxySocketAddress == null) {
                    return Collections.singletonList(Proxy.NO_PROXY);
                }
                Proxy proxy = new Proxy(Proxy.Type.SOCKS, this.socksProxySocketAddress);
                return Collections.singletonList(proxy);
            }
        }
        return null;
    }
}

