/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.httpclient.util.DateParseException;

public class DateUtil {
    public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
    public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
    private static final Collection DEFAULT_PATTERNS = Arrays.asList("EEE MMM d HH:mm:ss yyyy", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz");
    private static final Date DEFAULT_TWO_DIGIT_YEAR_START;
    private static final TimeZone GMT;

    public static Date parseDate(String string) throws DateParseException {
        return DateUtil.parseDate(string, null, null);
    }

    public static Date parseDate(String string, Collection collection) throws DateParseException {
        return DateUtil.parseDate(string, collection, null);
    }

    public static Date parseDate(String string, Collection collection, Date date) throws DateParseException {
        if (string == null) {
            throw new IllegalArgumentException("dateValue is null");
        }
        if (collection == null) {
            collection = DEFAULT_PATTERNS;
        }
        if (date == null) {
            date = DEFAULT_TWO_DIGIT_YEAR_START;
        }
        if (string.length() > 1 && string.startsWith("'") && string.endsWith("'")) {
            string = string.substring(1, string.length() - 1);
        }
        SimpleDateFormat simpleDateFormat = null;
        for (String string2 : collection) {
            if (simpleDateFormat == null) {
                simpleDateFormat = new SimpleDateFormat(string2, Locale.US);
                simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                simpleDateFormat.set2DigitYearStart(date);
            } else {
                simpleDateFormat.applyPattern(string2);
            }
            try {
                return simpleDateFormat.parse(string);
            }
            catch (ParseException parseException) {
            }
        }
        throw new DateParseException("Unable to parse the date " + string);
    }

    public static String formatDate(Date date) {
        return DateUtil.formatDate(date, PATTERN_RFC1123);
    }

    public static String formatDate(Date date, String string) {
        if (date == null) {
            throw new IllegalArgumentException("date is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("pattern is null");
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string, Locale.US);
        simpleDateFormat.setTimeZone(GMT);
        return simpleDateFormat.format(date);
    }

    private DateUtil() {
    }

    static {
        Calendar calendar = Calendar.getInstance();
        calendar.set(2000, 0, 1, 0, 0);
        DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
        GMT = TimeZone.getTimeZone("GMT");
    }
}

