/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.Err;
import net.sf.saxon.OutputURIResolver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.StandardOutputResolver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.functions.Serialize;
import net.sf.saxon.instruct.DocumentInstr;
import net.sf.saxon.instruct.Instruction;
import net.sf.saxon.instruct.TailCall;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Name11Checker;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.sort.IntIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;

public class ResultDocument
extends Instruction {
    private Expression href;
    private Expression formatExpression;
    private Expression content;
    private Properties globalProperties;
    private Properties localProperties;
    private String baseURI;
    private int validationAction;
    private SchemaType schemaType;
    private IntHashMap serializationAttributes;
    private NamespaceResolver nsResolver;
    private Expression dynamicOutputElement;

    public ResultDocument(Properties globalProperties, Properties localProperties, Expression href, Expression formatExpression, String baseURI, int validationAction, SchemaType schemaType, IntHashMap serializationAttributes, NamespaceResolver nsResolver) {
        this.globalProperties = globalProperties;
        this.localProperties = localProperties;
        this.href = href;
        this.formatExpression = formatExpression;
        this.baseURI = baseURI;
        this.validationAction = validationAction;
        this.schemaType = schemaType;
        this.serializationAttributes = serializationAttributes;
        this.nsResolver = nsResolver;
        this.adoptChildExpression(href);
        Iterator it = serializationAttributes.valueIterator();
        while (it.hasNext()) {
            this.adoptChildExpression((Expression)it.next());
        }
    }

    public void setContent(Expression content) {
        this.content = content;
        this.adoptChildExpression(content);
    }

    public void setDynamicOutputElement(Expression exp) {
        this.dynamicOutputElement = exp;
    }

    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.content = visitor.simplify(this.content);
        this.href = visitor.simplify(this.href);
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = (Expression)this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = visitor.simplify(value);
            this.serializationAttributes.put(key, value);
        }
        return this;
    }

    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.content = visitor.typeCheck(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = visitor.typeCheck(this.href, contextItemType);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = visitor.typeCheck(this.formatExpression, contextItemType);
            this.adoptChildExpression(this.formatExpression);
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = (Expression)this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = visitor.typeCheck(value, contextItemType);
            this.adoptChildExpression(value);
            this.serializationAttributes.put(key, value);
        }
        try {
            DocumentInstr.checkContentSequence(visitor.getStaticContext(), this.content, this.validationAction, this.schemaType);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
        return this;
    }

    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.content = visitor.optimize(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = visitor.optimize(this.href, contextItemType);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = visitor.optimize(this.formatExpression, contextItemType);
            this.adoptChildExpression(this.formatExpression);
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = (Expression)this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = visitor.optimize(value, contextItemType);
            this.adoptChildExpression(value);
            this.serializationAttributes.put(key, value);
        }
        return this;
    }

    public int getIntrinsicDependencies() {
        return 0x1000000;
    }

    public Expression copy() {
        throw new UnsupportedOperationException("copy");
    }

    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.content = this.doPromotion(this.content, offer);
        if (this.href != null) {
            this.href = this.doPromotion(this.href, offer);
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = (Expression)this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = this.doPromotion(value, offer);
            this.serializationAttributes.put(key, value);
        }
    }

    public int getInstructionNameCode() {
        return 174;
    }

    public ItemType getItemType(TypeHierarchy th) {
        return EmptySequenceTest.getInstance();
    }

    public Iterator iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(6);
        list.add(this.content);
        if (this.href != null) {
            list.add(this.href);
        }
        if (this.formatExpression != null) {
            list.add(this.formatExpression);
        }
        Iterator it = this.serializationAttributes.valueIterator();
        while (it.hasNext()) {
            list.add((Expression)it.next());
        }
        if (this.dynamicOutputElement != null) {
            list.add(this.dynamicOutputElement);
        }
        return list.iterator();
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.content == original) {
            this.content = replacement;
            found = true;
        }
        if (this.href == original) {
            this.href = replacement;
            found = true;
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int k = it.next();
            if (this.serializationAttributes.get(k) != original) continue;
            this.serializationAttributes.put(k, replacement);
            found = true;
        }
        if (this.dynamicOutputElement == original) {
            this.dynamicOutputElement = replacement;
            found = true;
        }
        return found;
    }

    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        String nextInChain;
        Result result;
        Controller controller = context.getController();
        Configuration config = controller.getConfiguration();
        NamePool namePool = config.getNamePool();
        XPathContextMinor c2 = context.newMinorContext();
        c2.setOrigin(this);
        OutputURIResolver resolver = null;
        if (this.href == null) {
            result = controller.getPrincipalResult();
        } else {
            try {
                String base = controller.getBaseOutputURI();
                if (base == null && config.isAllowExternalFunctions()) {
                    base = new File(System.getProperty("user.dir")).toURI().toString();
                }
                if (base != null) {
                    base = ((Object)EscapeURI.iriToUri(base)).toString();
                }
                resolver = controller.getOutputURIResolver();
                String hrefValue = ((Object)EscapeURI.iriToUri(this.href.evaluateAsString(context))).toString();
                try {
                    result = resolver.resolve(hrefValue, base);
                }
                catch (Exception err) {
                    throw new XPathException("Exception thrown by OutputURIResolver", err);
                }
                if (result == null) {
                    resolver = StandardOutputResolver.getInstance();
                    result = resolver.resolve(hrefValue, base);
                }
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        if (!controller.checkUniqueOutputDestination(result.getSystemId())) {
            XPathException err = new XPathException("Cannot write more than one result document to the same URI, or write to a URI that has been read: " + result.getSystemId());
            err.setXPathContext(context);
            err.setErrorCode("XTDE1490");
            throw err;
        }
        controller.addUnavailableOutputDestination(result.getSystemId());
        controller.setThereHasBeenAnExplicitResultDocument();
        boolean timing = controller.getConfiguration().isTiming();
        if (timing) {
            String dest = result.getSystemId();
            if (dest == null) {
                dest = result instanceof StreamResult ? "anonymous output stream" : (result instanceof SAXResult ? "SAX2 ContentHandler" : (result instanceof DOMResult ? "DOM tree" : result.getClass().getName()));
            }
            System.err.println("Writing to " + dest);
        }
        Properties computedGlobalProps = this.globalProperties;
        if (this.formatExpression != null) {
            String[] parts;
            CharSequence format = this.formatExpression.evaluateAsString(context);
            try {
                parts = controller.getConfiguration().getNameChecker().getQNameParts(format);
            }
            catch (QNameException e) {
                XPathException err = new XPathException("The requested output format " + Err.wrap(format) + " is not a valid QName");
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
            String uri = this.nsResolver.getURIForPrefix(parts[0], false);
            if (uri == null) {
                XPathException err = new XPathException("The namespace prefix in the format name " + format + " is undeclared");
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
            StructuredQName qName = new StructuredQName(parts[0], uri, parts[1]);
            computedGlobalProps = this.getExecutable().getOutputProperties(qName);
            if (computedGlobalProps == null) {
                XPathException err = new XPathException("There is no xsl:output format named " + format);
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
        }
        Properties computedLocalProps = new Properties(computedGlobalProps);
        NameChecker checker = config.getNameChecker();
        Iterator<Object> citer = this.localProperties.keySet().iterator();
        while (citer.hasNext()) {
            String key = (String)citer.next();
            String[] parts = NamePool.parseClarkName(key);
            try {
                ResultDocument.setSerializationProperty(computedLocalProps, parts[0], parts[1], this.localProperties.getProperty(key), this.nsResolver, true, checker);
            }
            catch (XPathException e) {
                e.maybeSetLocation(this);
                throw e;
            }
        }
        if (this.serializationAttributes.size() > 0) {
            IntIterator it = this.serializationAttributes.keyIterator();
            while (it.hasNext()) {
                int key = it.next();
                Expression exp = (Expression)this.serializationAttributes.get(key);
                String value = ((Object)exp.evaluateAsString(context)).toString();
                String lname = namePool.getLocalName(key);
                String uri = namePool.getURI(key);
                try {
                    ResultDocument.setSerializationProperty(computedLocalProps, uri, lname, value, this.nsResolver, false, checker);
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    if ("http://saxon.sf.net/".equals(e.getErrorCodeNamespace()) && "warning".equals(e.getErrorCodeLocalPart())) {
                        try {
                            context.getController().getErrorListener().warning(e);
                            continue;
                        }
                        catch (TransformerException e2) {
                            throw XPathException.makeXPathException(e2);
                        }
                    }
                    throw e;
                }
            }
        }
        if (this.dynamicOutputElement != null) {
            Item outputArg = this.dynamicOutputElement.evaluateItem(context);
            if (!(outputArg instanceof NodeInfo) || ((NodeInfo)outputArg).getNodeKind() != 1 || ((NodeInfo)outputArg).getFingerprint() != 165) {
                XPathException err = new XPathException("The third argument of saxon:result-document must be an <xsl:output> element");
                err.setLocator(this);
                err.setXPathContext(context);
                throw err;
            }
            Properties dynamicProperties = new Properties();
            Serialize.processXslOutputElement((NodeInfo)outputArg, dynamicProperties, context);
            Iterator<Object> it = dynamicProperties.keySet().iterator();
            while (it.hasNext()) {
                String key = (String)it.next();
                StructuredQName name = StructuredQName.fromClarkName(key);
                String value = dynamicProperties.getProperty(key);
                try {
                    ResultDocument.setSerializationProperty(computedLocalProps, name.getNamespaceURI(), name.getLocalName(), value, this.nsResolver, false, checker);
                }
                catch (XPathException e) {
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    throw e;
                }
            }
        }
        if ((nextInChain = computedLocalProps.getProperty("{http://saxon.sf.net/}next-in-chain")) != null) {
            try {
                result = controller.prepareNextStylesheet(nextInChain, this.baseURI, result);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        c2.changeOutputDestination(computedLocalProps, result, true, 50, this.validationAction, this.schemaType);
        SequenceReceiver out = c2.getReceiver();
        out.open();
        out.startDocument(0);
        this.content.process(c2);
        out.endDocument();
        out.close();
        if (resolver != null) {
            try {
                resolver.close(result);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setSerializationProperty(Properties details, String uri, String lname, String value, NamespaceResolver nsResolver, boolean prevalidated, NameChecker checker) throws XPathException {
        String existing;
        block57: {
            String existing2;
            block56: {
                block55: {
                    if (uri.length() != 0) break block55;
                    if (lname.equals("method")) {
                        if (value.equals("xml") || value.equals("html") || value.equals("text") || value.equals("xhtml") || prevalidated) {
                            details.setProperty("method", value);
                            return;
                        }
                        try {
                            String[] parts = checker.getQNameParts(value);
                            String prefix = parts[0];
                            if (prefix.length() == 0) {
                                XPathException err = new XPathException("method must be xml, html, xhtml, or text, or a prefixed name");
                                err.setErrorCode("XTSE1570");
                                err.setIsStaticError(true);
                                throw err;
                            }
                            String muri = nsResolver.getURIForPrefix(prefix, false);
                            if (muri == null) {
                                XPathException err = new XPathException("Namespace prefix '" + prefix + "' has not been declared");
                                err.setErrorCode("XTSE1570");
                                err.setIsStaticError(true);
                                throw err;
                            }
                            details.setProperty("method", '{' + muri + '}' + parts[1]);
                            return;
                        }
                        catch (QNameException e) {
                            XPathException err = new XPathException("Invalid method name. " + e.getMessage());
                            err.setErrorCode("XTSE1570");
                            err.setIsStaticError(true);
                            throw err;
                        }
                    }
                    if (lname.equals("output-version") || lname.equals("version")) {
                        details.setProperty("version", value);
                        return;
                    }
                    if (lname.equals("byte-order-mark")) {
                        if (!(prevalidated || value.equals("yes") || value.equals("no"))) {
                            XPathException err = new XPathException("byte-order-mark value must be 'yes' or 'no'");
                            err.setErrorCode("XTDE0030");
                            throw err;
                        }
                        details.setProperty("byte-order-mark", value);
                        return;
                    }
                    if (lname.equals("indent")) {
                        if (!(prevalidated || value.equals("yes") || value.equals("no"))) {
                            XPathException err = new XPathException("indent must be 'yes' or 'no'");
                            err.setErrorCode("XTDE0030");
                            throw err;
                        }
                        details.setProperty("indent", value);
                        return;
                    }
                    if (lname.equals("encoding")) {
                        details.setProperty("encoding", value);
                        return;
                    }
                    if (lname.equals("media-type")) {
                        details.setProperty("media-type", value);
                        return;
                    }
                    if (lname.equals("doctype-system")) {
                        details.setProperty("doctype-system", value);
                        return;
                    }
                    if (lname.equals("doctype-public")) {
                        details.setProperty("doctype-public", value);
                        return;
                    }
                    if (lname.equals("omit-xml-declaration")) {
                        if (!(prevalidated || value.equals("yes") || value.equals("no"))) {
                            XPathException err = new XPathException("omit-xml-declaration attribute must be 'yes' or 'no'");
                            err.setErrorCode("XTDE0030");
                            throw err;
                        }
                        details.setProperty("omit-xml-declaration", value);
                        return;
                    }
                    if (lname.equals("standalone")) {
                        if (!(prevalidated || value.equals("yes") || value.equals("no") || value.equals("omit"))) {
                            XPathException err = new XPathException("standalone attribute must be 'yes' or 'no' or 'omit'");
                            err.setErrorCode("XTDE0030");
                            throw err;
                        }
                        details.setProperty("standalone", value);
                        return;
                    }
                    if (lname.equals("cdata-section-elements")) {
                        existing2 = details.getProperty("cdata-section-elements");
                        if (existing2 == null) {
                            existing2 = "";
                        }
                        break block56;
                    } else {
                        if (lname.equals("use-character-maps")) {
                            String existing3 = details.getProperty("use-character-maps");
                            if (existing3 == null) {
                                existing3 = "";
                            }
                            details.setProperty("use-character-maps", existing3 + value);
                            return;
                        }
                        if (lname.equals("undeclare-prefixes")) {
                            if (!(prevalidated || value.equals("yes") || value.equals("no"))) {
                                XPathException err = new XPathException("undeclare-namespaces value must be 'yes' or 'no'");
                                err.setErrorCode("XTDE0030");
                                throw err;
                            }
                            details.setProperty("undeclare-prefixes", value);
                            return;
                        }
                        if (lname.equals("include-content-type")) {
                            if (!(prevalidated || value.equals("yes") || value.equals("no"))) {
                                XPathException err = new XPathException("include-content-type attribute must be 'yes' or 'no'");
                                err.setErrorCode("XTDE0030");
                                throw err;
                            }
                            details.setProperty("include-content-type", value);
                            return;
                        }
                        if (lname.equals("escape-uri-attributes")) {
                            if (!(prevalidated || value.equals("yes") || value.equals("no"))) {
                                XPathException err = new XPathException("escape-uri-attributes value must be 'yes' or 'no'");
                                err.setErrorCode("XTDE0030");
                                throw err;
                            }
                            details.setProperty("escape-uri-attributes", value);
                            return;
                        }
                        if (!lname.equals("normalization-form")) {
                            XPathException err = new XPathException("Unknown serialization property " + lname);
                            err.setErrorCode("XTDE0030");
                            throw err;
                        }
                        if (Name11Checker.getInstance().isValidNmtoken(value)) {
                            details.setProperty("normalization-form", value);
                            return;
                        }
                        if (value.equals("none")) {
                            return;
                        }
                        XPathException err = new XPathException("normalization-form must be a valid NMTOKEN");
                        err.setErrorCode("XTDE0030");
                        throw err;
                    }
                }
                if (!uri.equals("http://saxon.sf.net/")) {
                    details.setProperty('{' + uri + '}' + lname, value);
                    return;
                }
                if (lname.equals("character-representation")) {
                    details.setProperty("{http://saxon.sf.net/}character-representation", value);
                    return;
                }
                if (lname.equals("indent-spaces")) {
                    try {
                        Integer.parseInt(value);
                        details.setProperty("indent", "yes");
                        details.setProperty("{http://saxon.sf.net/}indent-spaces", value);
                        return;
                    }
                    catch (NumberFormatException err) {
                        XPathException e = new XPathException("saxon:indent-spaces must be an integer");
                        e.setErrorCode("http://saxon.sf.net/", "SXWN9002");
                        throw e;
                    }
                }
                if (lname.equals("suppress-indentation")) {
                    existing = details.getProperty("{http://saxon.sf.net/}suppress-indentation");
                    if (existing == null) {
                        existing = "";
                    }
                    break block57;
                } else {
                    if (lname.equals("next-in-chain")) {
                        XPathException e = new XPathException("saxon:next-in-chain value cannot be specified dynamically");
                        e.setErrorCode("http://saxon.sf.net/", "SXWN9004");
                        throw e;
                    }
                    if (!lname.equals("require-well-formed")) return;
                    if (!(prevalidated || value.equals("yes") || value.equals("no"))) {
                        XPathException e = new XPathException("saxon:require-well-formed value must be 'yes' or 'no'");
                        e.setErrorCode("http://saxon.sf.net/", "SXWN9003");
                        throw e;
                    }
                    details.setProperty("{http://saxon.sf.net/}require-well-formed", value);
                    return;
                }
            }
            String s = "";
            StringTokenizer st = new StringTokenizer(value, " \t\n\r", false);
            while (st.hasMoreTokens()) {
                String displayname = st.nextToken();
                if (prevalidated) {
                    s = s + ' ' + displayname;
                } else {
                    try {
                        String[] parts = checker.getQNameParts(displayname);
                        String muri = nsResolver.getURIForPrefix(parts[0], true);
                        if (muri == null) {
                            XPathException err = new XPathException("Namespace prefix '" + parts[0] + "' has not been declared");
                            err.setErrorCode("XTDE0030");
                            throw err;
                        }
                        s = s + " {" + muri + '}' + parts[1];
                    }
                    catch (QNameException err) {
                        XPathException e = new XPathException("Invalid CDATA element name. " + err.getMessage());
                        e.setErrorCode("XTDE0030");
                        throw e;
                    }
                }
                details.setProperty("cdata-section-elements", existing2 + s);
            }
            return;
        }
        String s = "";
        StringTokenizer st = new StringTokenizer(value, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            String displayname = st.nextToken();
            if (prevalidated) {
                s = s + ' ' + displayname;
            } else {
                try {
                    String[] parts = checker.getQNameParts(displayname);
                    String muri = nsResolver.getURIForPrefix(parts[0], true);
                    if (muri == null) {
                        XPathException err = new XPathException("Namespace prefix '" + parts[0] + "' has not been declared");
                        err.setErrorCode("XTDE0030");
                        throw err;
                    }
                    s = s + " {" + muri + '}' + parts[1];
                }
                catch (QNameException err) {
                    XPathException e = new XPathException("Invalid element name. " + err.getMessage());
                    e.setErrorCode("XTDE0030");
                    throw e;
                }
            }
            details.setProperty("{http://saxon.sf.net/}suppress-indentation", existing + s);
        }
    }

    public void explain(ExpressionPresenter out) {
        out.startElement("resultDocument");
        this.content.explain(out);
        out.endElement();
    }
}

