# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.
#
# Authors: Guillaume Emont <guillaume@fluendo.com>

import os
from setuptools import setup
from elisa.core.utils.dist import find_packages, TrialTest, Clean

packages, package_dir = find_packages(os.path.dirname(__file__))
cmdclass = dict(test=TrialTest, clean=Clean)

setup(name='elisa-plugin-dvd',
    version='0.7',
    description='DVD plugin',
    license='GPL3',
    author='Guillaume Emont',
    author_email='guillaume@fluendo.com',
    namespace_packages=['elisa', 'elisa.plugins'],
    packages=packages,
    package_dir=package_dir,
    package_data={'': ['*.conf', 'artwork/*.png'],
                  'elisa.plugins.dvd.i18n': ['*.po', '*/LC_MESSAGES/*.mo', '*.pot'],
                 },
    cmdclass=cmdclass,
    controller_mappings=[ ('/poblesec/dvd_player',
                          'elisa.plugins.dvd.dvd_player:DvdPlayerController')],
    decorator_mappings=[('/poblesec/devices',
                         'elisa.plugins.dvd.decorators:SectionDecorator.decorate'),
                         ('/poblesec',
                         'elisa.plugins.dvd.decorators:main_decorator'),
                         ('/poblesec/movie_menu',
                         'elisa.plugins.dvd.decorators:SectionDecorator.decorate'),
                         ('/poblesec/tv_menu',
                         'elisa.plugins.dvd.decorators:SectionDecorator.decorate')]
    )
