% Use your own class of Latex document here
\documentclass{report}
\usepackage[latin1]{inputenc}
\usepackage[T1]{fontenc}
\usepackage{multicol}
\usepackage[english]{babel}
\usepackage[final]{pdfpages}
\usepackage[margin=2cm,includefoot,includehead]{geometry}
\usepackage{makeidx}
\usepackage{index}
\usepackage[bookmarks=yes]{hyperref}

\makeindex

% Declare the index of authors. Note: the index must
% be produced with the following command (after a first Latex compilation):
% makeindex proceedings.ax -o proceedings.ad
\newindex{authors}{ax}{ad}{Index of authors}

% Some pdfpages parameters
\includepdfset{pages=-,pagecommand={}}

% OK, here begins the document
\begin{document}

% The title page
\title{ \textbf{Proceedings {CONF_NAME}}}
\author{}
%\date{\today}

\maketitle

% The table of contents
\tableofcontents

% Foreword: add your own text
\chapter*{Foreword}
\addcontentsline{toc}{chapter}{Foreword}
\textit{Please write your foreword here}

% The program committee
\chapter*{Program committee}
\addcontentsline{toc}{chapter}{Program committee}
\begin{multicols}{2}
\input{pc}
\end{multicols}

% The list of papers, automatically generated in papers.tex
\input{papers}

% Print the index of authors
\addcontentsline{toc}{chapter}{Index of authors}
\printindex[authors]

\end{document}