;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
; MSP430 - Generic I/O include
; Copyright 2010 - Michael Kohn
; http://www.mikekohn.net/
;
; This is a part of the naken430asm package.
; http://www.mikekohn.net/micro/naken430asm_msp430_assembler.php
;
; These defines should be common for all MSP430 chips
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;; SR
OSCOFF equ 32

;; SFR
IE1     equ 0x0000
IE2     equ 0x0001
IFG1    equ 0x0002
IFG2    equ 0x0003
ME1     equ 0x0004
ME2     equ 0x0005

;; Basic Clock
BCSCTL3 equ 0x0053
BCSCTL2 equ 0x0058
BCSCTL1 equ 0x0057
DCOCTL  equ 0x0056

XT2OFF  equ 128
XTS     equ 64
OFIFG   equ 2
SELS    equ 8
SELM_0  equ 0
SELM_1  equ 64
SELM_2  equ 128
SELM_3  equ 192

;; Port P1
P1IN    equ 0x0020
P1OUT   equ 0x0021
P1DIR   equ 0x0022
P1IFG   equ 0x0023
P1IES   equ 0x0024
P1IE    equ 0x0025
P1SEL   equ 0x0026

;; Port P2
P2IN    equ 0x0028
P2OUT   equ 0x0029
P2DIR   equ 0x002a
P2IFG   equ 0x002b
P2IES   equ 0x002c
P2IE    equ 0x002d
P2SEL   equ 0x002e

;; Port P3
P3IN    equ 0x0018
P3OUT   equ 0x0019
P3DIR   equ 0x001a
P3SEL   equ 0x001b

;; Port P4
P4IN    equ 0x001c
P4OUT   equ 0x001d
P4DIR   equ 0x001e
P4SEL   equ 0x001f

;; Port P5
P5IN    equ 0x0030
P5OUT   equ 0x0031
P5DIR   equ 0x0032
P5SEL   equ 0x0033

;; Port P6
P6IN    equ 0x0034
P6OUT   equ 0x0035
P6DIR   equ 0x0036
P6SEL   equ 0x0037

;; USART0
U0CTL   equ 0x0070
U0TCTL  equ 0x0071
U0RCTL  equ 0x0072
U0MCTL  equ 0x0073
U0BR0   equ 0x0074
U0BR1   equ 0x0075
U0RXBUF equ 0x0076
U0TXBUF equ 0x0077

;; USART1
U1CTL   equ 0x0078
U1TCTL  equ 0x0079
U1RCTL  equ 0x007a
U1MCTL  equ 0x007b
U1BR0   equ 0x007c
U1BR1   equ 0x007d
U1RXBUF equ 0x007e
U1TXBUF equ 0x007f

;; Watchdog Timer
;WDTPW   equ (0x5A<<8)
;WDTHOLD equ (1<<7)
WDTCTL  equ 0x0120

;; Timer_A
TACTL   equ 0x0160
TAR     equ 0x0170
TACCTL0 equ 0x0162
TACCTL1 equ 0x0164
TACCTL2 equ 0x0166
TACCR0  equ 0x0172
TACCR1  equ 0x0174
TACCR2  equ 0x0176
TAIV    equ 0x012e

;; ADC10
ADC10AE   equ 0x004a
ADC10CTL0 equ 0x01b0
ADC10CTL1 equ 0x01b2
ADC10MEM  equ 0x01b4



