/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.nb.javascript;

import org.mozilla.nb.javascript.ErrorReporter;
import org.mozilla.nb.javascript.EvaluatorException;
import org.mozilla.nb.javascript.ScriptRuntime;

class DefaultErrorReporter
implements ErrorReporter {
    static final DefaultErrorReporter instance = new DefaultErrorReporter();
    private boolean forEval;
    private ErrorReporter chainedReporter;

    private DefaultErrorReporter() {
    }

    static ErrorReporter forEval(ErrorReporter errorReporter) {
        DefaultErrorReporter defaultErrorReporter = new DefaultErrorReporter();
        defaultErrorReporter.forEval = true;
        defaultErrorReporter.chainedReporter = errorReporter;
        return defaultErrorReporter;
    }

    @Override
    public void warning(String string, String string2, int n, String string3, int n2, String string4, Object object) {
        if (this.chainedReporter != null) {
            this.chainedReporter.warning(string, string2, n, string3, n2, string4, object);
        }
    }

    @Override
    public void error(String string, String string2, int n, String string3, int n2, String string4, Object object) {
        if (this.forEval) {
            String string5 = "SyntaxError";
            if (string.startsWith("TypeError: ")) {
                string5 = "TypeError";
                string = string.substring("TypeError: ".length());
            }
            throw ScriptRuntime.constructError(string5, string, string2, n, string3, n2);
        }
        if (this.chainedReporter == null) {
            throw this.runtimeError(string, string2, n, string3, n2);
        }
        this.chainedReporter.error(string, string2, n, string3, n2, string4, object);
    }

    @Override
    public EvaluatorException runtimeError(String string, String string2, int n, String string3, int n2) {
        if (this.chainedReporter != null) {
            return this.chainedReporter.runtimeError(string, string2, n, string3, n2);
        }
        return new EvaluatorException(string, string2, n, string3, n2);
    }
}

