/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.ui.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Event;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import org.netbeans.modules.dlight.api.execution.Validateable;
import org.netbeans.modules.dlight.api.execution.ValidationListener;
import org.netbeans.modules.dlight.api.execution.ValidationStatus;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.spi.viewmodel.ColumnModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class DLightSessionsViewPanel
extends JPanel
implements DLightSessionListener,
ValidationListener {
    private static final String stateColumnID = "State";
    private DLightSession currentSession = null;
    private Models.CompoundModel model;
    private Vector<ModelListener> listeners = new Vector();
    private static final Comparator<DLightTool> toolsComparator = new Comparator<DLightTool>(){

        @Override
        public int compare(DLightTool o1, DLightTool o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private boolean isEmpty = true;
    private JComponent treeTableView = null;

    public void activeSessionChanged(DLightSession oldSession, DLightSession newSession) {
        if (newSession == null) {
            this.setEmptyContent();
        } else {
            if (newSession == this.currentSession) {
                return;
            }
            this.updateContent(newSession);
        }
    }

    public void sessionStateChanged(DLightSession session, DLightSession.SessionState oldState, DLightSession.SessionState newState) {
        this.updateContent(session);
    }

    public void sessionAdded(DLightSession newSession) {
    }

    public void sessionRemoved(DLightSession removedSession) {
    }

    void startup() {
        DLightManager.getDefault().addDLightSessionListener((DLightSessionListener)this);
        this.model = this.initModel();
        this.treeTableView = Models.createView((Models.CompoundModel)this.model);
        this.setTreeViewContent();
    }

    private Models.CompoundModel initModel() {
        List<ColumnModelImpl> columns = Arrays.asList(new ColumnModelImpl(stateColumnID, DLightSessionsViewPanel.loc("DLightSessionsViewPanel.stateColumn.name"), String.class));
        ArrayList<Object> models = new ArrayList<Object>();
        models.add(new TreeModelImpl());
        models.add(new TableModelImpl());
        models.add(new NodeModelImpl());
        models.add(new NodeActionsProviderImpl());
        models.addAll(columns);
        return Models.createCompoundModel(models);
    }

    private void setEmptyContent() {
        this.removeAll();
        this.setLayout(new BoxLayout(this, 1));
        JLabel label = new JLabel(DLightSessionsViewPanel.loc("DLightSessionsViewPanel.emptyContent.text"));
        label.setAlignmentX(0.5f);
        this.add(label);
        this.revalidate();
        this.repaint();
        this.isEmpty = true;
    }

    private void setTreeViewContent() {
        UIThread.invoke((Runnable)new Runnable(){

            @Override
            public void run() {
                DLightSessionsViewPanel.this.removeAll();
                DLightSessionsViewPanel.this.setLayout(new BorderLayout());
                if (DLightSessionsViewPanel.this.treeTableView != null) {
                    DLightSessionsViewPanel.this.add((Component)DLightSessionsViewPanel.this.treeTableView, "Center");
                    DLightSessionsViewPanel.this.isEmpty = false;
                }
                DLightSessionsViewPanel.this.revalidate();
                DLightSessionsViewPanel.this.repaint();
            }
        });
    }

    private static String loc(String key) {
        return NbBundle.getMessage(DLightSessionsViewPanel.class, (String)key);
    }

    protected void updateContent(Object node) {
        for (ModelListener l : this.listeners) {
            l.modelChanged((ModelEvent)new ModelEvent.TreeChanged(node == null ? this.model.getRoot() : node));
        }
        if (this.isEmpty) {
            this.setTreeViewContent();
        }
    }

    public void validationStateChanged(Validateable source, ValidationStatus oldStatus, ValidationStatus newStatus) {
        this.updateContent(source);
    }

    static class ColumnModelImpl
    extends ColumnModel {
        private String id;
        private String displayName;
        private Class type;
        private boolean isVisible = true;

        public ColumnModelImpl(String id, String displayName, Class type) {
            this.id = id;
            this.displayName = displayName;
            this.type = type;
        }

        public String getID() {
            return this.id;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Class getType() {
            return this.type;
        }

        public void setVisible(boolean visible) {
            this.isVisible = visible;
        }

        public boolean isVisible() {
            return this.isVisible;
        }
    }

    private static class NodeActionsProviderImpl
    implements NodeActionsProvider {
        private NodeActionsProviderImpl() {
        }

        public void performDefaultAction(Object node) throws UnknownTypeException {
            if (!(node instanceof Event)) {
                throw new UnknownTypeException(node);
            }
        }

        public Action[] getActions(Object node) throws UnknownTypeException {
            if (node instanceof DLightSession) {
                final DLightSession session = (DLightSession)node;
                AbstractAction makeCurrentAction = new AbstractAction(DLightSessionsViewPanel.loc("DLightSessionsViewPanel.actions.MakeCurrent.name")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DLightManager.getDefault().setActiveSession(session);
                    }
                };
                makeCurrentAction.setEnabled(!session.isActive());
                AbstractAction closeSessionAction = new AbstractAction(DLightSessionsViewPanel.loc("DLightSessionsViewPanel.actions.CloseSession.name")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DLightManager.getDefault().closeSession(session);
                    }
                };
                return new Action[]{makeCurrentAction, closeSessionAction};
            }
            ValidationStatus status = null;
            if (node instanceof Validateable) {
                status = ((Validateable)node).getValidationStatus();
            }
            if (node instanceof DLightTool) {
                return status == null ? new Action[]{} : status.getRequiredActions().toArray(new Action[0]);
            }
            return new Action[0];
        }
    }

    class NodeModelImpl
    implements ExtendedNodeModel {
        NodeModelImpl() {
        }

        public boolean canRename(Object node) throws UnknownTypeException {
            return false;
        }

        public boolean canCopy(Object node) throws UnknownTypeException {
            return false;
        }

        public boolean canCut(Object node) throws UnknownTypeException {
            return false;
        }

        public Transferable clipboardCopy(Object node) throws IOException, UnknownTypeException {
            return null;
        }

        public Transferable clipboardCut(Object node) throws IOException, UnknownTypeException {
            return null;
        }

        public PasteType[] getPasteTypes(Object node, Transferable t) throws UnknownTypeException {
            return null;
        }

        public void setName(Object node, String name) throws UnknownTypeException {
        }

        public String getIconBaseWithExtension(Object node) throws UnknownTypeException {
            return null;
        }

        public String getDisplayName(Object node) throws UnknownTypeException {
            if (node == "Root") {
                return DLightSessionsViewPanel.loc("DLightSessionsViewPanel.NodeModelImpl.rootNode.name");
            }
            if (node instanceof DLightSession) {
                DLightSession session = (DLightSession)node;
                if (DLightManager.getDefault().getActiveSession() == session) {
                    return "<html><b>" + session.getDescription() + "</b></html>";
                }
                return session.getDescription();
            }
            if (node instanceof DLightTool) {
                DLightTool tool = (DLightTool)node;
                ValidationStatus status = tool.getValidationStatus();
                if (status.isValid()) {
                    return tool.getName();
                }
                if (status.isInvalid()) {
                    return "<html><font color=\"#FF0000\">" + tool.getName() + "</font></html>";
                }
                return "<html><b>?</b> " + tool.getName() + "</html>";
            }
            throw new UnknownTypeException(node);
        }

        public String getIconBase(Object node) throws UnknownTypeException {
            return null;
        }

        public String getShortDescription(Object node) throws UnknownTypeException {
            if (node == "Root") {
                return DLightSessionsViewPanel.loc("DLightSessionsViewPanel.NodeModelImpl.rootNode.tooltip");
            }
            if (node instanceof DLightSession) {
                DLightSession session = (DLightSession)node;
                return session.getDescription();
            }
            if (node instanceof DLightTool) {
                DLightTool tool = (DLightTool)node;
                return tool.toString();
            }
            throw new UnknownTypeException(node);
        }

        public void addModelListener(ModelListener l) {
            if (!DLightSessionsViewPanel.this.listeners.contains(l)) {
                DLightSessionsViewPanel.this.listeners.add(l);
            }
        }

        public void removeModelListener(ModelListener l) {
            DLightSessionsViewPanel.this.listeners.remove(l);
        }
    }

    class TableModelImpl
    implements TableModel {
        TableModelImpl() {
        }

        public Object getValueAt(Object node, String columnID) throws UnknownTypeException {
            if (columnID == null) {
                return null;
            }
            if (node instanceof DLightSession) {
                DLightSession session = (DLightSession)node;
                if (columnID.equals(DLightSessionsViewPanel.stateColumnID)) {
                    return session.getState().toString();
                }
                return null;
            }
            if (node instanceof DLightTool) {
                DLightTool tool = (DLightTool)node;
                ValidationStatus status = tool.getValidationStatus();
                if (columnID.equals(DLightSessionsViewPanel.stateColumnID)) {
                    if (status.isValid()) {
                        return "OK";
                    }
                    if (status.isInvalid()) {
                        return "Tool cannot be used. " + status.getReason();
                    }
                    return status.getReason();
                }
                return null;
            }
            if (node instanceof JToolTip && columnID.equals(DLightSessionsViewPanel.stateColumnID)) {
                return "ToolState";
            }
            throw new UnknownTypeException(node);
        }

        public boolean isReadOnly(Object node, String columnID) throws UnknownTypeException {
            return true;
        }

        public void setValueAt(Object node, String columnID, Object value) throws UnknownTypeException {
        }

        public void addModelListener(ModelListener l) {
            if (!DLightSessionsViewPanel.this.listeners.contains(l)) {
                DLightSessionsViewPanel.this.listeners.add(l);
            }
        }

        public void removeModelListener(ModelListener l) {
            DLightSessionsViewPanel.this.listeners.remove(l);
        }
    }

    class TreeModelImpl
    implements TreeModel {
        TreeModelImpl() {
        }

        public Object getRoot() {
            return "Root";
        }

        public Object[] getChildren(Object parent, int from, int to) throws UnknownTypeException {
            if (parent == "Root") {
                ArrayList result = new ArrayList();
                result.addAll(DLightManager.getDefault().getSessionsList());
                return result.toArray();
            }
            if (parent instanceof DLightSession) {
                DLightSession session = (DLightSession)parent;
                TreeSet tools = new TreeSet(toolsComparator);
                tools.addAll(session.getTools());
                return tools.toArray();
            }
            throw new UnknownTypeException(parent);
        }

        public boolean isLeaf(Object node) {
            if (node == "Root") {
                return false;
            }
            return !(node instanceof DLightSession);
        }

        public int getChildrenCount(Object node) throws UnknownTypeException {
            if (node == "Root") {
                return DLightManager.getDefault().getSessionsList().size();
            }
            if (node instanceof DLightSession) {
                DLightSession session = (DLightSession)node;
                return session.getTools().size();
            }
            return 0;
        }

        public void addModelListener(ModelListener l) {
            if (!DLightSessionsViewPanel.this.listeners.contains(l)) {
                DLightSessionsViewPanel.this.listeners.add(l);
            }
        }

        public void removeModelListener(ModelListener l) {
            DLightSessionsViewPanel.this.listeners.remove(l);
        }
    }
}

