/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.hyperlink;

import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.IssueFinderUtils;
import org.netbeans.modules.versioning.util.VCSHyperlinkProvider;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class VcsHyperlinkProviderImpl
extends VCSHyperlinkProvider {
    public int[] getSpans(String text) {
        return IssueFinderUtils.getIssueSpans((String)text);
    }

    public String getTooltip(String text, int offsetStart, int offsetEnd) {
        return NbBundle.getMessage(VcsHyperlinkProviderImpl.class, (String)"LBL_OpenIssue", (Object[])new Object[]{this.getIssueId(text, offsetStart, offsetEnd)});
    }

    public void onClick(final File file, String text, int offsetStart, int offsetEnd) {
        final String issueId = this.getIssueId(text, offsetStart, offsetEnd);
        if (issueId == null) {
            Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "No issue found for {0}", text.substring(offsetStart, offsetEnd));
            return;
        }
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                BugtrackingUtil.openIssue((File)file, (String)issueId);
            }
        });
    }

    private String getIssueId(String text, int offsetStart, int offsetEnd) {
        IssueFinder issueFinder = IssueFinderUtils.determineIssueFinder((String)text, (int)offsetStart, (int)offsetEnd);
        if (issueFinder == null) {
            return null;
        }
        return issueFinder.getIssueId(text.substring(offsetStart, offsetEnd));
    }
}

