/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.nativeexecution.AbstractNativeProcess;
import org.netbeans.modules.nativeexecution.LocalNativeProcess;
import org.netbeans.modules.nativeexecution.NativeProcessInfo;
import org.netbeans.modules.nativeexecution.PtyNativeProcess;
import org.netbeans.modules.nativeexecution.RemoteNativeProcess;
import org.netbeans.modules.nativeexecution.TerminalLocalNativeProcess;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminal;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.ShellValidationSupport;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class NativeProcessBuilder
implements Callable<Process> {
    private final NativeProcessInfo info;
    private ExternalTerminal externalTerminal = null;

    private NativeProcessBuilder(ExecutionEnvironment execEnv) {
        this.info = new NativeProcessInfo(execEnv);
    }

    public static NativeProcessBuilder newProcessBuilder(ExecutionEnvironment execEnv) {
        return new NativeProcessBuilder(execEnv);
    }

    public static NativeProcessBuilder newLocalProcessBuilder() {
        return new NativeProcessBuilder(ExecutionEnvironmentFactory.getLocal());
    }

    public NativeProcessBuilder redirectError() {
        this.info.redirectError(true);
        return this;
    }

    public NativeProcessBuilder setExecutable(String executable) {
        this.info.setExecutable(executable);
        return this;
    }

    public NativeProcessBuilder setCommandLine(String commandLine) {
        this.info.setCommandLine(commandLine);
        return this;
    }

    public NativeProcessBuilder addNativeProcessListener(ChangeListener listener) {
        this.info.addNativeProcessListener(listener);
        return this;
    }

    public MacroMap getEnvironment() {
        return this.info.getEnvironment();
    }

    @Override
    public NativeProcess call() throws IOException {
        AbstractNativeProcess process = null;
        ExecutionEnvironment execEnv = this.info.getExecutionEnvironment();
        if (this.info.getCommand() == null) {
            throw new IllegalStateException("No executable nor command line is specified");
        }
        if (!ConnectionManager.getInstance().isConnectedTo(execEnv)) {
            throw new IOException("No connection to " + execEnv.getDisplayName());
        }
        if (this.info.isPtyMode() && this.isPtySupportedFor(this.info.getExecutionEnvironment())) {
            process = new PtyNativeProcess(this.info);
        } else {
            if (this.info.getExecutionEnvironment().isRemote()) {
                process = new RemoteNativeProcess(this.info);
            } else if (this.externalTerminal != null) {
                boolean canProceed = true;
                boolean available = this.externalTerminal.isAvailable(this.info.getExecutionEnvironment());
                if (!available) {
                    if (Boolean.getBoolean("nativeexecution.mode.unittest")) {
                        System.err.println(NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.NoTermianl.text", new String[0]));
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.NoTermianl.text", new String[0]), 2));
                    }
                    canProceed = false;
                } else {
                    if (Utilities.isWindows()) {
                        Shell shell = WindowsSupport.getInstance().getActiveShell();
                        if (shell == null) {
                            if (Boolean.getBoolean("nativeexecution.mode.unittest")) {
                                System.err.println(NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.NoShell.text", new String[0]));
                            } else {
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.NoShell.text", new String[0]), 2));
                            }
                            canProceed = false;
                        } else {
                            ShellValidationSupport.ShellValidationStatus validationStatus = ShellValidationSupport.getValidationStatus(shell);
                            if (!validationStatus.isValid()) {
                                canProceed = ShellValidationSupport.confirm(NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.BrokenShellConfirmationHeader.text", new String[0]), NativeProcessBuilder.loc("NativeProcessBuilder.processCreation.BrokenShellConfirmationFooter.text", new String[0]), validationStatus);
                            }
                        }
                    }
                    if (canProceed) {
                        process = new TerminalLocalNativeProcess(this.info, this.externalTerminal);
                    }
                }
            }
            if (process == null) {
                process = new LocalNativeProcess(this.info);
            }
        }
        return process.createAndStart();
    }

    public NativeProcessBuilder setWorkingDirectory(String workingDirectory) {
        this.info.setWorkingDirectory(workingDirectory);
        return this;
    }

    public NativeProcessBuilder setArguments(String ... arguments) {
        this.info.setArguments(arguments);
        return this;
    }

    public NativeProcessBuilder useExternalTerminal(ExternalTerminal terminal) {
        this.externalTerminal = terminal;
        return this;
    }

    public NativeProcessBuilder unbufferOutput(boolean unbuffer) {
        this.info.setUnbuffer(unbuffer);
        return this;
    }

    public NativeProcessBuilder setX11Forwarding(boolean x11forwarding) {
        if (Boolean.getBoolean("cnd.remote.noX11")) {
            return this;
        }
        this.info.setX11Forwarding(x11forwarding);
        return this;
    }

    public NativeProcessBuilder setInitialSuspend(boolean suspend) {
        this.info.setInitialSuspend(suspend);
        return this;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(NativeProcessBuilder.class, (String)key, (Object[])params);
    }

    public NativeProcessBuilder setUsePty(boolean usePty) {
        this.info.setPtyMode(usePty);
        return this;
    }

    public NativeProcessBuilder setMacroExpansion(boolean expandMacros) {
        this.info.setExpandMacros(expandMacros);
        return this;
    }

    private boolean isPtySupportedFor(ExecutionEnvironment executionEnvironment) {
        if (!HostInfoUtils.isHostInfoAvailable(executionEnvironment)) {
            return false;
        }
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo(executionEnvironment);
            switch (hostInfo.getOSFamily()) {
                case WINDOWS: {
                    Shell shell = WindowsSupport.getInstance().getActiveShell();
                    return shell.type == Shell.ShellType.CYGWIN;
                }
                case MACOSX: {
                    return true;
                }
                case LINUX: {
                    return true;
                }
                case SUNOS: {
                    return true;
                }
            }
            return false;
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (CancellationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return false;
    }

    public NativeProcessBuilder setCharset(Charset charset) {
        this.info.setCharset(charset);
        return this;
    }
}

