/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.JaxWsBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.ClientAlreadyExistsExeption;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModelProvider;
import org.netbeans.modules.websvc.api.jaxws.project.config.ServiceAlreadyExistsExeption;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Client;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Clients;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.JaxWs;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Service;
import org.netbeans.modules.websvc.jaxwsmodel.project_config1_0.Services;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.util.ChangeSupport;

public final class JaxWsModelImpl
implements JaxWsModel {
    private static final String JAX_WS_XML_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jax-ws.xml";
    private JaxWs jaxws;
    private FileObject fo;
    private Object initLock = new Object();
    private List<JaxWsModel.ServiceListener> serviceListeners;
    private List<PropertyChangeListener> propertyChangeListeners;
    private List<PropertyChangeListener> cachedListeners;
    private ChangeSupport changeSupport;
    private Project project;

    public JaxWsModelImpl(Project project) {
        this.project = project;
        this.fo = WSUtils.findJaxWsFileObject(project);
        if (this.fo != null) {
            try {
                this.jaxws = JaxWs.createGraph(this.fo.getInputStream());
            }
            catch (IOException iOException) {
                Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "JaxWsModel creation failed", iOException);
            }
            final Project project2 = project;
            this.fo.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent fileEvent) {
                    JaxWsBuildScriptExtensionProvider jaxWsBuildScriptExtensionProvider = (JaxWsBuildScriptExtensionProvider)project2.getLookup().lookup(JaxWsBuildScriptExtensionProvider.class);
                    if (jaxWsBuildScriptExtensionProvider != null) {
                        try {
                            jaxWsBuildScriptExtensionProvider.handleJaxWsModelChanges(JaxWsModelImpl.this);
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "failed to implement changes in jaxws-build.xml", iOException);
                        }
                    }
                }
            });
        }
        this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        this.cachedListeners = new ArrayList<PropertyChangeListener>();
        this.serviceListeners = new ArrayList<JaxWsModel.ServiceListener>();
        this.changeSupport = new ChangeSupport((Object)this);
    }

    public JaxWsModelImpl(JaxWs jaxWs) {
        this(jaxWs, null);
    }

    public JaxWsModelImpl(JaxWs jaxWs, FileObject fileObject) {
        this.jaxws = jaxWs;
        this.fo = fileObject;
        this.propertyChangeListeners = new ArrayList<PropertyChangeListener>();
        this.serviceListeners = new ArrayList<JaxWsModel.ServiceListener>();
        this.changeSupport = new ChangeSupport((Object)this);
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Service[] getServices() {
        if (this.jaxws == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Service[0];
        }
        Services services = this.jaxws.getServices();
        if (services == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Service[0];
        }
        Service[] serviceArray = services.getService();
        if (serviceArray == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Service[0];
        }
        org.netbeans.modules.websvc.api.jaxws.project.config.Service[] serviceArray2 = new org.netbeans.modules.websvc.api.jaxws.project.config.Service[serviceArray.length];
        for (int i = 0; i < serviceArray.length; ++i) {
            serviceArray2[i] = JaxWsModelProvider.getDefault().createService((Object)serviceArray[i]);
        }
        return serviceArray2;
    }

    @Override
    public void setJsr109(Boolean bl) {
        if (this.jaxws != null) {
            this.jaxws.setJsr109(bl);
        }
    }

    @Override
    public Boolean getJsr109() {
        return this.jaxws == null ? Boolean.FALSE : this.jaxws.getJsr109();
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Service findServiceByName(String string) {
        Service service = this.findService(string);
        return service == null ? null : JaxWsModelProvider.getDefault().createService((Object)service);
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Service findServiceByImplementationClass(String string) {
        Service service = this._findServiceByClass(string);
        return service == null ? null : JaxWsModelProvider.getDefault().createService((Object)service);
    }

    private Service findService(String string) {
        if (this.jaxws == null) {
            return null;
        }
        Services services = this.jaxws.getServices();
        if (services == null) {
            return null;
        }
        Service[] serviceArray = services.getService();
        if (serviceArray == null) {
            return null;
        }
        for (int i = 0; i < serviceArray.length; ++i) {
            if (!string.equals(serviceArray[i].getName())) continue;
            return serviceArray[i];
        }
        return null;
    }

    private Service _findServiceByClass(String string) {
        if (this.jaxws == null) {
            return null;
        }
        Services services = this.jaxws.getServices();
        if (services == null) {
            return null;
        }
        Service[] serviceArray = services.getService();
        if (serviceArray == null) {
            return null;
        }
        for (int i = 0; i < serviceArray.length; ++i) {
            if (!string.equals(serviceArray[i].getImplementationClass())) continue;
            return serviceArray[i];
        }
        return null;
    }

    @Override
    public boolean removeService(String string) {
        Service service = this.findService(string);
        if (string == null) {
            return false;
        }
        this.fireServiceRemoved(string);
        this.jaxws.getServices().removeService(service);
        return true;
    }

    @Override
    public boolean removeServiceByClassName(String string) {
        Service service;
        if (string != null && (service = this._findServiceByClass(string)) != null) {
            this.fireServiceRemoved(service.getName());
            this.jaxws.getServices().removeService(service);
            return true;
        }
        return false;
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Service addService(String string, String string2) throws ServiceAlreadyExistsExeption {
        if (this.jaxws == null && this.project != null) {
            try {
                WSUtils.createJaxWsFileObject(this.project);
            }
            catch (IOException iOException) {
                Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "failed to create jax-ws.xml", iOException);
            }
        }
        if (this.findService(string) != null) {
            throw new ServiceAlreadyExistsExeption(string);
        }
        Service service = this.jaxws.getServices().newService();
        service.setName(string);
        service.setImplementationClass(string2);
        this.jaxws.getServices().addService(service);
        this.fireServiceAdded(string, string2);
        return JaxWsModelProvider.getDefault().createService((Object)service);
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Service addService(String string, String string2, String string3, String string4, String string5, String string6) throws ServiceAlreadyExistsExeption {
        if (this.jaxws == null && this.project != null) {
            try {
                WSUtils.createJaxWsFileObject(this.project);
            }
            catch (IOException iOException) {
                Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "failed to create jax-ws.xml", iOException);
            }
        }
        if (this.findService(string) != null) {
            throw new ServiceAlreadyExistsExeption(string);
        }
        Service service = this.jaxws.getServices().newService();
        service.setName(string);
        service.setImplementationClass(string2);
        service.setWsdlUrl(string3);
        service.setServiceName(string4);
        service.setPortName(string5);
        service.setPackageName(string6);
        this.jaxws.getServices().addService(service);
        return JaxWsModelProvider.getDefault().createService((Object)service);
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Client[] getClients() {
        if (this.jaxws == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Client[0];
        }
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Client[0];
        }
        Client[] clientArray = clients.getClient();
        if (clientArray == null) {
            return new org.netbeans.modules.websvc.api.jaxws.project.config.Client[0];
        }
        org.netbeans.modules.websvc.api.jaxws.project.config.Client[] clientArray2 = new org.netbeans.modules.websvc.api.jaxws.project.config.Client[clientArray.length];
        for (int i = 0; i < clientArray.length; ++i) {
            clientArray2[i] = JaxWsModelProvider.getDefault().createClient((Object)clientArray[i]);
        }
        return clientArray2;
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Client findClientByName(String string) {
        Client client = this.findClient(string);
        return client == null ? null : JaxWsModelProvider.getDefault().createClient((Object)client);
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Client findClientByWsdlUrl(String string) {
        if (this.jaxws == null) {
            return null;
        }
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return null;
        }
        Client[] clientArray = clients.getClient();
        if (clientArray == null) {
            return null;
        }
        for (int i = 0; i < clientArray.length; ++i) {
            if (!string.equals(clientArray[i].getWsdlUrl())) continue;
            return JaxWsModelProvider.getDefault().createClient((Object)clientArray[i]);
        }
        return null;
    }

    private Client findClient(String string) {
        if (this.jaxws == null) {
            return null;
        }
        Clients clients = this.jaxws.getClients();
        if (clients == null) {
            return null;
        }
        Client[] clientArray = clients.getClient();
        if (clientArray == null) {
            return null;
        }
        for (int i = 0; i < clientArray.length; ++i) {
            if (!string.equals(clientArray[i].getName())) continue;
            return clientArray[i];
        }
        return null;
    }

    @Override
    public boolean removeClient(String string) {
        Client client = this.findClient(string);
        if (client == null) {
            return false;
        }
        this.jaxws.getClients().removeClient(client);
        return true;
    }

    @Override
    public org.netbeans.modules.websvc.api.jaxws.project.config.Client addClient(String string, String string2, String string3) throws ClientAlreadyExistsExeption {
        if (this.jaxws == null && this.project != null) {
            try {
                WSUtils.createJaxWsFileObject(this.project);
            }
            catch (IOException iOException) {
                Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "failed to create jax-ws.xml", iOException);
            }
        }
        if (this.findClient(string) != null) {
            throw new ClientAlreadyExistsExeption(string);
        }
        Client client = this.jaxws.getClients().newClient();
        client.setName(string);
        client.setWsdlUrl(string2);
        if (string3 != null) {
            client.setPackageName(string3);
            client.setPackageNameForceReplace("true");
        }
        this.jaxws.getClients().addClient(client);
        return JaxWsModelProvider.getDefault().createClient((Object)client);
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.jaxws == null) {
            this.cachedListeners.add(propertyChangeListener);
        } else {
            JaxWsPCL jaxWsPCL = new JaxWsPCL(propertyChangeListener);
            this.propertyChangeListeners.add(jaxWsPCL);
            this.jaxws.addPropertyChangeListener(jaxWsPCL);
        }
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (this.jaxws == null) {
            this.cachedListeners.remove(propertyChangeListener);
        } else {
            for (PropertyChangeListener propertyChangeListener2 : this.propertyChangeListeners) {
                if (propertyChangeListener != ((JaxWsPCL)propertyChangeListener2).getOriginalListener()) continue;
                this.jaxws.removePropertyChangeListener(propertyChangeListener2);
                this.propertyChangeListeners.remove(propertyChangeListener2);
                break;
            }
        }
    }

    @Override
    public void merge(JaxWsModel jaxWsModel) {
        if (this.jaxws != null) {
            JaxWsModelImpl jaxWsModelImpl = (JaxWsModelImpl)jaxWsModel;
            if (jaxWsModelImpl.jaxws != null) {
                this.jaxws.merge(((JaxWsModelImpl)jaxWsModel).jaxws, 3);
            }
        }
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        if (this.jaxws != null) {
            this.jaxws.write(outputStream);
        }
    }

    @Override
    public FileObject getJaxWsFile() {
        return this.fo;
    }

    @Override
    public void setJaxWsFile(FileObject fileObject) {
        JaxWsBuildScriptExtensionProvider jaxWsBuildScriptExtensionProvider;
        this.fo = fileObject;
        if (fileObject != null && this.project != null && (jaxWsBuildScriptExtensionProvider = (JaxWsBuildScriptExtensionProvider)this.project.getLookup().lookup(JaxWsBuildScriptExtensionProvider.class)) != null) {
            try {
                this.jaxws = JaxWs.createGraph(fileObject.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            final Project project = this.project;
            fileObject.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                public void fileChanged(FileEvent fileEvent) {
                    JaxWsBuildScriptExtensionProvider jaxWsBuildScriptExtensionProvider = (JaxWsBuildScriptExtensionProvider)project.getLookup().lookup(JaxWsBuildScriptExtensionProvider.class);
                    if (jaxWsBuildScriptExtensionProvider != null) {
                        try {
                            jaxWsBuildScriptExtensionProvider.handleJaxWsModelChanges(JaxWsModelImpl.this);
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(JaxWsModelImpl.class.getName()).log(Level.INFO, "failed to implement changes in jaxws-build.xml", iOException);
                        }
                    }
                }
            });
            if (this.jaxws != null) {
                for (PropertyChangeListener propertyChangeListener : this.cachedListeners) {
                    this.addPropertyChangeListener(propertyChangeListener);
                }
                this.cachedListeners.clear();
            }
        }
        this.changeSupport.fireChange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write() throws IOException {
        if (this.fo != null) {
            FileLock fileLock = null;
            OutputStream outputStream = null;
            try {
                fileLock = this.fo.lock();
                outputStream = this.fo.getOutputStream(fileLock);
                this.write(outputStream);
                outputStream.close();
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        } else {
            throw new IOException("No FileObject for writing specified");
        }
    }

    @Override
    public synchronized void addServiceListener(JaxWsModel.ServiceListener serviceListener) {
        if (serviceListener != null) {
            this.serviceListeners.add(serviceListener);
        }
    }

    @Override
    public synchronized void removeServiceListener(JaxWsModel.ServiceListener serviceListener) {
        this.serviceListeners.remove(serviceListener);
    }

    void fireServiceAdded(String string, String string2) {
        Iterator<JaxWsModel.ServiceListener> iterator = this.serviceListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().serviceAdded(string, string2);
        }
    }

    void fireServiceRemoved(String string) {
        Iterator<JaxWsModel.ServiceListener> iterator = this.serviceListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().serviceRemoved(string);
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    private class JaxWsPCL
    implements PropertyChangeListener {
        PropertyChangeListener originalListener;

        JaxWsPCL(PropertyChangeListener propertyChangeListener) {
            this.originalListener = propertyChangeListener;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            Object object;
            Object object2 = propertyChangeEvent.getOldValue();
            JaxWsModelProvider jaxWsModelProvider = JaxWsModelProvider.getDefault();
            if (object2 != null) {
                if (object2 instanceof Client) {
                    object2 = jaxWsModelProvider.createClient(object2);
                }
                if (object2 instanceof Service) {
                    object2 = jaxWsModelProvider.createService(object2);
                }
            }
            if ((object = propertyChangeEvent.getNewValue()) != null) {
                if (object instanceof Client) {
                    object = jaxWsModelProvider.createClient(object);
                }
                if (object instanceof Service) {
                    object = jaxWsModelProvider.createService(object);
                }
            }
            this.originalListener.propertyChange(new PropertyChangeEvent(propertyChangeEvent.getSource(), propertyChangeEvent.getPropertyName(), object2, object));
        }

        PropertyChangeListener getOriginalListener() {
            return this.originalListener;
        }
    }
}

