/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.nodes.DecoratorManager;
import org.netbeans.modules.glassfish.common.nodes.Hk2ItemNode;
import org.netbeans.modules.glassfish.common.nodes.Hk2ResourceContainers;
import org.netbeans.modules.glassfish.common.nodes.Hk2ResourceNode;
import org.netbeans.modules.glassfish.common.nodes.NodeTypes;
import org.netbeans.modules.glassfish.common.nodes.Refreshable;
import org.netbeans.modules.glassfish.common.ui.AdminObjectCustomizer;
import org.netbeans.modules.glassfish.common.ui.ConnectionPoolCustomizer;
import org.netbeans.modules.glassfish.common.ui.ConnectorConnectionPoolCustomizer;
import org.netbeans.modules.glassfish.common.ui.ConnectorCustomizer;
import org.netbeans.modules.glassfish.common.ui.JavaMailCustomizer;
import org.netbeans.modules.glassfish.common.ui.JdbcResourceCustomizer;
import org.netbeans.modules.glassfish.spi.Decorator;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.ResourceDecorator;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class Hk2ResourcesChildren
extends Children.Keys<Object>
implements Refreshable {
    private Lookup lookup;
    private String type;
    private static final Node WAIT_NODE = Hk2ItemNode.createWaitNode();

    Hk2ResourcesChildren(Lookup lookup, String type) {
        this.lookup = lookup;
        this.type = type;
    }

    @Override
    public void updateKeys() {
        Vector<Hk2ItemNode> keys = new Vector<Hk2ItemNode>();
        String[] childTypes = NodeTypes.getChildTypes(this.type);
        if (childTypes != null && childTypes.length > 1) {
            for (int i = 0; i < childTypes.length; ++i) {
                String childtype = childTypes[i];
                Class customizer = this.getCustomizer(childtype);
                keys.add(new Hk2ItemNode(this.lookup, (Children)new Hk2Resources(this.lookup, childtype, customizer), NbBundle.getMessage(Hk2ResourceContainers.class, (String)("LBL_" + childtype)), Hk2ItemNode.REFRESHABLE_FOLDER));
            }
        } else {
            String childtype = childTypes[0];
            GlassfishModule commonSupport = (GlassfishModule)this.lookup.lookup(GlassfishModule.class);
            if (commonSupport != null) {
                try {
                    Map<String, String> ip = commonSupport.getInstanceProperties();
                    CommandRunner mgr = new CommandRunner(true, commonSupport.getCommandFactory(), ip, new OperationStateListener[0]);
                    Decorator decorator = DecoratorManager.findDecorator(childtype, null);
                    List<ResourceDesc> reslourcesList = mgr.getResources(childtype);
                    for (ResourceDesc resource : reslourcesList) {
                        keys.add(new Hk2ResourceNode(this.lookup, resource, (ResourceDecorator)decorator, this.getCustomizer(childtype)));
                    }
                }
                catch (Exception ex) {
                    Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
                }
            }
        }
        this.setKeys(keys);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof Hk2ItemNode) {
            return new Node[]{(Hk2ItemNode)((Object)key)};
        }
        if (key instanceof String && key.equals(WAIT_NODE)) {
            return new Node[]{WAIT_NODE};
        }
        return null;
    }

    private Class getCustomizer(String type) {
        Class customizer = null;
        if (type.equals("jdbc-connection-pool")) {
            customizer = ConnectionPoolCustomizer.class;
        } else if (type.equals("jdbc-resource")) {
            customizer = JdbcResourceCustomizer.class;
        } else if (type.equals("connector-resource")) {
            customizer = ConnectorCustomizer.class;
        } else if (type.equals("connector-connection-pool")) {
            customizer = ConnectorConnectionPoolCustomizer.class;
        } else if (type.equals("admin-object")) {
            customizer = AdminObjectCustomizer.class;
        } else if (type.equals("javamail-resource")) {
            customizer = JavaMailCustomizer.class;
        }
        return customizer;
    }

    class Hk2Resources
    extends Children.Keys<Object>
    implements Refreshable {
        private Lookup lookup;
        private String type;
        private Class customizer;
        private final Node WAIT_NODE = Hk2ItemNode.createWaitNode();

        Hk2Resources(Lookup lookup, String type, Class customizer) {
            this.lookup = lookup;
            this.type = type;
            this.customizer = customizer;
        }

        @Override
        public void updateKeys() {
            RequestProcessor.getDefault().post(new Runnable(){
                Vector<Object> keys = new Vector();

                @Override
                public void run() {
                    GlassfishModule commonSupport = (GlassfishModule)Hk2Resources.this.lookup.lookup(GlassfishModule.class);
                    if (commonSupport != null) {
                        try {
                            Map<String, String> ip = commonSupport.getInstanceProperties();
                            CommandRunner mgr = new CommandRunner(true, commonSupport.getCommandFactory(), ip, new OperationStateListener[0]);
                            Decorator decorator = DecoratorManager.findDecorator(Hk2Resources.this.type, null);
                            if (decorator == null) {
                                if (Hk2Resources.this.type.equals("jdbc-resource")) {
                                    decorator = Hk2ItemNode.JDBC_MANAGED_DATASOURCES;
                                } else if (Hk2Resources.this.type.equals("jdbc-connection-pool")) {
                                    decorator = Hk2ItemNode.CONNECTION_POOLS;
                                }
                            }
                            if (decorator != null) {
                                List<ResourceDesc> reslourcesList = mgr.getResources(Hk2Resources.this.type);
                                for (ResourceDesc resource : reslourcesList) {
                                    this.keys.add((Object)new Hk2ResourceNode(Hk2Resources.this.lookup, resource, (ResourceDecorator)decorator, Hk2Resources.this.customizer));
                                }
                            }
                        }
                        catch (Exception ex) {
                            Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
                        }
                        Hk2Resources.this.setKeys(this.keys);
                    }
                }
            }, 0);
        }

        protected void addNotify() {
            this.updateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object key) {
            if (key instanceof Hk2ItemNode) {
                return new Node[]{(Hk2ItemNode)((Object)key)};
            }
            if (key instanceof String && key.equals(this.WAIT_NODE)) {
                return new Node[]{this.WAIT_NODE};
            }
            return null;
        }
    }
}

