/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.wizards;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.glassfish.common.wizards.AddServerLocationVisualPanel;
import org.netbeans.modules.glassfish.common.wizards.ServerWizardIterator;
import org.netbeans.modules.glassfish.spi.TreeParser;
import org.netbeans.modules.glassfish.spi.Utils;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AddServerLocationPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private static final String DOMAIN_XML_PATH = "config/domain.xml";
    private final String PROP_ERROR_MESSAGE = "WizardPanel_errorMessage";
    private final String PROP_WARNING_MESSAGE = "WizardPanel_warningMessage";
    private final String PROP_INFO_MESSAGE = "WizardPanel_infoMessage";
    private ServerWizardIterator wizardIterator;
    private AddServerLocationVisualPanel component;
    private WizardDescriptor wizard;
    private transient List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private AtomicBoolean isValidating = new AtomicBoolean();
    private static Pattern ILLEGAL_WINDOWS_CHARS = Pattern.compile("<|>|\\\"");

    public AddServerLocationPanel(ServerWizardIterator wizardIterator) {
        this.wizardIterator = wizardIterator;
        this.wizard = null;
    }

    @Override
    public void stateChanged(ChangeEvent ev) {
        this.fireChangeEvent(ev);
    }

    private void fireChangeEvent(ChangeEvent ev) {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(ev);
        }
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddServerLocationVisualPanel(this.wizardIterator);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("registering_app_server_hk2_location");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValid() {
        if (this.isValidating.compareAndSet(false, true)) {
            try {
                this.wizardIterator.setHttpPort(-1);
                AddServerLocationVisualPanel panel = (AddServerLocationVisualPanel)this.getComponent();
                AddServerLocationVisualPanel.DownloadState downloadState = panel.getDownloadState();
                if (downloadState == AddServerLocationVisualPanel.DownloadState.DOWNLOADING) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)panel.getStatusText());
                    boolean bl = false;
                    return bl;
                }
                String locationStr = panel.getHk2HomeLocation();
                String string = locationStr = locationStr != null ? locationStr.trim() : null;
                if (locationStr == null || locationStr.length() == 0) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_BlankInstallDir"));
                    boolean bl = false;
                    return bl;
                }
                File installDir = new File(locationStr).getAbsoluteFile();
                File glassfishDir = this.getGlassfishRoot(installDir);
                File domainDir = this.getDefaultDomain(glassfishDir);
                if (!installDir.exists()) {
                    if (!AddServerLocationPanel.isLegalFolder(installDir)) {
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallDirInvalid", (Object)locationStr));
                        boolean bl = false;
                        return bl;
                    }
                    if (AddServerLocationPanel.canCreate(installDir)) {
                        if (downloadState == AddServerLocationVisualPanel.DownloadState.AVAILABLE) {
                            panel.updateMessageText(NbBundle.getMessage(AddServerLocationPanel.class, (String)"LBL_PreludeInstallDirWillBeUsed", (Object)AddServerLocationPanel.getSanitizedPath(installDir), (Object)this.wizardIterator.getNameOfBits()));
                            this.wizard.putProperty("WizardPanel_errorMessage", (Object)panel.getStatusText());
                            boolean bl = false;
                            return bl;
                        }
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_InstallDirDoesNotExist", (Object)AddServerLocationPanel.getSanitizedPath(installDir)));
                        boolean bl = false;
                        return bl;
                    }
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_CannotCreate", (Object)AddServerLocationPanel.getSanitizedPath(installDir)));
                    boolean bl = false;
                    return bl;
                }
                if (!this.wizardIterator.isValidInstall(installDir, glassfishDir, this.wizard)) {
                    boolean bl = false;
                    return bl;
                }
                if (!AddServerLocationPanel.isRegisterableDomain(domainDir)) {
                    this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"ERR_DefaultDomainInvalid", (Object)AddServerLocationPanel.getSanitizedPath(installDir)));
                } else {
                    AddServerLocationPanel.readServerConfiguration(domainDir, this.wizardIterator);
                    String uri = this.wizardIterator.formatUri(glassfishDir.getAbsolutePath(), "localhost", this.wizardIterator.getAdminPort());
                    if (-1 == this.wizardIterator.getHttpPort()) {
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidDomainData", (Object)domainDir.getName()));
                        boolean bl = false;
                        return bl;
                    }
                    if (-1 == this.wizardIterator.getAdminPort()) {
                        this.wizard.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(this.getClass(), (String)"ERR_InvalidDomainData", (Object)domainDir.getName()));
                        boolean bl = false;
                        return bl;
                    }
                    if (this.wizardIterator.hasServer(uri)) {
                        this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"MSG_DefaultDomainExists", (Object)AddServerLocationPanel.getSanitizedPath(installDir), (Object)"domain1"));
                        this.wizardIterator.setHttpPort(-1);
                    } else {
                        String statusText = panel.getStatusText();
                        if (statusText != null && statusText.length() > 0) {
                            this.wizard.putProperty("WizardPanel_errorMessage", (Object)statusText);
                            boolean bl = false;
                            return bl;
                        }
                        this.wizard.putProperty("WizardPanel_errorMessage", null);
                        this.wizard.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddServerLocationPanel.class, (String)"MSG_NextForSpecial"));
                    }
                }
                if (installDir.equals(glassfishDir)) {
                    installDir = glassfishDir.getParentFile();
                }
                this.wizardIterator.setInstallRoot(installDir.getAbsolutePath());
                this.wizardIterator.setGlassfishRoot(glassfishDir.getAbsolutePath());
                this.wizardIterator.setDomainLocation(domainDir.getAbsolutePath());
                boolean bl = true;
                return bl;
            }
            finally {
                this.isValidating.set(false);
            }
        }
        return false;
    }

    private static String getSanitizedPath(File dir) {
        return FileUtil.normalizeFile((File)dir).getPath();
    }

    private static boolean isLegalFolder(File installDir) {
        return AddServerLocationPanel.getCanonicalFile(installDir) != null && (!Utilities.isWindows() || !ILLEGAL_WINDOWS_CHARS.matcher(installDir.getPath()).find());
    }

    private static File getCanonicalFile(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException ex) {
            return null;
        }
    }

    static boolean canCreate(File dir) {
        if (dir.exists()) {
            return false;
        }
        while (dir != null && !dir.exists()) {
            dir = dir.getParentFile();
        }
        return dir != null ? dir.canRead() && Utils.canWrite(dir) : false;
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void readSettings(Object settings) {
        if (this.wizard == null) {
            this.wizard = (WizardDescriptor)settings;
        }
    }

    public void storeSettings(Object settings) {
    }

    public boolean isFinishPanel() {
        return this.wizardIterator.getHttpPort() != -1;
    }

    static boolean isRegisterableDomain(File domainDir) {
        File testFile = new File(domainDir, "logs");
        if (!testFile.exists()) {
            testFile = domainDir;
        }
        return Utils.canWrite(testFile) && AddServerLocationPanel.readServerConfiguration(domainDir, null);
    }

    private File getGlassfishRoot(File installDir) {
        File glassfishDir = new File(installDir, "glassfish");
        if (!glassfishDir.exists()) {
            glassfishDir = installDir;
        }
        return glassfishDir;
    }

    private File getDefaultDomain(File glassfishDir) {
        File domainsDir;
        File[] candidates;
        File retVal = new File(glassfishDir, "domains" + File.separator + "domain1");
        if (!AddServerLocationPanel.isRegisterableDomain(retVal) && null != (candidates = (domainsDir = new File(glassfishDir, "domains")).listFiles()) && candidates.length > 0) {
            for (File c : candidates) {
                if (!AddServerLocationPanel.isRegisterableDomain(c)) continue;
                retVal = c;
                break;
            }
        }
        return retVal;
    }

    static boolean readServerConfiguration(File domainDir, ServerWizardIterator wi) {
        boolean result = false;
        File domainXml = new File(domainDir, DOMAIN_XML_PATH);
        final LinkedHashMap httpMap = new LinkedHashMap();
        if (domainXml.exists()) {
            ArrayList<TreeParser.Path> pathList = new ArrayList<TreeParser.Path>();
            pathList.add(new TreeParser.Path("/domain/configs/config/http-service/http-listener", new TreeParser.NodeReader(){

                @Override
                public void readAttributes(String qname, Attributes attributes) throws SAXException {
                    try {
                        String id = attributes.getValue("id");
                        if (id != null && id.length() > 0) {
                            boolean enabled;
                            int port = Integer.parseInt(attributes.getValue("port"));
                            boolean secure = "true".equals(attributes.getValue("security-enabled"));
                            boolean bl = enabled = !"false".equals(attributes.getValue("enabled"));
                            if (enabled) {
                                HttpData data = new HttpData(id, port, secure);
                                Logger.getLogger("glassfish").log(Level.FINER, " Adding " + data);
                                httpMap.put(id, data);
                            } else {
                                Logger.getLogger("glassfish").log(Level.FINER, "http-listener " + id + " is not enabled and won't be used.");
                            }
                        } else {
                            Logger.getLogger("glassfish").log(Level.FINEST, "http-listener found with no name");
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new SAXException(ex);
                    }
                }
            }));
            pathList.add(new TreeParser.Path("/domain/configs/config/network-config/network-listeners/network-listener", new TreeParser.NodeReader(){

                @Override
                public void readAttributes(String qname, Attributes attributes) throws SAXException {
                    try {
                        String id = attributes.getValue("name");
                        if (id != null && id.length() > 0) {
                            boolean enabled;
                            String portAttr = attributes.getValue("port");
                            if (null == portAttr || portAttr.startsWith("$")) {
                                return;
                            }
                            int port = Integer.parseInt(portAttr);
                            boolean secure = "true".equals(attributes.getValue("security-enabled"));
                            boolean bl = enabled = !"false".equals(attributes.getValue("enabled"));
                            if (enabled) {
                                HttpData data = new HttpData(id, port, secure);
                                Logger.getLogger("glassfish").log(Level.FINER, " Adding " + data);
                                httpMap.put(id, data);
                            } else {
                                Logger.getLogger("glassfish").log(Level.FINER, "http-listener " + id + " is not enabled and won't be used.");
                            }
                        } else {
                            Logger.getLogger("glassfish").log(Level.FINEST, "http-listener found with no name");
                        }
                    }
                    catch (NumberFormatException ex) {
                        throw new SAXException(ex);
                    }
                }
            }));
            try {
                int adminPort;
                TreeParser.readXml(domainXml, pathList);
                HttpData adminData = (HttpData)httpMap.remove("admin-listener");
                if (null != wi) {
                    wi.setAdminPort(adminData != null ? adminData.getPort() : -1);
                }
                HttpData httpData = null;
                HttpData httpsData = null;
                for (HttpData data : httpMap.values()) {
                    if (data.isSecure()) {
                        if (httpsData == null) {
                            httpsData = data;
                        }
                    } else if (httpData == null) {
                        httpData = data;
                    }
                    if (httpData == null || httpsData == null) continue;
                    break;
                }
                int httpPort = httpData != null ? httpData.getPort() : -1;
                int n = adminPort = null != adminData ? adminData.getPort() : -1;
                if (null != wi) {
                    wi.setHttpPort(httpPort);
                    wi.setHttpsPort(httpsData != null ? httpsData.getPort() : -1);
                }
                result = httpPort != -1 && adminPort != -1;
            }
            catch (IllegalStateException ex) {
                Logger.getLogger("glassfish").log(Level.INFO, ex.getLocalizedMessage(), ex);
            }
        }
        return result;
    }

    private static class HttpData {
        private final String id;
        private final int port;
        private final boolean secure;

        public HttpData(String id, int port, boolean secure) {
            this.id = id;
            this.port = port;
            this.secure = secure;
        }

        public String getId() {
            return this.id;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isSecure() {
            return this.secure;
        }

        public String toString() {
            return "{ " + this.id + ", " + this.port + ", " + this.secure + " }";
        }
    }
}

