/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl;

import java.util.Collection;
import java.util.prefs.Preferences;
import javax.swing.text.EditorKit;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.EditorStyleConstants;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.AcceptorFactory;
import org.netbeans.modules.editor.FormatterIndentEngine;
import org.netbeans.modules.editor.IndentEngineFormatter;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.openide.text.IndentEngine;
import org.openide.util.Lookup;

public final class ComplexValueSettingsFactory {
    private ComplexValueSettingsFactory() {
    }

    public static final Object getRenderingHintsValue(MimePath mimePath, String settingName) {
        assert (settingName.equals("rendering-hints")) : "The getRenderingHints factory called for '" + settingName + "'";
        FontColorSettings fcs = (FontColorSettings)MimeLookup.getLookup((MimePath)mimePath).lookup(FontColorSettings.class);
        return fcs.getFontColors("default").getAttribute(EditorStyleConstants.RenderingHints);
    }

    public static final Object getFormatterValue(MimePath mimePath, String settingName) {
        assert (settingName.equals("formatter")) : "The getFormatter factory called for '" + settingName + "'";
        IndentEngine eng = ComplexValueSettingsFactory.getIndentEngine(mimePath);
        if (eng != null) {
            if (eng instanceof FormatterIndentEngine) {
                return ((FormatterIndentEngine)eng).getFormatter();
            }
            EditorKit kit = (EditorKit)MimeLookup.getLookup((MimePath)mimePath).lookup(EditorKit.class);
            if (kit != null) {
                return new IndentEngineFormatter(kit.getClass(), eng);
            }
        }
        return null;
    }

    public static final IndentEngine getIndentEngine(MimePath mimePath) {
        IndentEngine eng = null;
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
        String handle = prefs.get("indentEngine", null);
        if (handle != null && handle.indexOf(46) == -1) {
            Lookup.Template query = new Lookup.Template(IndentEngine.class, handle, null);
            Collection all = Lookup.getDefault().lookup(query).allInstances();
            if (!all.isEmpty()) {
                eng = (IndentEngine)all.iterator().next();
            }
        } else {
            eng = (IndentEngine)SettingsConversions.callFactory((Preferences)prefs, (MimePath)mimePath, (String)"indentEngine", null);
        }
        return eng;
    }

    public static final Object getIdentifierAcceptorValue(MimePath mimePath, String settingName) {
        assert (settingName.equals("identifier-acceptor")) : "The getIdentifierAcceptorValue factory called for '" + settingName + "'";
        return AcceptorFactory.LETTER_DIGIT;
    }

    public static final Object getWhitespaceAcceptorValue(MimePath mimePath, String settingName) {
        assert (settingName.equals("whitespace-acceptor")) : "The getWhitespaceAcceptorValue factory called for '" + settingName + "'";
        return AcceptorFactory.WHITESPACE;
    }
}

