/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common.models;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.cnd.debugger.common.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.common.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.CndBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.common.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.common.models.BoldVariablesTableModelFilterFirst;
import org.netbeans.modules.cnd.debugger.common.models.BreakpointsTreeModelFilter;
import org.netbeans.modules.cnd.debugger.common.utils.GeneralUtils;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.NbBundle;

public class BreakpointsNodeModel
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String DISABLED_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    public static final String LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpoint";
    public static final String DISABLED_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledConditionalBreakpoint";
    public static final String DISABLED_CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpointHit";
    public static final String CURRENT_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpointHit";
    public static final String CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/BreakpointHit";
    public static final String CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpointHit";
    public static final String DISABLED_CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpointHit";
    private Collection<ModelListener> listeners = new CopyOnWriteArrayList<ModelListener>();
    private CndBreakpoint currentBreakpoint;

    public String getDisplayName(Object o) throws UnknownTypeException {
        if (o instanceof LineBreakpoint) {
            int max;
            int num0;
            LineBreakpoint b = (LineBreakpoint)((Object)o);
            int lineNum = b.getLineNumber();
            String line = Integer.toString(lineNum);
            Integer maxInt = BreakpointsTreeModelFilter.MAX_LINES.get((Object)b);
            if (maxInt != null && (num0 = GeneralUtils.log10(max = maxInt.intValue()) - GeneralUtils.log10(lineNum)) > 0) {
                line = GeneralUtils.zeros(num0) + line;
            }
            return this.bold(b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName(b), (Object)line));
        }
        if (o instanceof FunctionBreakpoint) {
            FunctionBreakpoint b = (FunctionBreakpoint)((Object)o);
            String className = "";
            if (b.getFunctionName().equals("")) {
                return this.bold(b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Functions_Breakpoint", (Object)BreakpointsNodeModel.getShort(className)));
            }
            String clazz = BreakpointsNodeModel.getShort(className);
            if (clazz != null && clazz.length() > 0) {
                return this.bold(b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint_With_Class", (Object)BreakpointsNodeModel.getShort(className), (Object)b.getFunctionName()));
            }
            return this.bold(b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint", (Object)b.getFunctionName()));
        }
        if (o instanceof AddressBreakpoint) {
            AddressBreakpoint b = (AddressBreakpoint)o;
            return this.bold(b, NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Address_Breakpoint", (Object)b.getAddress()));
        }
        throw new UnknownTypeException(o);
    }

    public String getShortDescription(Object o) throws UnknownTypeException {
        if (o instanceof LineBreakpoint) {
            return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Line_Breakpoint", (Object)EditorContextBridge.getFileName((LineBreakpoint)((Object)o)), (Object)((LineBreakpoint)((Object)o)).getLineNumber());
        }
        if (o instanceof FunctionBreakpoint) {
            FunctionBreakpoint b = (FunctionBreakpoint)((Object)o);
            String className = "";
            if (b.getFunctionName().equals("")) {
                return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_All_Functions_Breakpoint", (Object)className);
            }
            return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Function_Breakpoint", (Object)b.getFunctionName());
        }
        if (o instanceof AddressBreakpoint) {
            return NbBundle.getMessage(BreakpointsNodeModel.class, (String)"CTL_Address_Breakpoint", (Object)((AddressBreakpoint)o).getAddress());
        }
        throw new UnknownTypeException(o);
    }

    public String getIconBase(Object o) throws UnknownTypeException {
        boolean disabled;
        boolean current = this.currentBreakpoint == o;
        boolean bl = disabled = !((Breakpoint)o).isEnabled();
        if (o instanceof LineBreakpoint || o instanceof AddressBreakpoint) {
            boolean conditional;
            String condition = ((CndBreakpoint)((Object)o)).getCondition();
            boolean bl2 = conditional = condition != null && condition.trim().length() > 0;
            String iconBase = current ? (disabled ? (conditional ? DISABLED_LINE_CONDITIONAL_BREAKPOINT : DISABLED_CURRENT_LINE_BREAKPOINT) : (conditional ? CURRENT_LINE_CONDITIONAL_BREAKPOINT : CURRENT_LINE_BREAKPOINT)) : (disabled ? (conditional ? DISABLED_LINE_CONDITIONAL_BREAKPOINT : DISABLED_LINE_BREAKPOINT) : (conditional ? LINE_CONDITIONAL_BREAKPOINT : LINE_BREAKPOINT));
            return iconBase;
        }
        if (o instanceof FunctionBreakpoint) {
            String iconBase = current ? (disabled ? DISABLED_CURRENT_BREAKPOINT : CURRENT_BREAKPOINT) : (disabled ? DISABLED_BREAKPOINT : BREAKPOINT);
            return iconBase;
        }
        throw new UnknownTypeException(o);
    }

    public void addModelListener(ModelListener l) {
        this.listeners.add(l);
    }

    public void removeModelListener(ModelListener l) {
        this.listeners.remove(l);
    }

    void fireNodeChanged(CndBreakpoint b) {
        for (ModelListener listener : this.listeners) {
            listener.modelChanged((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)b));
        }
    }

    static String getShort(String s) {
        if (s.indexOf(42) >= 0) {
            return s;
        }
        int i = s.lastIndexOf(46);
        if (i < 0) {
            return s;
        }
        return s.substring(i + 1);
    }

    private String bold(CndBreakpoint b, String name) {
        return b == this.currentBreakpoint ? BoldVariablesTableModelFilterFirst.toHTML(name, true, false, null) : name;
    }

    public void setCurrentBreakpoint(CndBreakpoint currentBreakpoint) {
        CndBreakpoint oldCurrentBreakpoint = this.currentBreakpoint;
        this.currentBreakpoint = currentBreakpoint;
        if (oldCurrentBreakpoint != null) {
            this.fireNodeChanged(oldCurrentBreakpoint);
        }
        if (currentBreakpoint != null) {
            this.fireNodeChanged(currentBreakpoint);
        }
    }
}

