/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.dev.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JPanel;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class NodeDisplayPanel
extends JPanel
implements ExplorerManager.Provider {
    private PropertyChangeSupport pcs;
    private ExplorerManager manager = new ExplorerManager();

    public NodeDisplayPanel(Node rootNode) {
        BeanTreeView btv = new BeanTreeView();
        btv.setRootVisible(false);
        btv.setDefaultActionAllowed(false);
        btv.setSelectionMode(1);
        this.manager.setRootContext(rootNode);
        Node[] rootChildren = rootNode.getChildren().getNodes();
        for (int i = 0; i < rootChildren.length; ++i) {
            btv.expandNode(rootChildren[i]);
        }
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                NodeDisplayPanel.this.firePropertyChange();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)btv, "Center");
        btv.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NodeDisplayPanel.class, (String)"ACSD_PortNodeTreeView"));
        btv.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NodeDisplayPanel.class, (String)"ACSD_PortNodeTreeView"));
    }

    private PropertyChangeSupport getProperChangeSupport() {
        if (this.pcs == null) {
            this.pcs = new PropertyChangeSupport(this);
        }
        return this.pcs;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.getProperChangeSupport().addPropertyChangeListener(l);
    }

    private void firePropertyChange() {
        this.getProperChangeSupport().firePropertyChange("nodeChange", null, null);
    }

    public Node[] getSelectedNodes() {
        return this.manager.getSelectedNodes();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }
}

