/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmBuiltIn;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.ObjectBasedUID;
import org.openide.util.CharSequences;

public class BuiltinTypes {
    private static final Map<CharSequence, CsmBuiltIn> types = new HashMap<CharSequence, CsmBuiltIn>();

    private BuiltinTypes() {
    }

    public static CsmBuiltIn getBuiltIn(AST aST) {
        assert (aST.getType() == 466);
        StringBuilder stringBuilder = new StringBuilder();
        for (AST aST2 = aST.getFirstChild(); aST2 != null; aST2 = aST2.getNextSibling()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(aST2.getText());
        }
        return BuiltinTypes.getBuiltIn(stringBuilder.toString());
    }

    public static CsmBuiltIn getBuiltIn(CharSequence charSequence) {
        charSequence = QualifiedNameCache.getManager().getString(charSequence);
        CsmBuiltIn csmBuiltIn = types.get(charSequence);
        if (csmBuiltIn == null) {
            csmBuiltIn = new BuiltinImpl(charSequence);
            types.put(charSequence, csmBuiltIn);
        }
        return csmBuiltIn;
    }

    public static ObjectBasedUID readUID(DataInput dataInput) throws IOException {
        CharSequence charSequence = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        CsmBuiltIn csmBuiltIn = BuiltinTypes.getBuiltIn(charSequence);
        ObjectBasedUID objectBasedUID = (ObjectBasedUID)UIDs.get((Object)csmBuiltIn);
        assert (objectBasedUID != null);
        return objectBasedUID;
    }

    public static final class BuiltInUID
    extends ObjectBasedUID<CsmBuiltIn> {
        private BuiltInUID(CsmBuiltIn csmBuiltIn) {
            super(csmBuiltIn);
        }

        @Override
        public String toString() {
            String string = "<BUILT-IN UID> " + super.toString();
            return string;
        }

        @Override
        public void write(DataOutput dataOutput) throws IOException {
            BuiltinImpl builtinImpl = (BuiltinImpl)this.getObject();
            assert (builtinImpl != null);
            assert (builtinImpl.getName() != null);
            PersistentUtils.writeUTF(builtinImpl.getName(), dataOutput);
        }
    }

    private static class BuiltinImpl
    implements CsmBuiltIn,
    CsmIdentifiable {
        private final CharSequence name;
        private final CsmUID<CsmBuiltIn> uid;

        private BuiltinImpl(CharSequence charSequence) {
            this.name = charSequence;
            this.uid = new BuiltInUID(this);
        }

        public CharSequence getQualifiedName() {
            return this.getName();
        }

        public CharSequence getUniqueName() {
            return CharSequences.create((CharSequence)(Utils.getCsmDeclarationKindkey(this.getKind()) + ':' + this.getQualifiedName()));
        }

        public CharSequence getName() {
            assert (this.name != null && this.name.length() > 0);
            return this.name;
        }

        public CsmDeclaration.Kind getKind() {
            return CsmDeclaration.Kind.BUILT_IN;
        }

        public CsmScope getScope() {
            return null;
        }

        public CsmUID<CsmBuiltIn> getUID() {
            return this.uid;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            BuiltinImpl builtinImpl = (BuiltinImpl)object;
            return this.name.equals(builtinImpl.name);
        }

        public String toString() {
            return "" + this.getKind() + " " + this.getQualifiedName();
        }

        public boolean isValid() {
            return true;
        }
    }
}

