/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmQualifiedNamedElement;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.CsmVariableDefinition;
import org.netbeans.modules.cnd.api.model.deep.CsmExpression;
import org.netbeans.modules.cnd.modelimpl.csm.MutableDeclarationsContainer;
import org.netbeans.modules.cnd.modelimpl.csm.TypeImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.ExpressionBase;
import org.netbeans.modules.cnd.modelimpl.parser.CsmAST;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.openide.util.CharSequences;

public class VariableImpl<T>
extends OffsetableDeclarationBase<T>
implements CsmVariable,
Disposable {
    private final CharSequence name;
    private final CsmType type;
    private boolean _static = false;
    private CsmScope scopeRef;
    private CsmUID<CsmScope> scopeUID;
    private boolean _extern;
    private ExpressionBase initExpr;

    public VariableImpl(AST aST, CsmFile csmFile, CsmType csmType, String string, CsmScope csmScope, boolean bl, boolean bl2) {
        super(csmFile, VariableImpl.getStartOffset(aST), VariableImpl.getEndOffset(aST));
        this.initInitialValue(aST);
        this._static = AstUtil.hasChildOfType(aST, 131);
        this._extern = AstUtil.hasChildOfType(aST, 118);
        this.name = NameCache.getManager().getString((CharSequence)string);
        this.type = csmType;
        this._setScope(csmScope);
        if (bl) {
            this.registerInProject();
        }
        if (bl2) {
            if (!bl) {
                RepositoryUtils.put(this);
            }
        } else {
            Utils.setSelfUID(this);
        }
    }

    public VariableImpl(CsmOffsetable csmOffsetable, CsmFile csmFile, CsmType csmType, String string, CsmScope csmScope, boolean bl, boolean bl2, boolean bl3) {
        super(csmFile, csmOffsetable);
        this._static = bl;
        this._extern = bl2;
        this.name = NameCache.getManager().getString((CharSequence)string);
        this.type = csmType;
        this._setScope(csmScope);
        if (bl3) {
            this.registerInProject();
        } else {
            Utils.setSelfUID(this);
        }
    }

    public VariableImpl(CsmFile csmFile, int n, int n2, CsmType csmType, String string, CsmScope csmScope, boolean bl, boolean bl2, boolean bl3) {
        super(csmFile, n, n2);
        this._static = bl;
        this._extern = bl2;
        this.name = NameCache.getManager().getString((CharSequence)string);
        this.type = csmType;
        this._setScope(csmScope);
        if (bl3) {
            this.registerInProject();
        } else {
            Utils.setSelfUID(this);
        }
    }

    public static int getStartOffset(AST aST) {
        CsmAST csmAST;
        if (aST != null && (csmAST = AstUtil.getFirstCsmAST(aST)) != null) {
            return csmAST.getOffset();
        }
        return 0;
    }

    public static int getEndOffset(AST aST) {
        int n = 0;
        if (aST != null) {
            AST aST2;
            AST aST3 = AstUtil.getLastChildRecursively(aST);
            if (aST3 instanceof CsmAST) {
                n = ((CsmAST)aST3).getEndOffset();
            }
            if (aST.getType() == 534 && (aST2 = aST.getNextSibling()) != null && aST2.getType() == 6) {
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                while (aST2 != null && (n2 != 0 || aST2.getType() != 8) && aST2.getType() != 10) {
                    if (aST2.getType() != 16) {
                        ++n2;
                    }
                    if (aST2.getType() != 17) {
                        --n2;
                    }
                    if (aST2.getType() != 21) {
                        ++n3;
                    }
                    if (aST2.getType() != 23) {
                        --n3;
                    }
                    if (aST2.getType() != 12) {
                        ++n4;
                    }
                    if (aST2.getType() != 13) {
                        --n4;
                    }
                    if ((aST3 = AstUtil.getLastChildRecursively(aST2)) instanceof CsmAST) {
                        n = ((CsmAST)aST3).getEndOffset();
                    }
                    aST2 = aST2.getNextSibling();
                }
            }
        }
        return n;
    }

    protected final void registerInProject() {
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).registerDeclaration(this);
        }
    }

    private void unregisterInProject() {
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            ((ProjectBase)csmProject).unregisterDeclaration(this);
            this.cleanUID();
        }
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CsmScope csmScope = this.getScope();
        if (csmScope instanceof CsmNamespace || csmScope instanceof CsmClass) {
            return CharSequences.create((CharSequence)(((CsmQualifiedNamedElement)csmScope).getQualifiedName() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    @Override
    public CharSequence getUniqueNameWithoutPrefix() {
        if (this.isExtern()) {
            return this.getQualifiedName() + " (EXTERN)";
        }
        return this.getQualifiedName();
    }

    public CsmType getType() {
        return this.type;
    }

    private final void initInitialValue(AST aST) {
        if (aST != null) {
            AST aST2;
            Object object;
            int n = 0;
            int n2 = 0;
            Object object2 = AstUtil.findChildOfType(aST, 6);
            if (object2 == null && aST.getType() == 534 && (object = aST.getNextSibling()) != null && object.getType() == 6) {
                object2 = object;
            }
            if (object2 != null) {
                object2 = object2.getNextSibling();
            }
            if (object2 != null && (object = AstUtil.getFirstCsmAST(object2)) != null) {
                n = ((CsmAST)object).getOffset();
            }
            object = object2;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            while (object2 != null && (n3 != 0 || n4 != 0 || n5 != 0 || object2.getType() != 8) && object2.getType() != 10) {
                if (object2.getType() != 16) {
                    ++n3;
                }
                if (object2.getType() != 17) {
                    --n3;
                }
                if (object2.getType() != 21) {
                    ++n4;
                }
                if (object2.getType() != 23) {
                    --n4;
                }
                if (object2.getType() != 12) {
                    ++n5;
                }
                if (object2.getType() != 13) {
                    --n5;
                }
                object = object2;
                object2 = object2.getNextSibling();
            }
            if (object != null && (aST2 = AstUtil.getLastChildRecursively((AST)object)) != null && aST2 instanceof CsmAST) {
                n2 = ((CsmAST)aST2).getEndOffset();
                this.initExpr = new ExpressionBase(n, n2, this.getContainingFile(), null, this._getScope());
            }
        }
    }

    public CsmExpression getInitialValue() {
        return this.initExpr;
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.VARIABLE;
    }

    public String getDeclarationText() {
        return "";
    }

    public boolean isAuto() {
        return true;
    }

    public boolean isRegister() {
        return false;
    }

    public boolean isStatic() {
        return this._static;
    }

    public void setStatic(boolean bl) {
        this._static = bl;
    }

    public boolean isExtern() {
        return this._extern;
    }

    public void setExtern(boolean bl) {
        this._extern = bl;
    }

    public boolean isConst() {
        CsmType csmType = this.getType();
        if (csmType != null) {
            return csmType.isConst();
        }
        return false;
    }

    public boolean isMutable() {
        return false;
    }

    public void setScope(CsmScope csmScope, boolean bl) {
        this.unregisterInProject();
        this._setScope(csmScope);
        if (bl) {
            this.registerInProject();
        }
    }

    public synchronized CsmScope getScope() {
        return this._getScope();
    }

    @Override
    public void dispose() {
        super.dispose();
        this.onDispose();
        if (this.type != null && this.type instanceof Disposable) {
            ((Disposable)this.type).dispose();
        }
        if (this._getScope() instanceof MutableDeclarationsContainer) {
            ((MutableDeclarationsContainer)this._getScope()).removeDeclaration(this);
        }
        this.unregisterInProject();
    }

    private synchronized void onDispose() {
        if (this.scopeRef == null) {
            this.scopeRef = UIDCsmConverter.UIDtoScope(this.scopeUID);
            assert (this.scopeRef != null || this.scopeUID == null) : "empty scope for UID " + this.scopeUID;
        }
    }

    public CsmVariableDefinition getDefinition() {
        String string = Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.VARIABLE_DEFINITION) + ':' + this.getQualifiedName();
        CsmDeclaration csmDeclaration = this.getContainingFile().getProject().findDeclaration((CharSequence)string);
        return csmDeclaration == null ? null : (CsmVariableDefinition)csmDeclaration;
    }

    private CsmScope _getScope() {
        CsmScope csmScope = this.scopeRef;
        if (csmScope == null) {
            csmScope = UIDCsmConverter.UIDtoScope(this.scopeUID);
        }
        return csmScope;
    }

    private void _setScope(CsmScope csmScope) {
        if (csmScope instanceof CsmIdentifiable) {
            this.scopeUID = UIDCsmConverter.scopeToUID(csmScope);
            assert (this.scopeUID != null || csmScope == null);
        } else {
            this.scopeRef = csmScope;
        }
    }

    public CharSequence getDisplayText() {
        StringBuilder stringBuilder = new StringBuilder();
        CsmType csmType = this.getType();
        if (csmType instanceof TypeImpl) {
            return ((TypeImpl)csmType).getText(false, this.getName()).toString();
        }
        if (csmType != null) {
            stringBuilder.append(csmType.getText());
            CharSequence charSequence = this.getName();
            if (charSequence != null && charSequence.length() > 0) {
                stringBuilder.append(' ');
                stringBuilder.append(charSequence);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public CharSequence getText() {
        return this.getDisplayText();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        byte by = (byte)((this._static ? 1 : 0) | (this._extern ? 2 : 0));
        dataOutput.writeByte(by);
        PersistentUtils.writeExpression(this.initExpr, dataOutput);
        PersistentUtils.writeType(this.type, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.scopeUID, dataOutput);
    }

    public VariableImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, NameCache.getManager());
        assert (this.name != null);
        byte by = dataInput.readByte();
        this._static = (by & 1) == 1;
        this._extern = (by & 2) == 2;
        this.initExpr = (ExpressionBase)PersistentUtils.readExpression(dataInput);
        this.type = PersistentUtils.readType(dataInput);
        this.scopeUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.scopeRef = null;
    }

    @Override
    public String toString() {
        return (this.isExtern() ? "EXTERN " : "") + super.toString();
    }
}

