/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.antlr.Token;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTDefine;
import org.netbeans.modules.cnd.apt.structure.APTElif;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.structure.APTIf;
import org.netbeans.modules.cnd.apt.structure.APTIfdef;
import org.netbeans.modules.cnd.apt.structure.APTIfndef;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.structure.APTIncludeNext;
import org.netbeans.modules.cnd.apt.structure.APTUndefine;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTMacro;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTToken;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.modelimpl.csm.MacroImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTSelfWalker;

public final class APTFindMacrosWalker
extends APTSelfWalker {
    private final List<CsmReference> references = new ArrayList<CsmReference>();
    private final CsmFile csmFile;

    public APTFindMacrosWalker(APTFile aPTFile, CsmFile csmFile, APTPreprocHandler aPTPreprocHandler, APTFileCacheEntry aPTFileCacheEntry) {
        super(aPTFile, aPTPreprocHandler, aPTFileCacheEntry);
        this.csmFile = csmFile;
    }

    protected void onDefine(APT aPT) {
        APTMacro aPTMacro;
        APTDefine aPTDefine = (APTDefine)aPT;
        int n = this.references.size();
        this.analyzeList(aPTDefine.getBody());
        super.onDefine(aPT);
        APTToken aPTToken = aPTDefine.getName();
        if (aPTToken != null && (aPTMacro = this.getMacroMap().getMacro(aPTToken)) != null) {
            MacroReference macroReference = new MacroReference(this.csmFile, aPTToken, aPTMacro, CsmReferenceKind.DECLARATION);
            if (this.references.size() == n) {
                this.references.add(macroReference);
            } else {
                this.references.add(n, macroReference);
            }
        }
    }

    protected boolean onIf(APT aPT) {
        this.analyzeStream(((APTIf)aPT).getCondition(), false);
        return super.onIf(aPT);
    }

    protected boolean onElif(APT aPT, boolean bl) {
        this.analyzeStream(((APTElif)aPT).getCondition(), false);
        return super.onElif(aPT, bl);
    }

    protected boolean onIfndef(APT aPT) {
        this.analyzeToken(((APTIfndef)aPT).getMacroName(), false);
        return super.onIfndef(aPT);
    }

    protected boolean onIfdef(APT aPT) {
        this.analyzeToken(((APTIfdef)aPT).getMacroName(), false);
        return super.onIfdef(aPT);
    }

    protected void onUndef(APT aPT) {
        this.analyzeToken(((APTUndefine)aPT).getName(), false);
        super.onUndef(aPT);
    }

    protected void onInclude(APT aPT) {
        this.analyzeStream(((APTInclude)aPT).getInclude(), true);
        super.onInclude(aPT);
    }

    protected void onIncludeNext(APT aPT) {
        this.analyzeStream(((APTIncludeNext)aPT).getInclude(), true);
        super.onIncludeNext(aPT);
    }

    public List<CsmReference> collectMacros() {
        TokenStream tokenStream = super.getTokenStream();
        this.analyzeStream(tokenStream, true);
        return this.references;
    }

    private CsmReference analyzeToken(APTToken aPTToken, boolean bl) {
        APTMacro aPTMacro;
        OffsetableBase offsetableBase = null;
        boolean bl2 = false;
        if (aPTToken != null && !APTUtils.isEOF((Token)aPTToken) && (aPTMacro = this.getMacroMap().getMacro(aPTToken)) != null) {
            bl2 = aPTMacro.isFunctionLike();
            switch (aPTMacro.getKind()) {
                case DEFINED: {
                    offsetableBase = new MacroReference(this.csmFile, aPTToken, aPTMacro, CsmReferenceKind.DIRECT_USAGE);
                    break;
                }
                default: {
                    offsetableBase = new SysMacroReference(this.csmFile, aPTToken, aPTMacro);
                }
            }
        }
        if (!(offsetableBase == null || bl2 && bl)) {
            this.references.add((CsmReference)offsetableBase);
            offsetableBase = null;
        }
        return offsetableBase;
    }

    private void analyzeList(List<APTToken> list) {
        if (list != null) {
            for (APTToken aPTToken : list) {
                this.analyzeToken(aPTToken, false);
            }
        }
    }

    private void analyzeStream(TokenStream tokenStream, boolean bl) {
        if (tokenStream != null) {
            try {
                APTToken aPTToken = (APTToken)tokenStream.nextToken();
                while (!APTUtils.isEOF((Token)aPTToken)) {
                    CsmReference csmReference = this.analyzeToken(aPTToken, bl);
                    aPTToken = (APTToken)tokenStream.nextToken();
                    if (csmReference == null) continue;
                    assert (bl);
                    if (aPTToken.getType() != 12) continue;
                    this.references.add(csmReference);
                }
            }
            catch (TokenStreamException tokenStreamException) {
                DiagnosticExceptoins.register(tokenStreamException);
            }
        }
    }

    private static final class MacroReference
    extends OffsetableBase
    implements CsmReference {
        private volatile CsmMacro ref = null;
        private final CharSequence macroName;
        private final APTMacro macro;
        private final CsmReferenceKind kind;

        public MacroReference(CsmFile csmFile, APTToken aPTToken, APTMacro aPTMacro, CsmReferenceKind csmReferenceKind) {
            super(csmFile, aPTToken.getOffset(), aPTToken.getEndOffset());
            this.macroName = aPTToken.getTextID();
            assert (this.macroName != null);
            this.macro = aPTMacro;
            this.kind = csmReferenceKind;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CsmObject getReferencedObject() {
            CsmMacro csmMacro = this.ref;
            if (csmMacro == null && this.macro != null) {
                MacroReference macroReference = this;
                synchronized (macroReference) {
                    csmMacro = this.ref;
                    if (csmMacro == null) {
                        int n = this.macro.getDefineNode().getOffset();
                        CsmFile csmFile = this.getTargetFile();
                        if (csmFile != null) {
                            CsmSelect.CsmFilter csmFilter = CsmSelect.getFilterBuilder().createNameFilter(this.macroName, true, true, false);
                            Iterator iterator = CsmSelect.getMacros((CsmFile)csmFile, (CsmSelect.CsmFilter)csmFilter);
                            while (iterator.hasNext()) {
                                CsmMacro csmMacro2 = (CsmMacro)iterator.next();
                                if (csmMacro2 == null || n != csmMacro2.getStartOffset()) continue;
                                csmMacro = csmMacro2;
                                break;
                            }
                            if (csmMacro == null) {
                                if (csmFile instanceof Unresolved.UnresolvedFile) {
                                    csmMacro = MacroImpl.createSystemMacro(this.macroName, "", csmFile, CsmMacro.Kind.USER_SPECIFIED);
                                } else {
                                    csmMacro = new MacroImpl(this.macroName, null, "", csmFile, new OffsetableBase(csmFile, n, n + this.macroName.length()), CsmMacro.Kind.DEFINED);
                                    Utils.setSelfUID((CsmObject)csmMacro);
                                }
                            }
                        }
                        this.ref = csmMacro;
                    }
                }
            }
            return csmMacro;
        }

        private CsmFile getTargetFile() {
            CsmFile csmFile;
            CsmFile csmFile2 = this.getContainingFile();
            if (this.kind == CsmReferenceKind.DECLARATION) {
                csmFile = csmFile2;
            } else {
                csmFile = null;
                CharSequence charSequence = this.macro.getFile();
                if (csmFile2 != null && charSequence.length() > 0) {
                    ProjectBase projectBase;
                    ProjectBase projectBase2 = ((ProjectBase)csmFile2.getProject()).findFileProject(charSequence);
                    if (projectBase2 != null) {
                        csmFile = projectBase2.findFile(charSequence, false);
                    }
                    if (csmFile == null) {
                        csmFile = CsmModelAccessor.getModel().findFile(charSequence, false);
                    }
                    if (csmFile == null && projectBase2 != null) {
                        csmFile = projectBase2.getUnresolvedFile();
                    }
                    if (csmFile == null && (projectBase = (ProjectBase)csmFile2.getProject()) != null) {
                        csmFile = projectBase.getUnresolvedFile();
                    }
                }
            }
            return csmFile;
        }

        public CsmObject getOwner() {
            return this.kind == CsmReferenceKind.DECLARATION ? this.getContainingFile() : this.getReferencedObject();
        }

        public CsmReferenceKind getKind() {
            return this.kind;
        }

        @Override
        public CharSequence getText() {
            return this.macroName;
        }
    }

    private static final class SysMacroReference
    extends OffsetableBase
    implements CsmReference {
        private final CsmObject ref;
        private final CharSequence text;

        public SysMacroReference(CsmFile csmFile, APTToken aPTToken, APTMacro aPTMacro) {
            super(csmFile, aPTToken.getOffset(), aPTToken.getEndOffset());
            CsmMacro.Kind kind;
            this.text = aPTToken.getTextID();
            switch (aPTMacro.getKind()) {
                case COMPILER_PREDEFINED: {
                    kind = CsmMacro.Kind.COMPILER_PREDEFINED;
                    break;
                }
                case POSITION_PREDEFINED: {
                    kind = CsmMacro.Kind.POSITION_PREDEFINED;
                    break;
                }
                case DEFINED: {
                    kind = CsmMacro.Kind.DEFINED;
                    break;
                }
                case USER_SPECIFIED: {
                    kind = CsmMacro.Kind.USER_SPECIFIED;
                    break;
                }
                default: {
                    System.err.println("unexpected kind in macro " + aPTMacro);
                    kind = CsmMacro.Kind.USER_SPECIFIED;
                }
            }
            this.ref = MacroImpl.createSystemMacro(aPTToken.getTextID(), APTUtils.stringize((TokenStream)aPTMacro.getBody(), (boolean)false), ((ProjectBase)csmFile.getProject()).getUnresolvedFile(), kind);
        }

        public CsmObject getReferencedObject() {
            return this.ref;
        }

        public CsmObject getOwner() {
            return this.getContainingFile();
        }

        public CsmReferenceKind getKind() {
            return CsmReferenceKind.DIRECT_USAGE;
        }

        @Override
        public CharSequence getText() {
            return this.text;
        }
    }
}

