/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.junit.output;

import java.util.ArrayList;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.DiffViewAction;
import org.netbeans.modules.gsf.testrunner.api.TestMethodNode;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.junit.output.JUnitTestcase;
import org.netbeans.modules.junit.output.JumpAction;
import org.netbeans.modules.junit.output.TestMethodNodeAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SingleMethod;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class JUnitTestMethodNode
extends TestMethodNode {
    public JUnitTestMethodNode(Testcase testcase, Project project, Lookup lookup) {
        super(testcase, project, lookup);
    }

    public JUnitTestMethodNode(Testcase testcase, Project project) {
        super(testcase, project);
    }

    public Action[] getActions(boolean context) {
        ActionProvider actionProvider;
        FileObject testFO;
        ArrayList<Action> actions = new ArrayList<Action>();
        Action preferred = this.getPreferredAction();
        if (preferred != null) {
            actions.add(preferred);
        }
        if ((testFO = ((JUnitTestcase)this.testcase).getClassFileObject()) != null && (actionProvider = JUnitTestMethodNode.getActionProvider(testFO)) != null) {
            boolean runSupported = false;
            boolean debugSupported = false;
            for (String action : actionProvider.getSupportedActions()) {
                if (!runSupported && action.equals("run.single.method")) {
                    runSupported = true;
                    if (debugSupported) break;
                }
                if (debugSupported || !action.equals("debug.single.method")) continue;
                debugSupported = true;
                if (runSupported) break;
            }
            SingleMethod methodSpec = new SingleMethod(testFO, this.testcase.getName());
            Lookup nodeContext = Lookups.singleton((Object)methodSpec);
            if (runSupported && actionProvider.isActionEnabled("run.single.method", nodeContext)) {
                actions.add(new TestMethodNodeAction(actionProvider, nodeContext, "run.single.method", "LBL_RerunTest"));
            }
            if (debugSupported && actionProvider.isActionEnabled("debug.single.method", nodeContext)) {
                actions.add(new TestMethodNodeAction(actionProvider, nodeContext, "debug.single.method", "LBL_DebugTest"));
            }
        }
        if (this.testcase.getTrouble() != null && this.testcase.getTrouble().getComparisonFailure() != null) {
            actions.add((Action)new DiffViewAction(this.testcase));
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public Action getPreferredAction() {
        return new JumpAction((Node)this, null);
    }

    public JUnitTestcase getTestcase() {
        return (JUnitTestcase)this.testcase;
    }

    private static ActionProvider getActionProvider(FileObject fileObject) {
        Project owner = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (owner == null) {
            return null;
        }
        return (ActionProvider)owner.getLookup().lookup(ActionProvider.class);
    }
}

