/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyFixnum;
import org.jruby.nb.RubyIO;
import org.jruby.nb.RubyModule;
import org.jruby.nb.RubyString;
import org.jruby.nb.anno.JRubyMethod;
import org.jruby.nb.anno.JRubyModule;
import org.jruby.nb.javasupport.util.RuntimeHelpers;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.marshal.MarshalStream;
import org.jruby.nb.runtime.marshal.UnmarshalStream;
import org.jruby.nb.util.IOInputStream;
import org.jruby.nb.util.IOOutputStream;
import org.jruby.util.ByteList;

@JRubyModule(name={"Marshal"})
public class RubyMarshal {
    public static RubyModule createMarshalModule(Ruby runtime) {
        RubyModule module = runtime.defineModule("Marshal");
        runtime.setMarshal(module);
        module.defineAnnotatedMethods(RubyMarshal.class);
        module.defineConstant("MAJOR_VERSION", runtime.newFixnum(4));
        module.defineConstant("MINOR_VERSION", runtime.newFixnum(8));
        return module;
    }

    @JRubyMethod(name={"dump"}, required=1, optional=2, frame=true, module=true)
    public static IRubyObject dump(IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        if (args.length < 1) {
            throw recv.getRuntime().newArgumentError("wrong # of arguments(at least 1)");
        }
        IRubyObject objectToDump = args[0];
        IRubyObject io = null;
        int depthLimit = -1;
        if (args.length >= 2) {
            if (args[1].respondsTo("write")) {
                io = args[1];
            } else if (args[1] instanceof RubyFixnum) {
                depthLimit = (int)((RubyFixnum)args[1]).getLongValue();
            } else {
                throw recv.getRuntime().newTypeError("Instance of IO needed");
            }
            if (args.length == 3) {
                depthLimit = (int)((RubyFixnum)args[2]).getLongValue();
            }
        }
        try {
            if (io != null) {
                RubyMarshal.dumpToStream(objectToDump, RubyMarshal.outputStream(io), depthLimit);
                return io;
            }
            ByteArrayOutputStream stringOutput = new ByteArrayOutputStream();
            RubyMarshal.dumpToStream(objectToDump, stringOutput, depthLimit);
            return RubyString.newString(recv.getRuntime(), new ByteList(stringOutput.toByteArray(), false));
        }
        catch (IOException ioe) {
            throw recv.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private static OutputStream outputStream(IRubyObject out) {
        RubyMarshal.setBinmodeIfPossible(out);
        if (out instanceof RubyIO) {
            return ((RubyIO)out).getOutStream();
        }
        return new IOOutputStream(out);
    }

    private static void setBinmodeIfPossible(IRubyObject io) {
        if (io.respondsTo("binmode")) {
            io.callMethod(io.getRuntime().getCurrentContext(), "binmode");
        }
    }

    @JRubyMethod(name={"load", "restore"}, required=1, optional=1, frame=true, module=true)
    public static IRubyObject load(ThreadContext context, IRubyObject recv, IRubyObject[] args, Block unusedBlock) {
        try {
            InputStream rawInput;
            if (args.length < 1) {
                throw recv.getRuntime().newArgumentError("wrong number of arguments (0 for 1)");
            }
            if (args.length > 2) {
                throw recv.getRuntime().newArgumentError("wrong number of arguments (" + args.length + " for 2)");
            }
            IRubyObject in = null;
            IRubyObject proc = null;
            switch (args.length) {
                case 2: {
                    proc = args[1];
                }
                case 1: {
                    in = args[0];
                }
            }
            if (in != null && in.respondsTo("read")) {
                rawInput = RubyMarshal.inputStream(in);
            } else if (in != null && in.respondsTo("to_str")) {
                RubyString inString = (RubyString)RuntimeHelpers.invoke(context, in, "to_str");
                ByteList bytes = inString.getByteList();
                rawInput = new ByteArrayInputStream(bytes.unsafeBytes(), bytes.begin(), bytes.length());
            } else {
                throw recv.getRuntime().newTypeError("instance of IO needed");
            }
            UnmarshalStream input = new UnmarshalStream(recv.getRuntime(), rawInput, proc);
            return input.unmarshalObject();
        }
        catch (EOFException ee) {
            throw recv.getRuntime().newEOFError();
        }
        catch (IOException ioe) {
            throw recv.getRuntime().newIOErrorFromException(ioe);
        }
    }

    private static InputStream inputStream(IRubyObject in) {
        RubyMarshal.setBinmodeIfPossible(in);
        if (in instanceof RubyIO) {
            return ((RubyIO)in).getInStream();
        }
        return new IOInputStream(in);
    }

    private static void dumpToStream(IRubyObject object, OutputStream rawOutput, int depthLimit) throws IOException {
        MarshalStream output = new MarshalStream(object.getRuntime(), rawOutput, depthLimit);
        output.dumpObject(object);
    }
}

