/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyProc;
import org.jruby.nb.common.IRubyWarnings;
import org.jruby.nb.exceptions.RaiseException;
import org.jruby.nb.internal.runtime.GlobalVariable;
import org.jruby.nb.internal.runtime.ReadonlyAccessor;
import org.jruby.nb.internal.runtime.UndefinedAccessor;
import org.jruby.nb.runtime.IAccessor;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class GlobalVariables {
    private Ruby runtime;
    private Map<String, GlobalVariable> globalVariables = new ConcurrentHashMap<String, GlobalVariable>();
    private IRubyObject defaultSeparator;

    public GlobalVariables(Ruby runtime) {
        this.runtime = runtime;
    }

    public void define(String name, IAccessor accessor) {
        assert (name != null);
        assert (accessor != null);
        assert (name.startsWith("$"));
        this.globalVariables.put(name, new GlobalVariable(accessor));
    }

    public void defineReadonly(String name, IAccessor accessor) {
        assert (name != null);
        assert (accessor != null);
        assert (name.startsWith("$"));
        this.globalVariables.put(name, new GlobalVariable(new ReadonlyAccessor(name, accessor)));
    }

    public boolean isDefined(String name) {
        assert (name != null);
        assert (name.startsWith("$"));
        GlobalVariable variable = this.globalVariables.get(name);
        return variable != null && !(variable.getAccessor() instanceof UndefinedAccessor);
    }

    public void alias(String name, String oldName) {
        assert (name != null);
        assert (oldName != null);
        assert (name.startsWith("$"));
        assert (oldName.startsWith("$"));
        if (this.runtime.getSafeLevel() >= 4) {
            throw this.runtime.newSecurityError("Insecure: can't alias global variable");
        }
        GlobalVariable oldVariable = this.createIfNotDefined(oldName);
        GlobalVariable variable = this.globalVariables.get(name);
        if (variable != null && oldVariable != variable && variable.isTracing()) {
            throw new RaiseException(this.runtime, this.runtime.getRuntimeError(), "can't alias in tracer", false);
        }
        this.globalVariables.put(name, oldVariable);
    }

    public IRubyObject get(String name) {
        assert (name != null);
        assert (name.startsWith("$"));
        GlobalVariable variable = this.globalVariables.get(name);
        if (variable != null) {
            return variable.getAccessor().getValue();
        }
        this.runtime.getWarnings().warning(IRubyWarnings.ID.GLOBAL_NOT_INITIALIZED, "global variable `" + name + "' not initialized", name);
        return this.runtime.getNil();
    }

    public IRubyObject set(String name, IRubyObject value) {
        assert (name != null);
        assert (name.startsWith("$"));
        if (this.runtime.getSafeLevel() >= 4) {
            throw this.runtime.newSecurityError("Insecure: can't change global variable value");
        }
        GlobalVariable variable = this.createIfNotDefined(name);
        IRubyObject result = variable.getAccessor().setValue(value);
        variable.trace(value);
        return result;
    }

    public void setTraceVar(String name, RubyProc proc) {
        assert (name != null);
        assert (name.startsWith("$"));
        GlobalVariable variable = this.createIfNotDefined(name);
        variable.addTrace(proc);
    }

    public boolean untraceVar(String name, IRubyObject command) {
        assert (name != null);
        assert (name.startsWith("$"));
        if (this.isDefined(name)) {
            GlobalVariable variable = this.globalVariables.get(name);
            return variable.removeTrace(command);
        }
        return false;
    }

    public void untraceVar(String name) {
        assert (name != null);
        assert (name.startsWith("$"));
        if (this.isDefined(name)) {
            GlobalVariable variable = this.globalVariables.get(name);
            variable.removeTraces();
        }
    }

    public Set<String> getNames() {
        return this.globalVariables.keySet();
    }

    private GlobalVariable createIfNotDefined(String name) {
        GlobalVariable variable = this.globalVariables.get(name);
        if (variable == null) {
            variable = GlobalVariable.newUndefined(this.runtime, name);
            this.globalVariables.put(name, variable);
        }
        return variable;
    }

    public IRubyObject getDefaultSeparator() {
        return this.defaultSeparator;
    }

    public void setDefaultSeparator(IRubyObject defaultSeparator) {
        this.defaultSeparator = defaultSeparator;
    }
}

