/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.internal.runtime.methods;

import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.internal.runtime.methods.CallConfiguration;
import org.jruby.nb.internal.runtime.methods.DynamicMethod;
import org.jruby.nb.runtime.Arity;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.RubyEvent;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.Visibility;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.callback.Callback;

public class SimpleCallbackMethod
extends DynamicMethod {
    private Callback callback;

    public SimpleCallbackMethod(RubyModule implementationClass, Callback callback, Visibility visibility) {
        super(implementationClass, visibility, CallConfiguration.NO_FRAME_NO_SCOPE);
        this.callback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule klazz, String name, IRubyObject[] args, Block block) {
        assert (args != null);
        Ruby runtime = context.getRuntime();
        if (runtime.hasEventHooks()) {
            runtime.callEventHooks(context, RubyEvent.C_CALL, context.getFile(), context.getLine(), name, this.getImplementationClass());
            try {
                IRubyObject iRubyObject = this.callback.execute(self, args, block);
                return iRubyObject;
            }
            finally {
                runtime.callEventHooks(context, RubyEvent.C_RETURN, context.getFile(), context.getLine(), name, this.getImplementationClass());
            }
        }
        return this.callback.execute(self, args, block);
    }

    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public Arity getArity() {
        return this.getCallback().getArity();
    }

    @Override
    public DynamicMethod dup() {
        return new SimpleCallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }
}

