/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.mobility.antext.preprocessor.CommentingPreProcessor;
import org.netbeans.modules.mobility.project.ProjectConfigurationsHelper;
import org.netbeans.modules.mobility.project.bridge.J2MEProjectUtilitiesProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.NbDocument;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class TextSwitcher
implements PropertyChangeListener {
    public static final String TEXT_SWITCH_SUPPORT = "TEXT_SWITCH_SUPPORT";
    public static final String SKIP_DUCUMENT_CHANGES = "SKIP_DUCUMENT_CHANGES";
    protected final Project p;
    protected final AntProjectHelper h;
    protected ProjectConfigurationsHelper pch;
    protected static RequestProcessor switchProcessor = new RequestProcessor("TEXT_SWITCH_SUPPORT");
    protected static Object lockObserver = new Object();

    public TextSwitcher(Project p, AntProjectHelper h) {
        this.p = p;
        this.h = h;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String changed = evt.getPropertyName();
        if (this.pch == null) {
            this.pch = (ProjectConfigurationsHelper)this.p.getLookup().lookup(ProjectConfigurationsHelper.class);
        }
        if (this.pch != null && this.pch.isPreprocessorOn() && ("activeConfiguration".equals(changed) || "ProjectProperties".equals(changed))) {
            new Runner((ProjectConfiguration)evt.getNewValue()).start();
        }
    }

    private class Runner
    implements Runnable {
        private final ProjectConfiguration selectedConfig;
        private HashSet<DataObject> processed;

        public Runner(ProjectConfiguration config) {
            this.selectedConfig = config;
        }

        public synchronized void start() {
            if (this.selectedConfig == null) {
                return;
            }
            switchProcessor.post((Runnable)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = lockObserver;
            synchronized (object) {
                this.processed = new HashSet();
                Node[] nodes = TopComponent.getRegistry().getActivatedNodes();
                for (int i = 0; i < nodes.length; ++i) {
                    DataObject dob = (DataObject)nodes[i].getCookie(DataObject.class);
                    if (!this.doSwitch(dob, false)) continue;
                    this.processed.add(dob);
                }
                if (this.processed == null) {
                    return;
                }
                String srcDir = TextSwitcher.this.h.getStandardPropertyEvaluator().getProperty("src.dir");
                if (srcDir == null) {
                    return;
                }
                FileObject src = TextSwitcher.this.h.resolveFileObject(srcDir);
                if (src == null || !src.isFolder()) {
                    return;
                }
                Enumeration ch = DataFolder.findFolder((FileObject)src).children(true);
                while (ch.hasMoreElements()) {
                    DataObject dob = (DataObject)ch.nextElement();
                    if (this.processed.contains(dob)) continue;
                    this.doSwitch(dob, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean doSwitch(DataObject dob, boolean force) {
            if (dob == null) {
                return false;
            }
            FileObject fo = dob.getPrimaryFile();
            if (!fo.getExt().equals("java") || !TextSwitcher.this.p.equals(FileOwnerQuery.getOwner((FileObject)fo))) {
                return false;
            }
            EditorCookie ec = (EditorCookie)dob.getCookie(EditorCookie.class);
            if (ec == null) {
                return false;
            }
            try {
                StyledDocument doc = force ? ec.openDocument() : ec.getDocument();
                J2MEProjectUtilitiesProvider utilProvider = (J2MEProjectUtilitiesProvider)Lookup.getDefault().lookup(J2MEProjectUtilitiesProvider.class);
                if (utilProvider == null) {
                    return false;
                }
                if (!utilProvider.isBaseDocument(doc)) {
                    return false;
                }
                CommentingPreProcessor.Source ppSrc = utilProvider.createPPDocumentSource(doc);
                CommentingPreProcessor.Destination ppDest = utilProvider.createPPDocumentDestination(doc);
                HashMap<String, String> identifiers = new HashMap<String, String>(TextSwitcher.this.pch.getActiveAbilities());
                identifiers.put(TextSwitcher.this.pch.getActiveConfiguration().getDisplayName(), null);
                CommentingPreProcessor cpp = new CommentingPreProcessor(ppSrc, ppDest, identifiers);
                try {
                    doc.putProperty(TextSwitcher.SKIP_DUCUMENT_CHANGES, TextSwitcher.SKIP_DUCUMENT_CHANGES);
                    NbDocument.runAtomic((StyledDocument)doc, (Runnable)cpp);
                }
                finally {
                    doc.putProperty(TextSwitcher.SKIP_DUCUMENT_CHANGES, null);
                }
                return true;
            }
            catch (FileStateInvalidException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
            return false;
        }
    }
}

