/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.wizard.imports;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mobility.project.J2MEProjectGenerator;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformInstallPanel;
import org.netbeans.modules.mobility.project.ui.wizard.PlatformSelectionPanel;
import org.netbeans.modules.mobility.project.ui.wizard.ProjectPanel;
import org.netbeans.modules.mobility.project.ui.wizard.imports.SourcesPanel;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class SourcesIterator
implements TemplateWizard.Iterator {
    private static final long serialVersionUID = 4519734756983L;
    boolean platformInstall;
    int currentIndex;
    PlatformInstallPanel.WizardPanel platformPanel;
    SourcesPanel.WizardPanel sourcesPanel;
    ProjectPanel.WizardPanel projectPanel;
    PlatformSelectionPanel psPanel;

    static Object create() {
        return new SourcesIterator();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel current() {
        if (this.platformInstall) {
            switch (this.currentIndex) {
                case 0: {
                    return this.platformPanel;
                }
                case 1: {
                    return this.sourcesPanel;
                }
                case 2: {
                    return this.projectPanel;
                }
                case 3: {
                    return this.psPanel;
                }
            }
        } else {
            switch (this.currentIndex) {
                case 0: {
                    return this.sourcesPanel;
                }
                case 1: {
                    return this.projectPanel;
                }
                case 2: {
                    return this.psPanel;
                }
            }
        }
        throw new IllegalStateException();
    }

    public boolean hasNext() {
        if (this.platformInstall) {
            return this.currentIndex < 3;
        }
        return this.currentIndex < 2;
    }

    public boolean hasPrevious() {
        return this.currentIndex > 0;
    }

    public void initialize(TemplateWizard templateWizard) {
        this.platformInstall = PlatformInstallPanel.isPlatformInstalled("j2me") ^ true;
        if (this.platformInstall) {
            this.platformPanel = new PlatformInstallPanel.WizardPanel("j2me");
            ((JComponent)this.platformPanel.getComponent()).putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(SourcesIterator.class, (String)"TXT_ExistingImport"));
        }
        this.sourcesPanel = new SourcesPanel.WizardPanel();
        ((JComponent)this.sourcesPanel.getComponent()).putClientProperty("NewProjectWizard_Title", NbBundle.getMessage(SourcesIterator.class, (String)"TXT_ExistingImport"));
        this.projectPanel = new ProjectPanel.WizardPanel(false, true);
        this.psPanel = new PlatformSelectionPanel();
        templateWizard.putProperty("RequiredConfiguration", null);
        templateWizard.putProperty("RequiredProfile", null);
        templateWizard.putProperty("PlatformDescription", null);
        this.currentIndex = 0;
        this.updateStepsList();
    }

    public void uninitialize(TemplateWizard templateWizard) {
        this.platformPanel = null;
        this.sourcesPanel = null;
        this.projectPanel = null;
        this.psPanel = null;
        this.currentIndex = -1;
    }

    public Set<DataObject> instantiate(TemplateWizard templateWizard) throws IOException {
        String sources = (String)templateWizard.getProperty("SourcesLocation");
        String jadLocation = (String)templateWizard.getProperty("JadLocation");
        File projectLocation = (File)templateWizard.getProperty("ProjectLocation");
        String name = (String)templateWizard.getProperty("ProjectName");
        PlatformSelectionPanel.PlatformDescription platform = (PlatformSelectionPanel.PlatformDescription)templateWizard.getProperty("PlatformDescription");
        if (platform == null) {
            this.psPanel.readSettings(templateWizard);
            this.psPanel.storeSettings(templateWizard);
            platform = (PlatformSelectionPanel.PlatformDescription)templateWizard.getProperty("PlatformDescription");
        }
        AntProjectHelper helper = J2MEProjectGenerator.createProjectFromSources(projectLocation, name, platform, sources, jadLocation);
        FileObject projectDir = helper.getProjectDirectory();
        return Collections.singleton(DataObject.find((FileObject)projectDir));
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        this.updateStepsList();
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.currentIndex;
        this.updateStepsList();
    }

    void updateStepsList() {
        JComponent component = (JComponent)this.current().getComponent();
        if (component == null) {
            return;
        }
        String[] list = this.platformInstall ? new String[]{NbBundle.getMessage(PlatformInstallPanel.class, (String)"TITLE_Platform"), NbBundle.getMessage(SourcesPanel.class, (String)"TITLE_Sources"), NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_PlatformSelection")} : new String[]{NbBundle.getMessage(SourcesPanel.class, (String)"TITLE_Sources"), NbBundle.getMessage(ProjectPanel.class, (String)"TITLE_Project"), NbBundle.getMessage(PlatformSelectionPanel.class, (String)"TITLE_PlatformSelection")};
        component.putClientProperty("WizardPanel_contentData", list);
        component.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(this.currentIndex));
    }
}

