/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util.swing;

public final class BlockCompare {
    private static final int BEFORE = 1;
    private static final int AFTER = 2;
    private static final int INSIDE = 4;
    private static final int CONTAINS = 8;
    private static final int OVERLAP_START = 16;
    private static final int OVERLAP_END = 32;
    private static final int EMPTY_X = 64;
    private static final int EMPTY_Y = 128;
    private final int value;

    public static BlockCompare get(int xStartOffset, int xEndOffset, int yStartOffset, int yEndOffset) {
        return new BlockCompare(BlockCompare.resolve(xStartOffset, xEndOffset, yStartOffset, yEndOffset));
    }

    private BlockCompare(int value) {
        this.value = value;
    }

    public boolean before() {
        return (this.value & 1) != 0;
    }

    public boolean after() {
        return (this.value & 2) != 0;
    }

    public boolean inside() {
        return (this.value & 4) != 0;
    }

    public boolean insideStrict() {
        return (this.value & 0xC) == 4;
    }

    public boolean contains() {
        return (this.value & 8) != 0;
    }

    public boolean containsStrict() {
        return (this.value & 0xC) == 8;
    }

    public boolean equal() {
        return (this.value & 0xC) == 12;
    }

    public boolean overlap() {
        return (this.value & 0x30) != 0;
    }

    public boolean overlapStart() {
        return (this.value & 0x10) != 0;
    }

    public boolean overlapEnd() {
        return (this.value & 0x20) != 0;
    }

    public boolean emptyX() {
        return (this.value & 0x40) != 0;
    }

    public boolean emptyY() {
        return (this.value & 0x80) != 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(50);
        this.appendBit(sb, 1, "BEFORE");
        this.appendBit(sb, 2, "AFTER");
        this.appendBit(sb, 8, "CONTAINS");
        this.appendBit(sb, 4, "INSIDE");
        this.appendBit(sb, 16, "OVERLAP_START");
        this.appendBit(sb, 32, "OVERLAP_END");
        this.appendBit(sb, 64, "EMPTY_X");
        this.appendBit(sb, 128, "EMPTY_Y");
        return sb.toString();
    }

    private void appendBit(StringBuilder sb, int bitValue, String bitText) {
        if ((this.value & bitValue) != 0) {
            if (sb.length() != 0) {
                sb.append('|');
            }
            sb.append(bitText);
        }
    }

    private static int resolve(int xStartOffset, int xEndOffset, int yStartOffset, int yEndOffset) {
        int value;
        assert (xStartOffset <= xEndOffset) : "xStartOffset=" + xStartOffset + " > xEndOffset=" + xEndOffset;
        assert (yStartOffset <= yEndOffset) : "yStartOffset=" + yStartOffset + " > yEndOffset=" + yEndOffset;
        if (xEndOffset < yStartOffset) {
            value = 1;
            if (xStartOffset == xEndOffset) {
                value |= 0x40;
            }
            if (yStartOffset == yEndOffset) {
                value |= 0x80;
            }
        } else if (xEndOffset == yStartOffset) {
            value = xStartOffset == xEndOffset ? (yStartOffset == yEndOffset ? 207 : 73) : (yStartOffset == yEndOffset ? 133 : 1);
        } else if (xStartOffset > yEndOffset) {
            value = 2;
            if (xStartOffset == xEndOffset) {
                value |= 0x40;
            }
            if (yStartOffset == yEndOffset) {
                value |= 0x80;
            }
        } else if (xStartOffset == yEndOffset) {
            value = xStartOffset == xEndOffset ? (yStartOffset == yEndOffset ? 207 : 74) : (yStartOffset == yEndOffset ? 143 : 2);
        } else {
            value = xStartOffset < yStartOffset ? (xEndOffset < yEndOffset ? 16 : 8) : (xStartOffset == yStartOffset ? (xEndOffset < yEndOffset ? 4 : (xEndOffset == yEndOffset ? 12 : 8)) : (xEndOffset <= yEndOffset ? 4 : 32));
            if (xStartOffset == xEndOffset) {
                value |= 0x40;
            }
            if (yStartOffset == yEndOffset) {
                value |= 0x80;
            }
        }
        return value;
    }
}

