/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.jrubyparser.ast.CallNode;
import org.jrubyparser.ast.ClassNode;
import org.jrubyparser.ast.FCallNode;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.CompletionProposal;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.CompletionRequest;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RubyBaseCompleter;
import org.netbeans.modules.ruby.RubyCompletionItem;
import org.netbeans.modules.ruby.RubyDeclarationFinder;
import org.netbeans.modules.ruby.RubyDynamicFindersCompleter;
import org.netbeans.modules.ruby.RubyParseResult;
import org.netbeans.modules.ruby.RubyParser;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeInferencer;
import org.netbeans.modules.ruby.RubyUtils;
import org.netbeans.modules.ruby.elements.IndexedClass;
import org.netbeans.modules.ruby.elements.IndexedConstant;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.lexer.Call;
import org.netbeans.modules.ruby.lexer.LexUtilities;
import org.netbeans.modules.ruby.lexer.RubyTokenId;

final class RubyMethodCompleter
extends RubyBaseCompleter {
    private static int callLineStart = -1;
    private static IndexedMethod callMethod;
    private final String fqn;
    private final Call call;

    static boolean complete(List<? super CompletionProposal> proposals, CompletionRequest request, String fqn, Call call, int anchor, boolean caseSensitive) {
        RubyMethodCompleter rsc = new RubyMethodCompleter(proposals, request, fqn, call, anchor, caseSensitive);
        return rsc.complete();
    }

    private RubyMethodCompleter(List<? super CompletionProposal> proposals, CompletionRequest request, String fqn, Call call, int anchor, boolean caseSensitive) {
        super(proposals, request, anchor, caseSensitive);
        this.fqn = fqn;
        this.call = call;
    }

    private boolean complete() {
        String prefix = this.request.prefix;
        int lexOffset = this.request.lexOffset;
        TokenHierarchy<Document> th = this.request.th;
        AstPath path = this.request.path;
        QuerySupport.Kind kind = this.request.kind;
        Node target = this.request.target != null ? AstUtilities.findNextNonNewLineNode(this.request.target) : null;
        TokenSequence<? extends RubyTokenId> ts = LexUtilities.getRubyTokenSequence(th, lexOffset);
        if (this.getIndex() == null || ts == null) {
            return false;
        }
        boolean skipPrivate = true;
        if (this.call == Call.LOCAL || this.call == Call.NONE) {
            return false;
        }
        boolean done = this.call.isMethodExpected();
        String lhs = this.call.getLhs();
        boolean skipInstanceMethods = this.call.isStatic();
        HashSet<IndexedMethod> methods = new HashSet<IndexedMethod>();
        RubyType type = RubyType.unknown();
        RubyType callType = this.call.getType();
        if (callType.isKnown() && !this.call.isLHSConstant()) {
            type = callType;
        }
        if (!type.isKnown() && lhs != null && target != null) {
            Node child;
            if (this.call.isSimpleIdentifier() || this.call.isLHSConstant()) {
                int lastColon2;
                Node method = AstUtilities.findLocalScope(target, path);
                String _lhs = lhs;
                if (this.call.isLHSConstant() && (lastColon2 = lhs.lastIndexOf("::")) != -1) {
                    _lhs = lhs.substring(lastColon2 + 2);
                }
                if (method != null) {
                    type = this.getTypesForConstant(lhs);
                    if (!type.isKnown()) {
                        type = this.getTypesForConstant(AstUtilities.getFqnName(path, lhs));
                    }
                    if (!type.isKnown()) {
                        type = RubyMethodCompleter.createTypeInferencer(this.request, method).inferType(_lhs);
                    }
                    if (type.isKnown() && this.call.isLHSConstant()) {
                        skipInstanceMethods = false;
                    }
                }
                if (!type.isKnown() && this.call.isLHSConstant() && callType != null) {
                    type = callType;
                }
            } else if (AstUtilities.isAssignmentNode(target) && !target.childNodes().isEmpty() && AstUtilities.isCall(child = (Node)target.childNodes().get(0))) {
                type = RubyTypeInferencer.create(this.request.createContextKnowledge(), false).inferType(child);
            }
        }
        if (!type.isKnown() && target != null && AstUtilities.isCall(target)) {
            type = this.getTypeForCall(target);
        }
        if (type.isKnown()) {
            if ("self".equals(lhs)) {
                type = RubyType.create(this.fqn);
                skipPrivate = true;
            } else if ("super".equals(lhs)) {
                skipPrivate = true;
                IndexedClass sc = this.getIndex().getSuperclass(this.fqn);
                if (sc != null) {
                    type = RubyType.create(sc.getFqn());
                } else {
                    ClassNode cls = AstUtilities.findClass(path);
                    if (cls != null) {
                        type = RubyType.create(AstUtilities.getSuperclass(cls));
                    }
                }
                if (!type.isKnown()) {
                    type = RubyType.OBJECT;
                }
            }
            if (type.isKnown()) {
                String _fqn = this.fqn;
                while (methods.isEmpty()) {
                    for (String realType : type.getRealTypes()) {
                        methods.addAll(this.getIndex().getInheritedMethods(_fqn + "::" + realType, prefix, kind));
                    }
                    int f = _fqn.lastIndexOf("::");
                    if (f == -1) break;
                    _fqn = _fqn.substring(0, f);
                }
                for (String realType : type.getRealTypes()) {
                    methods.addAll(this.getIndex().getInheritedMethods(realType, prefix, kind, true, true));
                }
            }
        }
        if (methods.isEmpty() || type.hasUnknownMember()) {
            methods.addAll(this.getIndex().getMethods(prefix, kind));
        }
        for (IndexedMethod method : RubyDynamicFindersCompleter.proposeDynamicMethods(methods, this.proposals, this.request, this.anchor)) {
            if (skipPrivate && method.isPrivate() && !"new".equals(method.getName()) || skipInstanceMethods && !method.isStatic() && !method.doesBelongToModule() || !skipInstanceMethods && method.doesBelongToModule() || !skipInstanceMethods && method.isStatic() || method.isNoDoc()) continue;
            if (method.getMethodType() == IndexedMethod.MethodType.DBCOLUMN) {
                RubyCompletionItem.DbItem item = new RubyCompletionItem.DbItem(method, method.getName(), method.getIn(), this.anchor, this.request);
                this.propose((CompletionProposal)item);
                continue;
            }
            RubyCompletionItem.MethodItem methodItem = new RubyCompletionItem.MethodItem(method, this.anchor, this.request);
            methodItem.setSmart(method.isSmart());
            this.propose((CompletionProposal)methodItem);
        }
        return done;
    }

    private RubyType getTypeForCall(Node target) {
        if ("".equals(this.request.prefix)) {
            Node realTarget = this.findClosestMatchingNode(target);
            if (realTarget != null) {
                target = realTarget;
            }
            return RubyTypeInferencer.create(this.request.createContextKnowledge(), false).inferType(target);
        }
        if (target instanceof CallNode) {
            Node receiver = ((CallNode)target).getReceiverNode();
            return RubyTypeInferencer.create(this.request.createContextKnowledge(), false).inferType(receiver);
        }
        IScopingNode clazz = AstUtilities.findClassOrModule(this.request.path);
        if (clazz != null) {
            return RubyType.create(AstUtilities.getClassOrModuleName(clazz));
        }
        return RubyType.unknown();
    }

    private Node findClosestMatchingNode(Node target) {
        int lastLeftParen;
        String name = AstUtilities.getCallName(target);
        String lhs = this.call.getLhs();
        if (lhs == null) {
            return target;
        }
        if (lhs.equals(name)) {
            return target;
        }
        int lastDot = lhs.lastIndexOf(".");
        if (lastDot != -1 && (lastLeftParen = (lhs = lhs.substring(lastDot + 1, lhs.length())).lastIndexOf("(")) != -1) {
            lhs = lhs.substring(lastLeftParen + 1, lhs.length());
        }
        if (name.equals(lhs)) {
            return target;
        }
        for (Node child : target.childNodes()) {
            if (!AstUtilities.isCall(child) || !lhs.equals(AstUtilities.getCallName(child))) continue;
            return child;
        }
        return null;
    }

    static boolean computeMethodCall(Parser.Result parserResult, int lexOffset, int astOffset, IndexedMethod[] methodHolder, int[] parameterIndexHolder, int[] anchorOffsetHolder, Set<IndexedMethod>[] alternativesHolder, QuerySupport.Kind kind) {
        try {
            boolean haveSanitizedComma;
            OffsetRange callRange;
            Node node;
            RubyParseResult rpr;
            OffsetRange range;
            Node root = AstUtilities.getRoot(parserResult);
            if (root == null) {
                return false;
            }
            IndexedMethod targetMethod = null;
            int index = -1;
            AstPath path = null;
            int originalAstOffset = astOffset;
            BaseDocument doc = RubyUtils.getDocument(parserResult, true);
            if (doc == null) {
                return false;
            }
            int newLexOffset = LexUtilities.findSpaceBegin(doc, lexOffset);
            if (newLexOffset < lexOffset) {
                astOffset -= lexOffset - newLexOffset;
            }
            if ((range = (rpr = AstUtilities.getParseResult(parserResult)).getSanitizedRange()) != OffsetRange.NONE && range.containsInclusive(astOffset) && astOffset != range.getStart()) {
                astOffset = range.getStart() - 1;
                if (astOffset < 0) {
                    astOffset = 0;
                }
                path = new AstPath(root, astOffset);
            }
            if (path == null) {
                path = new AstPath(root, astOffset);
            }
            int currentLineStart = Utilities.getRowStart((BaseDocument)doc, (int)lexOffset);
            if (callLineStart != -1 && currentLineStart == callLineStart) {
                targetMethod = callMethod;
            }
            Node call = null;
            int anchorOffset = -1;
            if (targetMethod != null) {
                ListIterator<Node> it = path.leafToRoot();
                String name = targetMethod.getName();
                while (it.hasNext()) {
                    Node argsNode;
                    node = (Node)it.next();
                    if (!AstUtilities.isCall(node) || !name.equals(AstUtilities.getCallName(node))) continue;
                    if (node.getNodeType() == NodeType.CALLNODE) {
                        argsNode = ((CallNode)node).getArgsNode();
                        if (argsNode == null) break;
                        index = AstUtilities.findArgumentIndex(argsNode, astOffset);
                        if (index == -1 && astOffset < originalAstOffset) {
                            index = AstUtilities.findArgumentIndex(argsNode, originalAstOffset);
                        }
                        if (index == -1) break;
                        call = node;
                        anchorOffset = argsNode.getPosition().getStartOffset();
                        break;
                    }
                    if (node.getNodeType() == NodeType.FCALLNODE) {
                        argsNode = ((FCallNode)node).getArgsNode();
                        if (argsNode == null) break;
                        index = AstUtilities.findArgumentIndex(argsNode, astOffset);
                        if (index == -1 && astOffset < originalAstOffset) {
                            index = AstUtilities.findArgumentIndex(argsNode, originalAstOffset);
                        }
                        if (index == -1) break;
                        call = node;
                        anchorOffset = argsNode.getPosition().getStartOffset();
                        break;
                    }
                    if (node.getNodeType() != NodeType.VCALLNODE) break;
                    callRange = AstUtilities.getCallRange(node);
                    AstUtilities.getCallName(node);
                    if (originalAstOffset <= callRange.getEnd()) break;
                    index = 0;
                    call = node;
                    anchorOffset = callRange.getEnd() + 1;
                    break;
                }
            }
            boolean bl = haveSanitizedComma = rpr.getSanitized() == RubyParser.Sanitize.EDITED_DOT || rpr.getSanitized() == RubyParser.Sanitize.ERROR_DOT;
            if (haveSanitizedComma && rpr.getSanitizedContents().indexOf(44) == -1) {
                haveSanitizedComma = false;
            }
            if (call == null) {
                ListIterator<Node> it = path.leafToRoot();
                block3: while (it.hasNext()) {
                    Node peek;
                    node = it.next();
                    if (kind == QuerySupport.Kind.EXACT && (node.getNodeType() == NodeType.ITERNODE || node.getNodeType() == NodeType.DEFNNODE || node.getNodeType() == NodeType.DEFSNODE)) break;
                    if (node.getNodeType() == NodeType.CALLNODE) {
                        Node argsNode;
                        callRange = AstUtilities.getCallRange(node);
                        if (haveSanitizedComma && originalAstOffset > callRange.getEnd() && it.hasNext()) {
                            for (int i = 0; i < 3 && it.hasNext(); ++i) {
                                peek = it.next();
                                if (!AstUtilities.isCall(peek) || Utilities.getRowStart((BaseDocument)doc, (int)LexUtilities.getLexerOffset(parserResult, peek.getPosition().getStartOffset())) != Utilities.getRowStart((BaseDocument)doc, (int)lexOffset)) continue;
                                if (!it.hasPrevious()) continue block3;
                                it.previous();
                                continue block3;
                            }
                        }
                        if ((argsNode = ((CallNode)node).getArgsNode()) != null) {
                            index = AstUtilities.findArgumentIndex(argsNode, astOffset);
                            if (index == -1 && astOffset < originalAstOffset) {
                                index = AstUtilities.findArgumentIndex(argsNode, originalAstOffset);
                            }
                            if (index == -1) continue;
                            call = node;
                            anchorOffset = argsNode.getPosition().getStartOffset();
                            break;
                        }
                        if (originalAstOffset <= callRange.getEnd()) continue;
                        index = 0;
                        call = node;
                        anchorOffset = callRange.getEnd() + 1;
                        break;
                    }
                    if (node.getNodeType() == NodeType.FCALLNODE) {
                        Node argsNode;
                        callRange = AstUtilities.getCallRange(node);
                        if (haveSanitizedComma && originalAstOffset > callRange.getEnd() && it.hasNext()) {
                            for (int i = 0; i < 3 && it.hasNext(); ++i) {
                                peek = it.next();
                                if (!AstUtilities.isCall(peek) || Utilities.getRowStart((BaseDocument)doc, (int)LexUtilities.getLexerOffset(parserResult, peek.getPosition().getStartOffset())) != Utilities.getRowStart((BaseDocument)doc, (int)lexOffset)) continue;
                                if (!it.hasPrevious()) continue block3;
                                it.previous();
                                continue block3;
                            }
                        }
                        if ((argsNode = ((FCallNode)node).getArgsNode()) == null) continue;
                        index = AstUtilities.findArgumentIndex(argsNode, astOffset);
                        if (index == -1 && astOffset < originalAstOffset) {
                            index = AstUtilities.findArgumentIndex(argsNode, originalAstOffset);
                        }
                        if (index == -1) continue;
                        call = node;
                        anchorOffset = argsNode.getPosition().getStartOffset();
                        break;
                    }
                    if (node.getNodeType() != NodeType.VCALLNODE) continue;
                    callRange = AstUtilities.getCallRange(node);
                    if (haveSanitizedComma && originalAstOffset > callRange.getEnd() && it.hasNext()) {
                        for (int i = 0; i < 3 && it.hasNext(); ++i) {
                            peek = it.next();
                            if (!AstUtilities.isCall(peek) || Utilities.getRowStart((BaseDocument)doc, (int)LexUtilities.getLexerOffset(parserResult, peek.getPosition().getStartOffset())) != Utilities.getRowStart((BaseDocument)doc, (int)lexOffset)) continue;
                            if (!it.hasPrevious()) continue block3;
                            it.previous();
                            continue block3;
                        }
                    }
                    if (originalAstOffset <= callRange.getEnd()) continue;
                    index = 0;
                    call = node;
                    anchorOffset = callRange.getEnd() + 1;
                    break;
                }
            }
            if (index != -1 && haveSanitizedComma && call != null) {
                Node an = null;
                if (call.getNodeType() == NodeType.FCALLNODE) {
                    an = ((FCallNode)call).getArgsNode();
                } else if (call.getNodeType() == NodeType.CALLNODE) {
                    an = ((CallNode)call).getArgsNode();
                }
                if (an != null && index < an.childNodes().size() && ((Node)an.childNodes().get(index)).getNodeType() == NodeType.HASHNODE) {
                    --index;
                }
                ++index;
            }
            if (call == null || index == -1) {
                callLineStart = -1;
                callMethod = null;
                return false;
            }
            if (targetMethod == null && (targetMethod = new RubyDeclarationFinder().findMethodDeclaration(parserResult, call, path, alternativesHolder)) == null) {
                return false;
            }
            callLineStart = currentLineStart;
            methodHolder[0] = callMethod = targetMethod;
            parameterIndexHolder[0] = index;
            if (anchorOffset == -1) {
                anchorOffset = call.getPosition().getStartOffset();
            }
            anchorOffsetHolder[0] = anchorOffset;
        }
        catch (BadLocationException ble) {
            return false;
        }
        return true;
    }

    private static RubyTypeInferencer createTypeInferencer(CompletionRequest request, Node target) {
        ContextKnowledge knowledge = request.createContextKnowledge();
        request.target = target;
        return RubyTypeInferencer.create(knowledge, false);
    }

    private RubyType getTypesForConstant(String constantFqn) {
        String module = RubyUtils.parseConstantName(constantFqn)[0];
        Set<? extends IndexedConstant> constants = this.getIndex().getConstants(constantFqn);
        for (IndexedConstant indexedConstant : constants) {
            RubyType type;
            if (!module.equals(indexedConstant.getFqn()) || !(type = indexedConstant.getType()).isKnown()) continue;
            return type;
        }
        return RubyType.unknown();
    }
}

