/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.cpu;

import java.awt.image.BufferedImage;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.components.FilterComponent;
import org.netbeans.lib.profiler.ui.cpu.CPUResUserActionsHandler;
import org.netbeans.lib.profiler.ui.cpu.CPUSelectionHandler;
import org.netbeans.lib.profiler.ui.cpu.FlatProfilePanel;
import org.netbeans.lib.profiler.ui.cpu.ScreenshotProvider;

public class SnapshotFlatProfilePanel
extends FlatProfilePanel
implements ScreenshotProvider {
    private CPUResultsSnapshot snapshot;

    public SnapshotFlatProfilePanel(CPUResUserActionsHandler actionsHandler) {
        this(actionsHandler, null);
    }

    public SnapshotFlatProfilePanel(CPUResUserActionsHandler actionsHandler, CPUSelectionHandler selectionHandler) {
        super(actionsHandler, selectionHandler);
    }

    public void exportData(int exportedFileType, ExportDataDumper eDD, boolean combine, String viewName) {
        this.percentFormat.setMinimumFractionDigits(2);
        this.percentFormat.setMaximumFractionDigits(2);
        switch (exportedFileType) {
            case 1: {
                this.exportCSV(",", eDD, combine);
                break;
            }
            case 2: {
                this.exportCSV(";", eDD, combine);
                break;
            }
            case 3: {
                this.exportXML(eDD, combine, viewName);
                break;
            }
            case 4: {
                this.exportHTML(eDD, combine, viewName);
            }
        }
        this.percentFormat.setMinimumFractionDigits(0);
        this.percentFormat.setMaximumFractionDigits(1);
    }

    private void exportHTML(ExportDataDumper eDD, boolean combine, String viewName) {
        int i;
        StringBuffer result = !combine ? new StringBuffer("<HTML><HEAD><meta http-equiv=\"Content-type\" content=\"text/html; charset=utf-8\" /><TITLE>" + viewName + "</TITLE><style type=\"text/css\">pre.method{overflow:auto;width:600;height:30;vertical-align:baseline}pre.parent{overflow:auto;width:400;height:30;vertical-align:baseline}td.method{text-align:left;width:600}td.parent{text-align:left;width:400}td.right{text-align:right;white-space:nowrap}</style></HEAD><BODY><TABLE border=\"1\"><tr>") : new StringBuffer("<br><br><TABLE border=\"1\"><tr>");
        for (i = 0; i < this.columnCount; ++i) {
            result.append("<th>" + this.columnNames[i] + "</th>");
        }
        result.append("</tr>");
        eDD.dumpData(result);
        for (i = 0; i < this.flatProfileContainer.getNRows(); ++i) {
            result = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">" + this.replaceHTMLCharacters(this.flatProfileContainer.getMethodNameAtRow(i)) + "</pre></td>");
            result.append("<td class=\"right\">" + this.percentFormat.format((double)this.flatProfileContainer.getPercentAtRow(i) / 100.0) + "</td>");
            result.append("<td class=\"right\">" + (double)this.flatProfileContainer.getTimeInMcs0AtRow(i) / 1000.0 + " ms</td>");
            result.append("<td class=\"right\">" + this.flatProfileContainer.getNInvocationsAtRow(i) + "</td></tr>");
            eDD.dumpData(result);
        }
        eDD.dumpDataAndClose(new StringBuffer(" </TABLE></BODY></HTML>"));
    }

    private void exportXML(ExportDataDumper eDD, boolean combine, String viewName) {
        int i;
        String newline = System.getProperty("line.separator");
        StringBuffer result = !combine ? new StringBuffer("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + newline + "<ExportedView Name=\"" + viewName + "\" type=\"table\">" + newline + " <TableData NumRows=\"" + this.flatProfileContainer.getNRows() + "\" NumColumns=\"4\">" + newline + "  <TableHeader>") : new StringBuffer(newline + "<TableData NumRows=\"" + this.flatProfileContainer.getNRows() + "\" NumColumns=\"4\">" + newline + "  <TableHeader>");
        for (i = 0; i < this.columnCount; ++i) {
            result.append("   <TableColumn><![CDATA[" + this.columnNames[i] + "]]></TableColumn>" + newline);
        }
        result.append("  </TableHeader>" + newline + "  <TableBody>" + newline);
        eDD.dumpData(result);
        for (i = 0; i < this.flatProfileContainer.getNRows(); ++i) {
            result = new StringBuffer("   <TableRow>" + newline + "    <TableColumn><![CDATA[" + this.flatProfileContainer.getMethodNameAtRow(i) + "]]></TableColumn>" + newline);
            result.append("    <TableColumn><![CDATA[" + this.percentFormat.format((double)this.flatProfileContainer.getPercentAtRow(i) / 100.0) + "]]></TableColumn>" + newline);
            result.append("    <TableColumn><![CDATA[" + (double)this.flatProfileContainer.getTimeInMcs0AtRow(i) / 1000.0 + " ms]]></TableColumn>" + newline);
            result.append("    <TableColumn><![CDATA[" + this.flatProfileContainer.getNInvocationsAtRow(i) + "]]></TableColumn>" + newline + "  </TableRow>" + newline);
            eDD.dumpData(result);
        }
        eDD.dumpDataAndClose(new StringBuffer("  </TableBody> </TableData>" + newline + "</ExportedView>"));
    }

    private void exportCSV(String separator, ExportDataDumper eDD, boolean combine) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        if (combine) {
            result.append(quote + quote + separator + quote + quote + separator + quote + quote + separator + quote + quote + newLine);
        }
        for (i = 0; i < this.columnCount; ++i) {
            result.append(quote + this.columnNames[i] + quote + separator);
        }
        result.deleteCharAt(result.length() - 1);
        result.append(newLine);
        eDD.dumpData(result);
        for (i = 0; i < this.flatProfileContainer.getNRows(); ++i) {
            result = new StringBuffer();
            result.append(quote + this.flatProfileContainer.getMethodNameAtRow(i) + quote + separator);
            result.append(quote + this.flatProfileContainer.getPercentAtRow(i) + quote + separator);
            result.append(quote + (double)this.flatProfileContainer.getTimeInMcs0AtRow(i) / 1000.0 + " ms" + quote + separator);
            result.append(quote + this.flatProfileContainer.getNInvocationsAtRow(i) + quote + newLine);
            eDD.dumpData(result);
        }
        eDD.close();
    }

    private String replaceHTMLCharacters(String s) {
        StringBuffer sb = new StringBuffer();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public BufferedImage getCurrentViewScreenshot(boolean onlyVisibleArea) {
        if (this.resTable == null) {
            return null;
        }
        if (onlyVisibleArea) {
            return UIUtils.createScreenshot(this.jScrollPane);
        }
        return UIUtils.createScreenshot(this.resTable);
    }

    public void setDataToDisplay(CPUResultsSnapshot snapshot, int threadId, int view) {
        this.snapshot = snapshot;
        this.currentView = view;
        this.threadId = threadId;
        this.flatProfileContainer = null;
        this.collectingTwoTimeStamps = snapshot.isCollectingTwoTimeStamps();
    }

    @Override
    public String getDefaultViewName() {
        return "cpu-hotspots";
    }

    public CPUResultsSnapshot getSnapshot() {
        return this.snapshot;
    }

    @Override
    public boolean fitsVisibleArea() {
        return !this.jScrollPane.getVerticalScrollBar().isEnabled();
    }

    @Override
    protected String[] getMethodClassNameAndSig(int methodId, int currentView) {
        return this.snapshot.getMethodClassNameAndSig(methodId, currentView);
    }

    @Override
    protected void obtainResults() {
        if (this.snapshot != null) {
            this.flatProfileContainer = this.snapshot.getFlatProfile(this.threadId, this.currentView);
        }
        if (this.snapshot == null || !this.collectingTwoTimeStamps && this.sortBy == 3) {
            this.sortBy = 2;
        }
        this.flatProfileContainer.filterOriginalData(FilterComponent.getFilterStrings(this.filterString), this.filterType, this.valueFilterValue);
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.setResultsAvailable(true);
    }

    @Override
    protected void showReverseCallGraph(int threadId, int methodId, int currentView, int sortingColumn, boolean sortingOrder) {
        this.actionsHandler.showReverseCallGraph(this.snapshot, threadId, methodId, currentView, sortingColumn, sortingOrder);
    }

    @Override
    protected boolean supportsReverseCallGraph() {
        return true;
    }

    @Override
    protected boolean supportsSubtreeCallGraph() {
        return false;
    }

    @Override
    protected void updateResults() {
        int currentColumnCount;
        if (this.threadId < -1) {
            return;
        }
        int n = currentColumnCount = this.collectingTwoTimeStamps ? 5 : 4;
        if (this.columnCount != currentColumnCount) {
            this.initColumnsData();
        } else if (this.resTable != null) {
            this.saveColumnsData();
        }
        this.flatProfileContainer.sortBy(this.sortBy, this.sortOrder);
        this.jScrollPane.setViewportView(this.resTable);
        this.jScrollPane.getViewport().setBackground(this.resTable.getBackground());
    }
}

