/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.transaction;

import java.util.Properties;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.transaction.TransactionManagerLookup;
import org.hibernate.util.ReflectHelper;

public final class TransactionManagerLookupFactory {
    private static final Log log = LogFactory.getLog((Class)TransactionManagerLookupFactory.class);

    private TransactionManagerLookupFactory() {
    }

    public static final TransactionManager getTransactionManager(Properties props) throws HibernateException {
        log.info((Object)"obtaining TransactionManager");
        return TransactionManagerLookupFactory.getTransactionManagerLookup(props).getTransactionManager(props);
    }

    public static final TransactionManagerLookup getTransactionManagerLookup(Properties props) throws HibernateException {
        String tmLookupClass = props.getProperty("hibernate.transaction.manager_lookup_class");
        if (tmLookupClass == null) {
            log.info((Object)"No TransactionManagerLookup configured (in JTA environment, use of read-write or transactional second-level cache is not recommended)");
            return null;
        }
        log.info((Object)("instantiating TransactionManagerLookup: " + tmLookupClass));
        try {
            TransactionManagerLookup lookup = (TransactionManagerLookup)ReflectHelper.classForName(tmLookupClass).newInstance();
            log.info((Object)"instantiated TransactionManagerLookup");
            return lookup;
        }
        catch (Exception e) {
            log.error((Object)"Could not instantiate TransactionManagerLookup", (Throwable)e);
            throw new HibernateException("Could not instantiate TransactionManagerLookup '" + tmLookupClass + "'");
        }
    }
}

