/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import java.beans.PropertyChangeListener;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeAttribute;
import org.netbeans.tax.TreeChild;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeParentNode;
import org.netbeans.tax.Util;
import org.netbeans.tax.event.TreeEvent;
import org.netbeans.tax.event.TreeEventChangeSupport;
import org.netbeans.tax.event.TreeEventManager;
import org.netbeans.tax.event.TreeEventModel;

public abstract class TreeObject
implements TreeEventModel {
    public static final String PROP_READ_ONLY = "readOnly";
    private boolean readOnly;
    private transient TreeEventChangeSupport eventChangeSupport;

    protected TreeObject() {
        this.readOnly = false;
        this.eventChangeSupport = null;
    }

    protected TreeObject(TreeObject object) {
        this.readOnly = object.readOnly;
        this.eventChangeSupport = null;
    }

    public abstract Object clone();

    protected final boolean isInstance(Object object) {
        return this.getClass().isInstance(object);
    }

    public abstract boolean isInContext();

    public abstract void removeFromContext() throws ReadOnlyException;

    public boolean equals(Object object) {
        return super.equals(object);
    }

    public boolean equals(Object object, boolean deep) {
        if (!this.isInstance(object)) {
            return false;
        }
        TreeObject peer = (TreeObject)object;
        return this.readOnly == peer.readOnly;
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        if (treeObject == this) {
            return;
        }
        this.checkMergeObject(treeObject);
        TreeObject peer = treeObject;
        this.setReadOnly(peer.isReadOnly());
    }

    protected final void checkMergeObject(TreeObject treeObject) throws CannotMergeException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeObject::checkMergeObject: this        = " + this);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("          ::checkMergeObject: treeObject  = " + treeObject);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("            checkMergeObject: isSameClass ? " + this.isInstance(treeObject));
        }
        if (treeObject == null || !this.isInstance(treeObject)) {
            throw new CannotMergeException(treeObject);
        }
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    protected void setReadOnly(boolean newReadOnly) {
        if (this.readOnly == newReadOnly) {
            return;
        }
        boolean oldReadOnly = this.readOnly;
        this.readOnly = newReadOnly;
        this.firePropertyChange(this.getEventChangeSupport().createEvent(PROP_READ_ONLY, oldReadOnly ? Boolean.TRUE : Boolean.FALSE, newReadOnly ? Boolean.TRUE : Boolean.FALSE));
    }

    protected final void checkReadOnly() throws ReadOnlyException {
        if (this.readOnly) {
            throw new ReadOnlyException(this);
        }
    }

    protected final TreeEventChangeSupport getEventChangeSupport() {
        if (this.eventChangeSupport == null) {
            this.eventChangeSupport = new TreeEventChangeSupport(this);
        }
        return this.eventChangeSupport;
    }

    public abstract TreeEventManager getEventManager();

    public final void addReadonlyChangeListener(PropertyChangeListener listener) {
        this.getEventChangeSupport().addPropertyChangeListener(PROP_READ_ONLY, listener);
    }

    public final void removeReadonlyChangeListener(PropertyChangeListener listener) {
        this.getEventChangeSupport().removePropertyChangeListener(PROP_READ_ONLY, listener);
    }

    public final void addPropertyChangeListener(PropertyChangeListener listener) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("Tree " + this + "attached listener" + listener);
        }
        this.getEventChangeSupport().addPropertyChangeListener(listener);
    }

    public final void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getEventChangeSupport().removePropertyChangeListener(listener);
    }

    protected final void firePropertyChange(TreeEvent evt) {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeObject firing " + evt);
        }
        this.getEventChangeSupport().firePropertyChange(evt);
        this.bubblePropertyChange(evt);
    }

    public final void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getEventChangeSupport().addPropertyChangeListener(propertyName, listener);
    }

    public final void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.getEventChangeSupport().removePropertyChangeListener(propertyName, listener);
    }

    public final boolean hasPropertyChangeListeners(String propertyName) {
        return this.getEventChangeSupport().hasPropertyChangeListeners(propertyName);
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.firePropertyChange(this.getEventChangeSupport().createEvent(propertyName, oldValue, newValue));
    }

    protected final void bubblePropertyChange(TreeEvent origEvt) {
        TreeObject source;
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nTreeObject [ " + this + " ]::bubblePropertyChange: origEvt = " + origEvt.getPropertyName());
        }
        if ((source = (TreeObject)origEvt.getSource()) instanceof TreeAttribute) {
            TreeAttribute attr = (TreeAttribute)source;
            TreeElement ownElem = attr.getOwnerElement();
            if (ownElem != null) {
                ownElem.firePropertyChange("attributes", attr, null);
            }
        } else if (source instanceof TreeChild) {
            while (source != null) {
                TreeChild child = (TreeChild)source;
                TreeParentNode parent = child.getParentNode();
                if (Util.THIS.isLoggable()) {
                    Util.THIS.debug("    ::bubblePropertyChange::parentNode = " + parent);
                }
                if (parent != null) {
                    parent.getEventChangeSupport().firePropertyChange(origEvt.createBubbling(parent));
                }
                source = parent;
            }
        }
    }

    public final String listListeners() {
        return this.getEventChangeSupport().listListeners();
    }
}

