/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler.ir;

import java.util.ArrayList;
import java.util.List;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.ir.CodeVersion;
import org.jruby.compiler.ir.IR_ExecutionScope;
import org.jruby.compiler.ir.IR_Module;
import org.jruby.compiler.ir.IR_Scope;
import org.jruby.compiler.ir.instructions.IR_Instr;
import org.jruby.compiler.ir.instructions.ReceiveArgumentInstruction;
import org.jruby.compiler.ir.operands.Label;
import org.jruby.compiler.ir.operands.MetaObject;
import org.jruby.compiler.ir.operands.Operand;

public class IRMethod
extends IR_ExecutionScope {
    public final String name;
    public final boolean isInstanceMethod;
    public final Label startLabel;
    public final Label endLabel;
    private CodeVersion version;
    private List<Operand> callArgs;

    public IRMethod(IR_Scope lexicalParent, Operand container, String name2, boolean isInstanceMethod) {
        super(lexicalParent, container);
        this.name = name2;
        this.isInstanceMethod = isInstanceMethod;
        this.startLabel = this.getNewLabel("_METH_START");
        this.endLabel = this.getNewLabel("_METH_END");
        this.callArgs = new ArrayList<Operand>();
        this.updateVersion();
    }

    public void updateVersion() {
        this.version = CodeVersion.getClassVersionToken();
    }

    public CodeVersion getVersion() {
        return this.version;
    }

    public void addInstr(IR_Instr i) {
        if (i instanceof ReceiveArgumentInstruction) {
            this.callArgs.add(i._result);
        }
        super.addInstr(i);
    }

    public Operand[] getCallArgs() {
        return this.callArgs.toArray(new Operand[this.callArgs.size()]);
    }

    public void setConstantValue(String constRef, Operand val) {
        if (!this.isAClassRootMethod()) {
            throw new NotCompilableException("Unexpected: Encountered set constant value in a method!");
        }
        ((MetaObject)this._container)._scope.setConstantValue(constRef, val);
    }

    public boolean isAClassRootMethod() {
        return IR_Module.isAClassRootMethod(this);
    }

    public String getFullyQualifiedName() {
        IR_Module m = this.getDefiningModule();
        return m == null ? null : m.getName() + ":" + this.getName();
    }

    public IR_Module getDefiningModule() {
        return this._container instanceof MetaObject ? (IR_Module)((MetaObject)this._container)._scope : null;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Method: " + this.getName() + super.toString();
    }
}

