/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump.dwarf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfAbbriviationTableEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfDeclaration;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ACCESS;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.ATTR;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfEntry {
    private final CompilationUnit compilationUnit;
    private final DwarfAbbriviationTableEntry abbriviationTableEntry;
    private final ArrayList<Object> values = new ArrayList();
    private final ArrayList<DwarfEntry> children = new ArrayList();
    private final long refference;
    private final int hierarchyLevel;
    private String qualifiedName = null;
    private String name = null;
    private DwarfEntry parent;

    public DwarfEntry(CompilationUnit compilationUnit, DwarfAbbriviationTableEntry abbrEntry, long refference, int hierarchyLevel) {
        this.abbriviationTableEntry = abbrEntry;
        this.compilationUnit = compilationUnit;
        this.refference = refference;
        this.hierarchyLevel = hierarchyLevel;
    }

    public TAG getKind() {
        return this.abbriviationTableEntry.getKind();
    }

    public String getName() throws IOException {
        if (this.name == null) {
            Object nameAttr = this.getAttributeValue(ATTR.DW_AT_name);
            this.name = nameAttr == null ? "" : this.stripComments((String)nameAttr);
        }
        return this.name;
    }

    public String getQualifiedName() throws IOException {
        if (this.qualifiedName == null) {
            DwarfEntry specification = this.getSpecification();
            if (specification != null) {
                return specification.getQualifiedName();
            }
            this.qualifiedName = this.constructQualifiedName();
        }
        return this.qualifiedName;
    }

    private String constructQualifiedName() throws IOException {
        if (this.parent == null) {
            return this.getName();
        }
        TAG kind = this.parent.getKind();
        switch (kind) {
            case DW_TAG_compile_unit: {
                return this.getName();
            }
            case DW_TAG_lexical_block: {
                return null;
            }
        }
        String aName = this.getName();
        String pname = this.parent.getQualifiedName();
        String qname = pname != null && aName != null && !pname.equals("") && !aName.equals("") ? pname + "::" + aName : null;
        return qname;
    }

    private String stripComments(String str) {
        if (str == null) {
            return null;
        }
        int idx = str.indexOf(35);
        if (idx != -1) {
            str = str.substring(0, idx);
        }
        return str.trim();
    }

    public void setQualifiedName(String qualifiedName) throws IOException {
        DwarfEntry specification;
        this.qualifiedName = qualifiedName;
        DwarfEntry origin = this.getAbstractOrigin();
        if (origin != null) {
            origin.setQualifiedName(qualifiedName);
        }
        if ((specification = this.getSpecification()) != null) {
            specification.setQualifiedName(qualifiedName);
        }
    }

    public String getType() throws IOException {
        return this.compilationUnit.getType(this);
    }

    public int getUintAttributeValue(ATTR attr) throws IOException {
        Object value = this.getAttributeValue(attr);
        if (value == null) {
            return -1;
        }
        int result = ((Number)value).intValue();
        if (result < 0) {
            result &= 0xFF;
        }
        return result;
    }

    public Object getAttributeValue(ATTR attr) throws IOException {
        return this.getAttributeValue(attr, true);
    }

    public Object getAttributeValue(ATTR attr, boolean recursive) throws IOException {
        Object attrValue = null;
        int attrIdx = this.abbriviationTableEntry.getAttribute(attr);
        if (attrIdx == -1) {
            if (recursive) {
                DwarfEntry attrEntry;
                Integer offset = -1;
                if (this.abbriviationTableEntry.getAttribute(ATTR.DW_AT_abstract_origin) >= 0) {
                    offset = (Integer)this.getAttributeValue(ATTR.DW_AT_abstract_origin);
                } else if (this.abbriviationTableEntry.getAttribute(ATTR.DW_AT_specification) >= 0) {
                    offset = (Integer)this.getAttributeValue(ATTR.DW_AT_specification);
                }
                if (offset >= 0 && (attrEntry = this.compilationUnit.getEntry(offset.intValue())) != null) {
                    attrValue = attrEntry.getAttributeValue(attr);
                }
            }
        } else {
            attrValue = this.values.get(attrIdx);
        }
        return attrValue;
    }

    public void addValue(Object value) {
        this.values.add(value);
    }

    public ArrayList<DwarfEntry> getChildren() {
        return this.children;
    }

    public DwarfEntry getDefinition() throws IOException {
        return this.compilationUnit.getDefinition(this);
    }

    public DwarfEntry getSpecification() throws IOException {
        Object o = this.getAttributeValue(ATTR.DW_AT_specification);
        if (o instanceof Integer) {
            return this.compilationUnit.getEntry(((Integer)o).intValue());
        }
        return null;
    }

    public DwarfEntry getAbstractOrigin() throws IOException {
        Object o = this.getAttributeValue(ATTR.DW_AT_abstract_origin);
        if (o instanceof Integer) {
            return this.compilationUnit.getEntry(((Integer)o).intValue());
        }
        return null;
    }

    public boolean hasChildren() {
        return this.abbriviationTableEntry.hasChildren();
    }

    public void addChild(DwarfEntry child) {
        this.children.add(child);
        child.setParent(this);
    }

    public DwarfEntry getParent() {
        return this.parent;
    }

    private void setParent(DwarfEntry parent) {
        this.parent = parent;
    }

    public long getRefference() {
        return this.refference;
    }

    public String getParametersString() throws IOException {
        return this.getParametersString(true);
    }

    public String getParametersString(boolean withNames) throws IOException {
        ArrayList<DwarfEntry> params = this.getParameters();
        StringBuilder paramStr = new StringBuilder();
        DwarfEntry param = null;
        paramStr.append('(');
        Iterator<DwarfEntry> it = params.iterator();
        while (it.hasNext()) {
            param = it.next();
            if (param.getKind().equals((Object)TAG.DW_TAG_unspecified_parameters)) {
                paramStr.append("...");
            } else {
                paramStr.append(param.getType());
                if (withNames) {
                    paramStr.append(" ");
                    paramStr.append(param.getName());
                }
            }
            if (!it.hasNext()) continue;
            paramStr.append(", ");
        }
        paramStr.append(')');
        return paramStr.toString();
    }

    public DwarfDeclaration getDeclaration() throws IOException {
        TAG kind = this.getKind();
        String aName = this.getQualifiedName();
        String type = this.getType();
        String paramStr = "";
        if (kind.equals((Object)TAG.DW_TAG_subprogram)) {
            paramStr = paramStr + this.getParametersString();
        }
        String declarationString = type + " " + (aName == null ? this.getName() : aName) + paramStr;
        int declarationLine = this.getLine();
        int declarationColumn = this.getColumn();
        String declarationPosition = (declarationLine == -1 ? "" : Integer.valueOf(declarationLine)) + (declarationColumn == -1 ? "" : ":" + declarationColumn);
        declarationPosition = declarationPosition + " <" + this.refference + " (0x" + Long.toHexString(this.refference) + ")>";
        return new DwarfDeclaration(kind.toString(), declarationString, this.getDeclarationFilePath(), declarationPosition);
    }

    public int getLine() throws IOException {
        return this.getUintAttributeValue(ATTR.DW_AT_decl_line);
    }

    public int getColumn() throws IOException {
        return this.getUintAttributeValue(ATTR.DW_AT_decl_column);
    }

    public ArrayList<DwarfEntry> getParameters() throws IOException {
        ArrayList<DwarfEntry> result = new ArrayList<DwarfEntry>();
        ArrayList<DwarfEntry> aChildren = this.getChildren();
        for (DwarfEntry child : aChildren) {
            if (!child.isParameter() || child.isArtifitial()) continue;
            result.add(child);
        }
        return result;
    }

    public ArrayList<DwarfEntry> getMembers() throws IOException {
        ArrayList<DwarfEntry> result = new ArrayList<DwarfEntry>();
        ArrayList<DwarfEntry> aChildren = this.getChildren();
        for (DwarfEntry child : aChildren) {
            if (!child.isMember() || child.isArtifitial()) continue;
            result.add(child);
        }
        return result;
    }

    public TAG getTag() {
        return this.abbriviationTableEntry.getKind();
    }

    public void dump(PrintStream out) {
        out.print("<" + this.hierarchyLevel + "><" + Long.toHexString(this.refference) + ">: ");
        this.abbriviationTableEntry.dump(out, this);
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).dump(out);
        }
    }

    public String toString() {
        ByteArrayOutputStream st = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(st);
        this.dump(out);
        return st.toString();
    }

    public boolean isArtifitial() throws IOException {
        Object isArt = this.getAttributeValue(ATTR.DW_AT_artificial);
        return isArt != null && (Boolean)isArt != false;
    }

    public boolean hasAbastractOrigin() throws IOException {
        Object abastractOrigin = this.getAttributeValue(ATTR.DW_AT_abstract_origin);
        return abastractOrigin != null;
    }

    public boolean isExternal() throws IOException {
        Object result = this.getAttributeValue(ATTR.DW_AT_external);
        return result != null && (Boolean)result != false;
    }

    public boolean isNamespace() {
        return this.getKind().equals((Object)TAG.DW_TAG_namespace);
    }

    public ACCESS getAccessibility() throws IOException {
        Object result = this.getAttributeValue(ATTR.DW_AT_accessibility);
        return result == null ? null : ACCESS.get(((Number)result).intValue());
    }

    public boolean isParameter() {
        TAG kind = this.getKind();
        return kind.equals((Object)TAG.DW_TAG_formal_parameter) || kind.equals((Object)TAG.DW_TAG_unspecified_parameters);
    }

    public boolean isMember() {
        TAG kind = this.getKind();
        return !kind.equals((Object)TAG.DW_TAG_inheritance);
    }

    public boolean isEntryDefinedInFile(int fileEntryIdx) throws IOException {
        int fileIdx = this.getUintAttributeValue(ATTR.DW_AT_decl_file);
        return fileIdx == fileEntryIdx;
    }

    public String getDeclarationFilePath() throws IOException {
        int fileIdx = this.getUintAttributeValue(ATTR.DW_AT_decl_file);
        return fileIdx <= 0 ? null : this.compilationUnit.getStatementList().getFilePath(fileIdx);
    }

    public String getTypeDef() throws IOException {
        if (this.getKind().equals((Object)TAG.DW_TAG_typedef)) {
            return this.getType();
        }
        Object typeRefIdx = this.getAttributeValue(ATTR.DW_AT_type);
        DwarfEntry typeRef = null;
        if (typeRefIdx instanceof Integer) {
            typeRef = this.compilationUnit.getTypedefFor(((Integer)typeRefIdx).intValue());
        } else if (typeRefIdx instanceof Long) {
            typeRef = this.compilationUnit.getTypedefFor((Long)typeRefIdx);
        }
        return typeRef == null ? this.getType() : typeRef.getType();
    }

    ArrayList<Object> getValues() {
        return this.values;
    }

    public long getLowAddress() throws IOException {
        byte[] bytes = (byte[])this.getAttributeValue(ATTR.DW_AT_low_pc);
        if (bytes != null) {
            return this.getAddress(bytes);
        }
        return 0L;
    }

    public long getHighAddress() throws IOException {
        byte[] bytes = (byte[])this.getAttributeValue(ATTR.DW_AT_high_pc);
        if (bytes != null) {
            return this.getAddress(bytes);
        }
        return 0L;
    }

    public long getAddress(byte[] bytes) {
        long n = 0L;
        int size = bytes.length;
        for (int i = 0; i < size; ++i) {
            long u = 0L;
            u = this.compilationUnit.getDataEncoding() == 1 ? (long)(0xFF & bytes[i]) : (long)(0xFF & bytes[size - i - 1]);
            n |= u << i * 8;
        }
        return n;
    }
}

