/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javacard.offcardverifier.exportfile;

import com.sun.javacard.offcardverifier.VerifierError;
import com.sun.javacard.offcardverifier.exportfile.EfConstant_Package;
import com.sun.javacard.offcardverifier.exportfile.ExportFile;

public class CompareVersion {
    private static boolean sameVersion = false;
    private static ExportFile latest;
    private static ExportFile old;

    public static void compare(ExportFile exportFile, ExportFile exportFile2) {
        CompareVersion.comparePackageNames(exportFile, exportFile2);
        CompareVersion.findNewer(exportFile, exportFile2);
        if (sameVersion) {
            VerifierError.generalMessage("MainRev.6");
            exportFile.checkEquality(exportFile2);
        } else {
            old.compareTo(latest);
        }
    }

    public static void comparePackageNames(ExportFile exportFile, ExportFile exportFile2) {
        if (!exportFile.thisName().equals(exportFile2.thisName())) {
            throw new VerifierError("RevisionError.40", (Object)exportFile.thisName(), (Object)exportFile2.thisName());
        }
    }

    private static void findNewer(ExportFile exportFile, ExportFile exportFile2) {
        short s = 0;
        short s2 = 0;
        short s3 = 0;
        short s4 = 0;
        s = ((EfConstant_Package)exportFile.constantPool[exportFile.thisPackage]).majorVersion;
        s2 = ((EfConstant_Package)exportFile2.constantPool[exportFile2.thisPackage]).majorVersion;
        if (s != s2) {
            throw new VerifierError("MajorVersion.1");
        }
        s3 = ((EfConstant_Package)exportFile.constantPool[exportFile.thisPackage]).minorVersion;
        s4 = ((EfConstant_Package)exportFile2.constantPool[exportFile2.thisPackage]).minorVersion;
        int n = s3 - s4;
        if (n > 1 || n < -1) {
            VerifierError.warning("RevisionWarning.1");
        }
        if (s3 == s4) {
            sameVersion = true;
        }
        if (s3 >= s4) {
            latest = exportFile;
            old = exportFile2;
        } else {
            latest = exportFile2;
            old = exportFile;
        }
    }
}

